/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.query.hql.internal;

import com.xpn.xwiki.internal.store.hibernate.query.HqlQueryUtils;
import java.util.List;
import java.util.Optional;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.query.Query;
import org.xwiki.query.QueryException;
import org.xwiki.query.hql.internal.HQLCompleteStatementValidator;
import org.xwiki.query.hql.internal.HQLStatementValidator;
import org.xwiki.query.internal.DefaultQuery;

@Component
@Singleton
public class DefaultHQLStatementValidator
implements HQLStatementValidator {
    private static final Pattern SAFE_ORDERBY_ELEMENT = Pattern.compile("\\A(\\w+\\.)?\\w+(\\s+\\w+)?\\z");
    @Inject
    @Named(value="context")
    private Provider<ComponentManager> componentManagerProvider;
    @Inject
    @Named(value="standard")
    private HQLCompleteStatementValidator standardValidator;

    @Override
    public boolean isSafe(String statement) throws QueryException {
        if (StringUtils.isEmpty((CharSequence)statement)) {
            return true;
        }
        String completeStatement = HqlQueryUtils.toCompleteStatement(statement);
        ComponentManager componentManager = (ComponentManager)this.componentManagerProvider.get();
        try {
            for (HQLCompleteStatementValidator validator : componentManager.getInstanceList(HQLCompleteStatementValidator.class)) {
                Optional<Boolean> result = validator.isSafe(completeStatement);
                if (!result.isPresent()) continue;
                return result.get();
            }
        }
        catch (ComponentLookupException e) {
            throw new QueryException("Failed to get query statement validators", (Query)new DefaultQuery(completeStatement, "hql", null), (Throwable)e);
        }
        Optional<Boolean> result = this.standardValidator.isSafe(completeStatement);
        if (result.isPresent()) {
            return result.get();
        }
        return false;
    }

    @Override
    public void checkOrderBySafe(List<String> allowedPrefixes, String orderByValue) throws QueryException {
        if (StringUtils.isBlank((CharSequence)orderByValue)) {
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(orderByValue, ",");
        while (tokenizer.hasMoreTokens()) {
            String orderByColumn = tokenizer.nextToken().trim();
            boolean valid = false;
            if (SAFE_ORDERBY_ELEMENT.matcher(orderByColumn).matches()) {
                valid = this.isValidOrderBy(allowedPrefixes, orderByColumn);
            }
            if (valid) continue;
            throw new QueryException("Unsafe ORDER BY value [" + orderByValue + "].", null);
        }
    }

    private boolean isValidOrderBy(List<String> allowedPrefixes, String orderByColumn) {
        if (CollectionUtils.isEmpty(allowedPrefixes)) {
            return true;
        }
        for (String allowedPrefix : allowedPrefixes) {
            if (!orderByColumn.startsWith(allowedPrefix)) continue;
            return true;
        }
        return false;
    }
}

