/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.model.validation.edit;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.api.Document;
import com.xpn.xwiki.doc.XWikiDocument;
import java.util.Optional;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.validation.edit.EditConfirmationChecker;
import org.xwiki.model.validation.edit.EditConfirmationCheckerResult;
import org.xwiki.rendering.block.Block;
import org.xwiki.template.TemplateManager;

@Component
@Singleton
@Named(value="documentLock")
@Priority(value=2000)
public class XWikiDocumentLockEditConfirmationChecker
implements EditConfirmationChecker {
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    private TemplateManager templateManager;

    public Optional<EditConfirmationCheckerResult> check() {
        XWikiContext context = (XWikiContext)this.xcontextProvider.get();
        XWikiDocument tdoc = (XWikiDocument)context.get("tdoc");
        Optional<EditConfirmationCheckerResult> result = new Document(tdoc, context).getLocked() ? Optional.of(new EditConfirmationCheckerResult(this.renderMessage(), false)) : Optional.empty();
        return result;
    }

    private Block renderMessage() {
        return this.templateManager.executeNoException("edit_confirmation/lock.vm");
    }
}

