/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.internal.web;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.web.XWikiRequest;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.internal.web.DocExistValidator;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;

@Component
@Singleton
@Named(value="get")
public class GetDocExistValidator
implements DocExistValidator {
    @Inject
    @Named(value="currentmixed")
    private DocumentReferenceResolver<String> currentmixedReferenceResolver;
    @Inject
    private Logger logger;

    @Override
    public boolean docExist(XWikiDocument doc, XWikiContext context) {
        boolean result = false;
        if (doc.isNew()) {
            XWikiRequest request = context.getRequest();
            String sheet = request.get("sheet");
            if (!StringUtils.isEmpty((CharSequence)sheet)) {
                DocumentReference sheetReference = this.currentmixedReferenceResolver.resolve((Object)sheet, new Object[0]);
                try {
                    XWikiDocument sheetDoc = context.getWiki().getDocument(sheetReference, context);
                    result = sheetDoc.isNew();
                }
                catch (XWikiException e) {
                    this.logger.warn("Error while trying to load sheet [{}] for checking status code on GET request for [{}]: [{}]", new Object[]{sheetReference, doc.getDocumentReference(), ExceptionUtils.getRootCauseMessage((Throwable)e)});
                    result = true;
                }
            } else {
                result = !"1".equals(request.get("disableCheckNotExisting"));
            }
        }
        return result;
    }
}

