/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.internal.web;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.web.XWikiRequest;
import com.xpn.xwiki.web.XWikiServletRequest;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.bridge.event.ActionExecutingEvent;
import org.xwiki.component.annotation.Component;
import org.xwiki.observation.event.AbstractLocalEventListener;
import org.xwiki.observation.event.Event;
import org.xwiki.user.CurrentUserReference;
import org.xwiki.user.UserReference;
import org.xwiki.user.UserReferenceResolver;

@Component
@Singleton
@Named(value="org.xwiki.internal.web.EffectiveAuthorSetterListener")
public class EffectiveAuthorSetterListener
extends AbstractLocalEventListener {
    public static final String HINT = "org.xwiki.internal.web.EffectiveAuthorSetterListener";
    @Inject
    private Logger logger;
    @Inject
    private UserReferenceResolver<CurrentUserReference> currentUserResolver;
    @Inject
    private Provider<XWikiContext> xcontextProvider;

    public EffectiveAuthorSetterListener() {
        super(HINT, new Event[]{new ActionExecutingEvent()});
    }

    public void processLocalEvent(Event event, Object source, Object data) {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        XWikiRequest request = xcontext.getRequest();
        if (request.getAttribute(XWikiServletRequest.ATTRIBUTE_EFFECTIVE_AUTHOR) == null) {
            UserReference authenticatedUser = this.currentUserResolver.resolve((Object)CurrentUserReference.INSTANCE, new Object[0]);
            this.logger.debug("Setting the effective author of the request to the currently authenticated user [{}].", (Object)authenticatedUser);
            request.setAttribute(XWikiServletRequest.ATTRIBUTE_EFFECTIVE_AUTHOR, authenticatedUser);
        }
    }
}

