/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.internal.template;

import com.xpn.xwiki.XWikiContext;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.template.Template;
import org.xwiki.template.TemplateRequirement;
import org.xwiki.template.TemplateRequirementException;

@Component
@Singleton
@Named(value="action")
public class ActionTemplateRequirement
implements TemplateRequirement {
    @Inject
    @Named(value="readonly")
    private Provider<XWikiContext> xcontextProvider;

    public void checkRequirement(String requirement, String value, Template template) throws TemplateRequirementException {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        String action = null;
        if (xcontext != null) {
            action = xcontext.getAction();
        }
        if (action == null) {
            action = "";
        }
        if (!value.matches(action)) {
            throw new TemplateRequirementException("template.error.requirement.action", "Action [{}] does not match action requirement [{}].", new Object[]{action, value});
        }
    }
}

