/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.internal.script;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.Context;
import com.xpn.xwiki.api.Document;
import com.xpn.xwiki.api.Util;
import com.xpn.xwiki.api.XWiki;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.render.ScriptXWikiServletRequest;
import com.xpn.xwiki.render.ScriptXWikiServletResponse;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.script.ScriptContext;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.script.ScriptContextInitializer;
import org.xwiki.security.authorization.ContextualAuthorizationManager;

@Component
@Named(value="xwiki")
@Singleton
public class XWikiScriptContextInitializer
implements ScriptContextInitializer {
    private static final String CKEY_UTIL = "util";
    @Inject
    private Logger logger;
    @Inject
    private ContextualAuthorizationManager authorization;
    @Inject
    private Provider<XWikiContext> xcontextProvider;

    public void initialize(ScriptContext scriptContext) {
        XWikiDocument sdoc;
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        if (scriptContext.getAttribute(CKEY_UTIL) == null) {
            scriptContext.setAttribute(CKEY_UTIL, new Util(xcontext.getWiki(), xcontext), 100);
            scriptContext.setAttribute("xwiki", new XWiki(xcontext.getWiki(), xcontext), 100);
            scriptContext.setAttribute("xcontext", new Context(xcontext), 100);
        }
        if (xcontext.getRequest() != null) {
            scriptContext.setAttribute("request", new ScriptXWikiServletRequest(xcontext.getRequest(), this.authorization), 100);
        }
        if (xcontext.getResponse() != null) {
            scriptContext.setAttribute("response", new ScriptXWikiServletResponse(xcontext.getResponse()), 100);
        }
        Document docAPI = null;
        XWikiDocument doc = xcontext.getDoc();
        if (doc != null) {
            docAPI = this.setDocument(scriptContext, "doc", doc, xcontext);
            XWikiDocument tdoc = (XWikiDocument)xcontext.get("tdoc");
            if (tdoc == null) {
                try {
                    tdoc = doc.getTranslatedDocument(xcontext);
                }
                catch (XWikiException e) {
                    this.logger.warn("Failed to retrieve the translated document for [{}]. Continue using the default translation.", (Object)doc.getDocumentReference(), (Object)e);
                    tdoc = doc;
                }
            }
            Document tdocAPI = this.setDocument(scriptContext, "tdoc", tdoc, xcontext);
            XWikiDocument cdoc = (XWikiDocument)xcontext.get("cdoc");
            if (cdoc == null) {
                Document cdocAPI = tdocAPI;
                if (cdocAPI == null) {
                    cdocAPI = docAPI;
                }
                scriptContext.setAttribute("cdoc", cdocAPI, 100);
            } else {
                this.setDocument(scriptContext, "cdoc", cdoc, xcontext);
            }
        }
        if ((sdoc = (XWikiDocument)xcontext.get("sdoc")) == null) {
            scriptContext.setAttribute("sdoc", docAPI, 100);
        } else {
            this.setDocument(scriptContext, "sdoc", sdoc, xcontext);
        }
        scriptContext.setAttribute("locale", xcontext.getLocale(), 100);
    }

    private Document setDocument(ScriptContext scriptContext, String key, XWikiDocument document, XWikiContext xcontext) {
        Document apiDocument = (Document)scriptContext.getAttribute(key);
        if (apiDocument == null || !apiDocument.same(document)) {
            apiDocument = document.newDocument(xcontext);
            scriptContext.setAttribute(key, apiDocument, 100);
        }
        return apiDocument;
    }
}

