/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.internal.model.reference;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.PageReference;

@Component
@Named(value="current")
@Singleton
public class CurrentPageReferenceDocumentReferenceResolver
implements DocumentReferenceResolver<PageReference> {
    @Inject
    @Named(value="current")
    private DocumentReferenceResolver<EntityReference> currentReferenceDocumentReferenceResolver;
    @Inject
    private DocumentAccessBridge dab;
    @Inject
    private Logger logger;

    public DocumentReference resolve(PageReference reference, Object ... parameters) {
        DocumentReference result;
        DocumentReference documentReference = this.currentReferenceDocumentReferenceResolver.resolve((Object)reference, new Object[0]);
        if (this.exists(documentReference)) {
            result = documentReference;
        } else if (documentReference.getParent().getParent().getType() == EntityType.SPACE) {
            result = new DocumentReference(documentReference.getParent().getName(), documentReference.getParent().getParent(), documentReference.getParameters());
            if (!this.exists(result)) {
                result = documentReference;
            }
        } else {
            result = documentReference;
        }
        return result;
    }

    private boolean exists(DocumentReference documentReference) {
        try {
            return this.dab.exists(documentReference);
        }
        catch (Exception e) {
            this.logger.error("Failed to check the existence of the document with reference [{}]", (Object)documentReference, (Object)e);
            return false;
        }
    }
}

