/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.internal.migration;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.index.IndexException;
import org.xwiki.index.TaskConsumer;
import org.xwiki.internal.migration.InvitationInternalDocumentParameterEscapingFixer;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.rendering.syntax.Syntax;

@Component
@Singleton
@Named(value="internal-document-parameter-escaping")
public class InvitationInternalDocumentParameterEscapingTaskConsumer
implements TaskConsumer {
    public static final String HINT = "internal-document-parameter-escaping";
    @Inject
    private Logger logger;
    @Inject
    private Provider<XWikiContext> contextProvider;
    @Inject
    private InvitationInternalDocumentParameterEscapingFixer invitationInternalDocumentParameterEscapingFixer;

    public void consume(DocumentReference documentReference, String version) throws IndexException {
        try {
            XWikiContext context = (XWikiContext)this.contextProvider.get();
            this.task(context.getWiki().getDocument(documentReference, context));
        }
        catch (XWikiException e) {
            throw new IndexException(String.format("Failed to resolve document [%s]", documentReference), (Throwable)e);
        }
    }

    private void task(XWikiDocument document) {
        Syntax syntax = document.getSyntax();
        if (List.of(Syntax.XWIKI_2_1, Syntax.XWIKI_2_0).contains(syntax)) {
            try {
                this.invitationInternalDocumentParameterEscapingFixer.fix(document.getContent(), document.getSyntax()).ifPresent(content -> {
                    document.setContent((String)content);
                    try {
                        XWikiContext context = (XWikiContext)this.contextProvider.get();
                        context.getWiki().saveDocument(document, "Automatic bad escaping fix.", true, context);
                        this.logger.info("[{}] successfully fixed.", (Object)document);
                    }
                    catch (XWikiException e) {
                        this.logger.error("Failed to save document [{}]", (Object)document, (Object)e);
                    }
                });
            }
            catch (Exception e) {
                this.logger.error("Unexpected error while fixing [{}]", (Object)document, (Object)e);
            }
        } else {
            this.logger.warn("[{}] skipped because escaping for syntax [{}] is not supported. It is advised to review this file.", (Object)document, (Object)syntax);
        }
    }
}

