/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.internal.document;

import com.google.common.util.concurrent.Striped;
import com.xpn.xwiki.doc.XWikiDocument;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import javax.inject.Inject;
import org.apache.commons.lang3.function.FailableFunction;
import org.xwiki.bridge.event.DocumentCreatedEvent;
import org.xwiki.bridge.event.DocumentDeletedEvent;
import org.xwiki.bridge.event.DocumentUpdatedEvent;
import org.xwiki.cache.Cache;
import org.xwiki.cache.CacheException;
import org.xwiki.cache.CacheManager;
import org.xwiki.cache.config.CacheConfiguration;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.component.phase.Disposable;
import org.xwiki.internal.document.SimpleDocumentCache;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.observation.AbstractEventListener;
import org.xwiki.observation.EventListener;
import org.xwiki.observation.ObservationManager;
import org.xwiki.observation.event.Event;

@Component
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class DefaultSimpleDocumentCache<C, E extends Throwable>
implements Disposable,
SimpleDocumentCache<C, E> {
    @Inject
    private ObservationManager observationManager;
    @Inject
    private CacheManager cacheManager;
    @Inject
    private EntityReferenceSerializer<String> serializer;
    private Cache<C> cache;
    private Listener listener;
    private final Striped<ReadWriteLock> locks = Striped.readWriteLock((int)16);

    @Override
    public synchronized void initializeCache(CacheConfiguration cacheConfiguration) throws CacheException {
        if (this.cache != null) {
            this.dispose();
        }
        this.cache = this.cacheManager.createNewCache(cacheConfiguration);
        this.listener = new Listener(cacheConfiguration.getConfigurationId());
        this.observationManager.addListener((EventListener)this.listener, 100);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public C get(DocumentReference documentReference, FailableFunction<DocumentReference, C, E> provider) throws E {
        String key = this.getKey(documentReference);
        Object result = this.cache.get(key);
        if (result == null) {
            Lock lock = ((ReadWriteLock)this.locks.get((Object)key)).readLock();
            lock.lock();
            try {
                result = provider.apply((Object)documentReference);
                this.cache.set(key, result);
            }
            finally {
                lock.unlock();
            }
        }
        return (C)result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(DocumentReference documentReference) {
        String key = this.getKey(documentReference);
        Lock lock = ((ReadWriteLock)this.locks.get((Object)key)).writeLock();
        lock.lock();
        try {
            this.cache.remove(key);
        }
        finally {
            lock.unlock();
        }
    }

    private String getKey(DocumentReference documentReference) {
        return (String)this.serializer.serialize((EntityReference)documentReference, new Object[0]);
    }

    public void dispose() {
        if (this.cache != null) {
            this.cache.dispose();
        }
        this.observationManager.removeListener(this.listener.getName());
    }

    private class Listener
    extends AbstractEventListener {
        Listener(String name) {
            super(name, new Event[]{new DocumentCreatedEvent(), new DocumentUpdatedEvent(), new DocumentDeletedEvent()});
        }

        public void onEvent(Event event, Object source, Object data) {
            XWikiDocument doc = (XWikiDocument)source;
            DefaultSimpleDocumentCache.this.remove(doc.getDocumentReference());
        }
    }
}

