/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.web.includeservletasstring;

import com.xpn.xwiki.web.includeservletasstring.BufferedResponse;
import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncludeServletAsString {
    private static final Logger LOGGER = LoggerFactory.getLogger(IncludeServletAsString.class);

    private IncludeServletAsString() {
    }

    public static String invokeServletAndReturnAsString(String url, HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws IOException, ServletException {
        RequestDispatcher requestDispatcher;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Including url \"" + url + "\"...");
        }
        if ((requestDispatcher = servletRequest.getRequestDispatcher(url)) == null) {
            IllegalArgumentException iae = new IllegalArgumentException("Failed to get RequestDispatcher for url: " + url);
            LOGGER.error(iae.getMessage(), (Throwable)iae);
            throw iae;
        }
        BufferedResponse bufferedResponse = new BufferedResponse(servletResponse);
        requestDispatcher.include((ServletRequest)servletRequest, (ServletResponse)bufferedResponse);
        byte[] buffer = bufferedResponse.getBufferAsByteArray();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Buffer returned with " + buffer.length + " bytes.");
        }
        String bufferString = new String(buffer, servletResponse.getCharacterEncoding());
        return bufferString;
    }
}

