/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.web;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.DeletedAttachment;
import com.xpn.xwiki.doc.XWikiAttachment;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.web.Utils;
import com.xpn.xwiki.web.XWikiDefaultURLFactory;
import com.xpn.xwiki.web.XWikiRequest;
import com.xpn.xwiki.web.XWikiServletRequestStub;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.container.servlet.HttpServletUtils;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceResolver;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.model.reference.SpaceReference;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.resource.internal.entity.EntityResourceActionLister;

@Deprecated(since="17.0.0RC1")
public class XWikiServletURLFactory
extends XWikiDefaultURLFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(XWikiServletURLFactory.class);
    private EntityReferenceResolver<String> relativeEntityReferenceResolver;
    private EntityReferenceResolver<String> currentEntityReferenceResolver;
    private EntityResourceActionLister actionLister;
    protected boolean daemon;
    protected URL originalURL;
    @Deprecated
    protected String defaultURL;
    protected Map<String, URL> defaultURLs;
    protected String contextPath;

    public XWikiServletURLFactory() {
    }

    public XWikiServletURLFactory(URL defaultURL, String contextPath, String actionPath) {
        this.contextPath = contextPath;
        this.originalURL = defaultURL;
    }

    public XWikiServletURLFactory(XWikiContext context) {
        this.init(context);
    }

    @Override
    public void init(XWikiContext context) {
        this.defaultURLs = null;
        this.originalURL = null;
        this.contextPath = context.getWiki().getWebAppPath(context);
        URL homepageConfigration = XWikiServletURLFactory.getXWikiHomeParameter(context);
        this.setDefaultURL(null, homepageConfigration);
        XWikiRequest request = context.getRequest();
        this.daemon = request.getHttpServletRequest() instanceof XWikiServletRequestStub && ((XWikiServletRequestStub)request.getHttpServletRequest()).isDaemon();
        this.originalURL = homepageConfigration != null && context.isMainWiki() ? homepageConfigration : HttpServletUtils.getSourceBaseURL((HttpServletRequest)context.getRequest());
        if (!this.daemon) {
            URL defaultWikiURL = this.originalURL;
            String protocolConfiguration = context.getWiki().Param("xwiki.url.protocol");
            if (StringUtils.isNotEmpty((CharSequence)protocolConfiguration)) {
                try {
                    defaultWikiURL = new URL(protocolConfiguration, this.originalURL.getHost(), this.originalURL.getPort(), "");
                }
                catch (MalformedURLException e) {
                    LOGGER.warn("The configured protocol [{}] produce an invalid URL: {}", (Object)protocolConfiguration, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
                }
            }
            this.defaultURL = defaultWikiURL.toString();
            this.setDefaultURL(context.getOriginalWikiId(), defaultWikiURL);
        }
    }

    private URL getOriginalURL(XWikiContext xcontext) {
        URL url = null;
        if (this.daemon) {
            try {
                url = xcontext.getWiki().getServerURL(xcontext.getWikiId(), xcontext);
            }
            catch (MalformedURLException e) {
                LOGGER.warn("Can't get the standard URL for wiki [{}]: {}", (Object)xcontext.getWikiId(), (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            }
        }
        return url != null ? url : this.originalURL;
    }

    public void setDefaultURL(String wikiId, URL baseURL) {
        if (this.defaultURLs == null) {
            this.defaultURLs = new HashMap<String, URL>();
        }
        this.defaultURLs.put(wikiId, baseURL);
    }

    protected URL getDefaultURL(String wikiId, XWikiContext xcontext) {
        if (this.defaultURLs == null) {
            return this.getOriginalURL(xcontext);
        }
        URL url = this.defaultURLs.get(wikiId);
        if (url != null) {
            return url;
        }
        if (xcontext.isMainWiki(wikiId)) {
            return this.defaultURLs.get(null);
        }
        return null;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    private static URL getXWikiHomeParameter(XWikiContext context) {
        String surl = XWikiServletURLFactory.getXWikiHomeParameterAsString(context);
        if (StringUtils.isNotEmpty((CharSequence)surl)) {
            try {
                return XWikiServletURLFactory.normalizeURL(surl, context);
            }
            catch (MalformedURLException e) {
                LOGGER.warn("Could not create URL from xwiki.cfg xwiki.home parameter: {}. Ignoring parameter.", (Object)surl);
            }
        }
        return null;
    }

    private static String getXWikiHomeParameterAsString(XWikiContext context) {
        return context.getWiki().Param("xwiki.home", null);
    }

    @Override
    public URL getServerURL(XWikiContext context) throws MalformedURLException {
        return this.getServerURL(context.getWikiId(), context);
    }

    public URL getServerURL(String wikiId, XWikiContext context) throws MalformedURLException {
        URL inputURL;
        if (wikiId == null) {
            wikiId = context.getWikiId();
        }
        if ((inputURL = this.getDefaultURL(wikiId, context)) != null) {
            return inputURL;
        }
        if (context.getWiki().isPathBased() && !Strings.CS.equals(context.getOriginalWikiId(), wikiId)) {
            return this.getServerURL(context.getOriginalWikiId(), context);
        }
        URL url = context.getWiki().getServerURL(wikiId, context);
        if (url != null) {
            return url;
        }
        return this.getOriginalURL(context);
    }

    @Override
    public URL createURL(String spaces, String name, String action, boolean redirect, XWikiContext context) {
        return this.createURL(spaces, name, action, context);
    }

    @Override
    public URL createURL(String spaces, String name, String action, String querystring, String anchor, String xwikidb, XWikiContext context) {
        URL result;
        if ("view".equals(action) && context.getLinksAction() != null) {
            action = context.getLinksAction();
        }
        if (context.getLinksQueryString() != null) {
            querystring = querystring == null ? context.getLinksQueryString() : (String)querystring + "&" + context.getLinksQueryString();
        }
        StringBuilder path = new StringBuilder(this.contextPath);
        this.addServletPath(path, xwikidb, context);
        EntityReference spaceReference = this.getRelativeEntityReferenceResolver().resolve((Object)spaces, EntityType.SPACE, new Object[0]);
        this.addAction(path, spaceReference, action, context);
        this.addSpaces(path, spaceReference);
        this.addName(path, name, action, context);
        if (!StringUtils.isEmpty((CharSequence)querystring)) {
            path.append("?");
            path.append(StringUtils.removeEnd((String)StringUtils.removeEnd((String)querystring, (String)"&"), (String)"&amp;"));
        }
        if (!StringUtils.isEmpty((CharSequence)anchor)) {
            path.append("#");
            path.append(this.encodeFragment(anchor));
        }
        try {
            result = XWikiServletURLFactory.normalizeURL(new URL(this.getServerURL(xwikidb, context), path.toString()), context);
        }
        catch (MalformedURLException e) {
            result = null;
        }
        return result;
    }

    private void addServletPath(StringBuilder path, String xwikidb, XWikiContext context) {
        if (xwikidb == null) {
            xwikidb = context.getWikiId();
        }
        path.append(context.getWiki().getServletPath(xwikidb, context));
    }

    private void addAction(StringBuilder path, EntityReference spaceReference, String action, XWikiContext context) {
        boolean showViewAction = context.getWiki().showViewAction(context);
        if (!"view".equals(action) || showViewAction || spaceReference != null && "view".equals(action) && this.getActionLister().listActions().contains(spaceReference.extractFirstReference(EntityType.SPACE).getName())) {
            path.append(action).append("/");
        }
    }

    private void addSpaces(StringBuilder path, EntityReference spaceReference) {
        for (EntityReference reference : spaceReference.getReversedReferenceChain()) {
            this.appendSpacePathSegment(path, reference);
        }
    }

    private void appendSpacePathSegment(StringBuilder path, EntityReference spaceReference) {
        path.append(this.encodeWithinPath(spaceReference.getName())).append('/');
    }

    private void addName(StringBuilder path, String name, String action, XWikiContext context) {
        XWiki xwiki = context.getWiki();
        if (xwiki.useDefaultAction(context) || !name.equals(xwiki.getDefaultPage(context)) || !"view".equals(action)) {
            path.append(this.encodeWithinPath(name));
        }
    }

    protected void addFileName(StringBuilder path, String fileName, XWikiContext context) {
        this.addFileName(path, fileName, true, context);
    }

    protected void addFileName(StringBuilder path, String fileName, boolean encode, XWikiContext context) {
        path.append("/");
        if (encode) {
            path.append(this.encodeWithinPath(fileName).replace("+", "%20"));
        } else {
            try {
                path.append(new URI(null, null, fileName, null));
            }
            catch (URISyntaxException e) {
                LOGGER.debug("Failed to encode the file path [{}]. Root cause: [{}]", (Object)fileName, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
                path.append(fileName);
            }
        }
    }

    private String encodeWithinPath(String name) {
        String encodedName;
        try {
            encodedName = URLEncoder.encode(name, "UTF-8");
        }
        catch (Exception e) {
            throw new RuntimeException("Missing charset [UTF-8]", e);
        }
        encodedName = encodedName.replaceAll("\\+", "%20");
        return encodedName;
    }

    private String encodeWithinQuery(String name) {
        return this.encodeWithinPath(name);
    }

    private String encodeFragment(String fragment) {
        try {
            String encodedFragment = Strings.CS.removeStart(new URI(null, null, null, -1, null, null, fragment).toString(), (CharSequence)"#");
            return encodedFragment.replace("'", "%27");
        }
        catch (URISyntaxException e) {
            LOGGER.warn("Failed to encode URL fragment [{}]. Root cause is [{}]", (Object)fragment, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            return fragment;
        }
    }

    @Override
    public URL createExternalURL(String spaces, String name, String action, String querystring, String anchor, String xwikidb, XWikiContext context) {
        return this.createURL(spaces, name, action, querystring, anchor, xwikidb, context);
    }

    private void appendQueryParameter(String key, Object paramValue, StringBuilder stringBuilder) throws UnsupportedEncodingException {
        if (paramValue instanceof String) {
            stringBuilder.append(URLEncoder.encode(key, "UTF-8"));
            stringBuilder.append('=');
            stringBuilder.append(URLEncoder.encode((String)paramValue, "UTF-8"));
        } else if (paramValue.getClass().isArray()) {
            Class<?> ofArray = paramValue.getClass().getComponentType();
            if (ofArray.isPrimitive()) {
                int length = Array.getLength(paramValue);
                for (int i = 0; i < length; ++i) {
                    this.appendQueryParameter(key, Array.get(paramValue, i).toString(), stringBuilder);
                    if (i >= length - 1) continue;
                    stringBuilder.append('&');
                }
            } else {
                Object[] zeArray = (Object[])paramValue;
                for (int i = 0; i < zeArray.length; ++i) {
                    this.appendQueryParameter(key, zeArray[i].toString(), stringBuilder);
                    if (i >= zeArray.length - 1) continue;
                    stringBuilder.append('&');
                }
            }
        } else if (paramValue instanceof Collection) {
            Collection zeCollection = (Collection)paramValue;
            int index = 0;
            for (Object paramValueElement : zeCollection) {
                this.appendQueryParameter(key, paramValueElement.toString(), stringBuilder);
                if (index < zeCollection.size() - 1) {
                    stringBuilder.append('&');
                }
                ++index;
            }
        } else {
            this.appendQueryParameter(key, paramValue.toString(), stringBuilder);
        }
    }

    private URL buildURL(URL serverUrl, String path, Map<String, Object> queryParameters, XWikiContext context) {
        try {
            URL resultUrl = new URL(serverUrl, path);
            if (!queryParameters.isEmpty()) {
                StringBuilder stringBuilder = new StringBuilder(resultUrl.toExternalForm());
                stringBuilder.append('?');
                int parametersSize = queryParameters.size();
                int currentIndex = 0;
                for (Map.Entry<String, Object> queryParameter : queryParameters.entrySet()) {
                    String key = queryParameter.getKey();
                    Object paramValue = queryParameter.getValue();
                    this.appendQueryParameter(key, paramValue, stringBuilder);
                    if (currentIndex < parametersSize - 1) {
                        stringBuilder.append("&");
                    }
                    ++currentIndex;
                }
                resultUrl = new URL(stringBuilder.toString());
            }
            return XWikiServletURLFactory.normalizeURL(resultUrl, context);
        }
        catch (UnsupportedEncodingException | MalformedURLException e) {
            return null;
        }
    }

    @Override
    public URL createSkinURL(String filename, String skin, XWikiContext context, Map<String, Object> queryParameters) {
        StringBuilder path = new StringBuilder(this.contextPath);
        path.append("skins/");
        path.append(skin);
        this.addFileName(path, filename, false, context);
        try {
            return this.buildURL(this.getServerURL(context), path.toString(), queryParameters, context);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    @Override
    public URL createSkinURL(String filename, String spaces, String name, String xwikidb, XWikiContext context, Map<String, Object> queryParameters) {
        StringBuilder path = new StringBuilder(this.contextPath);
        this.addServletPath(path, xwikidb, context);
        EntityReference spaceReference = this.getRelativeEntityReferenceResolver().resolve((Object)spaces, EntityType.SPACE, new Object[0]);
        this.addAction(path, null, "skin", context);
        this.addSpaces(path, spaceReference);
        this.addName(path, name, "skin", context);
        this.addFileName(path, filename, false, context);
        try {
            return this.buildURL(this.getServerURL(xwikidb, context), path.toString(), queryParameters, context);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    @Override
    public URL createResourceURL(String filename, boolean forceSkinAction, XWikiContext context, Map<String, Object> queryParameters) {
        StringBuilder path = new StringBuilder(this.contextPath);
        if (forceSkinAction) {
            this.addServletPath(path, context.getWikiId(), context);
            this.addAction(path, null, "skin", context);
        }
        path.append("resources");
        this.addFileName(path, filename, false, context);
        try {
            return this.buildURL(this.getServerURL(context), path.toString(), queryParameters, context);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public URL createTemplateURL(String fileName, XWikiContext context) {
        StringBuilder path = new StringBuilder(this.contextPath);
        path.append("templates");
        this.addFileName(path, fileName, false, context);
        try {
            return XWikiServletURLFactory.normalizeURL(new URL(this.getServerURL(context), path.toString()), context);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URL createAttachmentURL(String filename, String spaces, String name, String action, String querystring, String xwikidb, XWikiContext context) {
        URL attachmentURL;
        XWikiAttachment attachment;
        block15: {
            attachment = null;
            attachmentURL = null;
            if (context != null && context.get("rev") != null && this.isContextDoc(xwikidb, spaces, name, context) && Locale.ROOT.equals(context.getDoc().getLocale())) {
                try {
                    String docRevision = context.get("rev").toString();
                    attachment = this.findAttachmentForDocRevision(context.getDoc(), docRevision, filename, context);
                    if (attachment == null) {
                        action = "viewattachrev";
                        break block15;
                    }
                    long arbId = this.findDeletedAttachmentForDocRevision(context.getDoc(), docRevision, filename, context);
                    attachmentURL = this.createAttachmentRevisionURL(filename, spaces, name, attachment.getVersion(), arbId, (String)querystring, xwikidb, context);
                }
                catch (XWikiException e) {
                    LOGGER.error("Failed to create attachment URL for filename [{}] in spaces [{}], page [{}], action [{}], query string [{}] and wiki [{}]", new Object[]{filename, spaces, name, action, querystring, xwikidb, e});
                }
            } else if (action.equals("download") && this.isContextDoc(xwikidb, spaces, name, context) && Locale.ROOT.equals(context.getDoc().getLocale())) {
                attachment = context.getDoc().getAttachment(filename);
            } else if (action.equals("download")) {
                WikiReference originalWikiReference = context.getWikiReference();
                context.setWikiId(xwikidb);
                DocumentReference documentReference = new DocumentReference(name, new SpaceReference(this.getCurrentEntityReferenceResolver().resolve((Object)spaces, EntityType.SPACE, new Object[]{context.getWikiReference()})));
                try {
                    XWikiDocument document = context.getWiki().getDocument(documentReference, context);
                    attachment = document.getAttachment(filename);
                }
                catch (XWikiException e) {
                    LOGGER.error("Exception while loading doc from wiki [{}] space [{}] and page [{}]", new Object[]{xwikidb, spaces, name, e});
                }
                finally {
                    context.setWikiReference(originalWikiReference);
                }
            }
        }
        if (attachment != null) {
            querystring = !StringUtils.isEmpty((CharSequence)querystring) ? (String)querystring + "&rev=" + attachment.getVersion() : "rev=" + attachment.getVersion();
        }
        if (attachmentURL == null) {
            attachmentURL = this.internalCreateAttachmentURL(filename, spaces, name, action, (String)querystring, xwikidb, context);
        }
        return attachmentURL;
    }

    private URL internalCreateAttachmentURL(String filename, String spaces, String name, String action, String querystring, String xwikidb, XWikiContext context) {
        StringBuilder path = new StringBuilder(this.contextPath);
        this.addServletPath(path, xwikidb, context);
        EntityReference spaceReference = this.getRelativeEntityReferenceResolver().resolve((Object)spaces, EntityType.SPACE, new Object[0]);
        this.addAction(path, spaceReference, action, context);
        this.addSpaces(path, spaceReference);
        this.addName(path, name, action, context);
        this.addFileName(path, filename, context);
        if (!StringUtils.isEmpty((CharSequence)querystring)) {
            path.append("?");
            path.append(StringUtils.removeEnd((String)StringUtils.removeEnd((String)querystring, (String)"&"), (String)"&amp;"));
        }
        try {
            return XWikiServletURLFactory.normalizeURL(new URL(this.getServerURL(xwikidb, context), path.toString()), context);
        }
        catch (Exception e) {
            return null;
        }
    }

    protected boolean isContextDoc(String wiki, String spaces, String name, XWikiContext context) {
        DocumentReference currentDocumentReference;
        if (context == null || context.getDoc() == null) {
            return false;
        }
        EntityReferenceSerializer serializer = (EntityReferenceSerializer)Utils.getComponent(EntityReferenceSerializer.TYPE_STRING, "local");
        return ((String)serializer.serialize((EntityReference)(currentDocumentReference = context.getDoc().getDocumentReference()).getLastSpaceReference(), new Object[0])).equals(spaces) && currentDocumentReference.getName().equals(name) && (wiki == null || currentDocumentReference.getWikiReference().getName().equals(wiki));
    }

    @Override
    public URL createAttachmentRevisionURL(String filename, String spaces, String name, String revision, String querystring, String xwikidb, XWikiContext context) {
        return this.createAttachmentRevisionURL(filename, spaces, name, revision, -1L, querystring, xwikidb, context);
    }

    public URL createAttachmentRevisionURL(String filename, String spaces, String name, String revision, long recycleId, String querystring, String xwikidb, XWikiContext context) {
        String action = "downloadrev";
        String qstring = "rev=" + revision;
        if (recycleId >= 0L) {
            qstring = qstring + "&rid=" + recycleId;
        }
        if (!StringUtils.isEmpty((CharSequence)querystring)) {
            qstring = qstring + "&" + querystring;
        }
        return this.internalCreateAttachmentURL(filename, spaces, name, action, qstring, xwikidb, context);
    }

    @Override
    public String getURL(URL url, XWikiContext context) {
        String relativeURL = "";
        try {
            if (url != null) {
                String surl = url.toString();
                URL referenceURL = this.getOriginalURL(context);
                if (referenceURL == null || !surl.startsWith(referenceURL.toString())) {
                    relativeURL = surl;
                } else {
                    String anchor;
                    StringBuilder relativeURLBuilder = new StringBuilder(url.getPath());
                    String querystring = url.getQuery();
                    if (!StringUtils.isEmpty((CharSequence)querystring)) {
                        relativeURLBuilder.append("?").append(StringUtils.removeEnd((String)StringUtils.removeEnd((String)querystring, (String)"&"), (String)"&amp;"));
                    }
                    if (!StringUtils.isEmpty((CharSequence)(anchor = url.getRef()))) {
                        relativeURLBuilder.append("#").append(anchor);
                    }
                    relativeURL = relativeURLBuilder.toString();
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to create URL", (Throwable)e);
        }
        return (String)StringUtils.defaultIfEmpty((CharSequence)relativeURL, (CharSequence)"/");
    }

    @Override
    public URL getRequestURL(XWikiContext context) {
        URL url = super.getRequestURL(context);
        try {
            URL servurl = this.getServerURL(context);
            return XWikiServletURLFactory.normalizeURL(new URL(servurl.getProtocol(), servurl.getHost(), servurl.getPort(), url.getFile()), context);
        }
        catch (MalformedURLException e) {
            LOGGER.error("Failed to create request URL", (Throwable)e);
            return url;
        }
    }

    public XWikiAttachment findAttachmentForDocRevision(XWikiDocument doc, String docRevision, String filename, XWikiContext context) throws XWikiException {
        XWikiAttachment attachment = null;
        XWikiDocument rdoc = context.getWiki().getDocument(doc, docRevision, context);
        if (filename != null) {
            attachment = rdoc.getAttachment(filename);
        }
        return attachment;
    }

    public long findDeletedAttachmentForDocRevision(XWikiDocument doc, String docRevision, String filename, XWikiContext context) throws XWikiException {
        XWikiAttachment attachment = null;
        XWikiDocument rdoc = context.getWiki().getDocument(doc, docRevision, context);
        if (context.getWiki().hasAttachmentRecycleBin(context) && filename != null && (attachment = rdoc.getAttachment(filename)) != null) {
            List<DeletedAttachment> deleted = context.getWiki().getAttachmentRecycleBinStore().getAllDeletedAttachments(attachment, context, true);
            Collections.reverse(deleted);
            for (DeletedAttachment entry : deleted) {
                if (!entry.getDate().after(rdoc.getDate())) continue;
                return entry.getId();
            }
        }
        return -1L;
    }

    protected static URL normalizeURL(URL url, XWikiContext context) throws MalformedURLException {
        return XWikiServletURLFactory.normalizeURL(url.toExternalForm(), context);
    }

    protected static URL normalizeURL(String url, XWikiContext context) throws MalformedURLException {
        String encodedURLAsString = context.getResponse().encodeURL(url);
        encodedURLAsString = encodedURLAsString.replaceAll(";jsessionid=.*?(?=\\?|$)", "");
        return new URL(encodedURLAsString);
    }

    private EntityReferenceResolver<String> getRelativeEntityReferenceResolver() {
        if (this.relativeEntityReferenceResolver == null) {
            this.relativeEntityReferenceResolver = (EntityReferenceResolver)Utils.getComponent(EntityReferenceResolver.TYPE_STRING, "relative");
        }
        return this.relativeEntityReferenceResolver;
    }

    private EntityReferenceResolver<String> getCurrentEntityReferenceResolver() {
        if (this.currentEntityReferenceResolver == null) {
            this.currentEntityReferenceResolver = (EntityReferenceResolver)Utils.getComponent(EntityReferenceResolver.TYPE_STRING, "current");
        }
        return this.currentEntityReferenceResolver;
    }

    private EntityResourceActionLister getActionLister() {
        if (this.actionLister == null) {
            this.actionLister = Utils.getComponent(EntityResourceActionLister.class);
        }
        return this.actionLister;
    }
}

