/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.web;

import com.xpn.xwiki.util.Util;
import com.xpn.xwiki.web.XWikiRequest;
import jakarta.servlet.http.HttpServletRequest;
import java.net.URL;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpSession;
import org.xwiki.container.servlet.HttpServletRequestStub;
import org.xwiki.jakartabridge.JavaxToJakartaWrapper;
import org.xwiki.jakartabridge.servlet.JakartaServletBridge;
import org.xwiki.stability.Unstable;

public class XWikiServletRequestStub
extends HttpServletRequestWrapper
implements XWikiRequest,
JavaxToJakartaWrapper<HttpServletRequestStub> {
    public XWikiServletRequestStub() {
        this(new HttpServletRequestStub());
    }

    public XWikiServletRequestStub(XWikiRequest request) {
        this(new HttpServletRequestStub(JakartaServletBridge.toJakarta((javax.servlet.http.HttpServletRequest)request)));
        if (request instanceof XWikiServletRequestStub) {
            XWikiServletRequestStub requestStub = (XWikiServletRequestStub)request;
            this.setDaemon(requestStub.isDaemon());
        }
    }

    @Unstable
    public XWikiServletRequestStub(HttpServletRequestStub jakarta) {
        super(JakartaServletBridge.toJavax((HttpServletRequest)jakarta));
    }

    protected XWikiServletRequestStub(Builder builder) {
        this(new HttpServletRequestStub.Builder().setRequestURL(builder.requestURL).setContextPath(builder.contextPath).setRequestParameters(builder.requestParameters).setHeaders(builder.headers).setRemoteAddr(builder.remoteAddr).setCookies(JakartaServletBridge.toJakarta((Cookie[])builder.cookies)).setHttpSession(JakartaServletBridge.toJakarta((HttpSession)builder.httpSession)).build());
    }

    @Deprecated
    public XWikiServletRequestStub(URL requestURL, Map<String, String[]> requestParameters) {
        this(requestURL, null, requestParameters);
    }

    @Deprecated
    public XWikiServletRequestStub(URL requestURL, String contextPath, Map<String, String[]> requestParameters) {
        this(requestURL, contextPath, requestParameters, new Cookie[0]);
    }

    @Deprecated
    public XWikiServletRequestStub(URL requestURL, String contextPath, Map<String, String[]> requestParameters, Cookie[] cookies) {
        this(new Builder().setRequestURL(requestURL).setContextPath(contextPath).setRequestParameters(requestParameters).setCookies(cookies));
    }

    public void setContextPath(String contextPath) {
        this.getJakarta().setContextPath(contextPath);
    }

    public void setHost(String host) {
        this.getJakarta().setHost(host);
    }

    public void setScheme(String scheme) {
        this.getJakarta().setScheme(scheme);
    }

    public void setrequestURL(StringBuffer requestURL) {
        this.getJakarta().setrequestURL(requestURL);
    }

    public void setRequestURI(String requestURI) {
        this.getJakarta().setRequestURI(requestURI);
    }

    public void setServerName(String serverName) {
        this.getJakarta().setServerName(serverName);
    }

    public void put(String key, String value) {
        this.getJakarta().put(key, value);
    }

    public void setSession(HttpSession httpSession) {
        this.getJakarta().setSession(JakartaServletBridge.toJakarta((HttpSession)httpSession));
    }

    public boolean isDaemon() {
        return this.getJakarta().isDaemon();
    }

    public void setDaemon(boolean daemon) {
        this.getJakarta().setDaemon(daemon);
    }

    public HttpServletRequestStub getJakarta() {
        ServletRequest servletRequest = this.getRequest();
        if (servletRequest instanceof JavaxToJakartaWrapper) {
            JavaxToJakartaWrapper wrapper = (JavaxToJakartaWrapper)servletRequest;
            return (HttpServletRequestStub)wrapper.getJakarta();
        }
        return null;
    }

    @Override
    public javax.servlet.http.HttpServletRequest getHttpServletRequest() {
        return this;
    }

    @Override
    public String get(String name) {
        return this.getRequest().getParameter(name);
    }

    @Override
    public Cookie getCookie(String cookieName) {
        return Util.getCookie(cookieName, this);
    }

    public static class Builder {
        private URL requestURL;
        private String contextPath;
        private Map<String, String[]> requestParameters;
        private Map<String, List<String>> headers;
        private Cookie[] cookies;
        private String remoteAddr;
        private HttpSession httpSession;

        public Builder setRequestURL(URL requestURL) {
            this.requestURL = requestURL;
            return this;
        }

        public Builder setContextPath(String contextPath) {
            this.contextPath = contextPath;
            return this;
        }

        public Builder setRequestParameters(Map<String, String[]> requestParameters) {
            this.requestParameters = requestParameters;
            return this;
        }

        public Builder setHeaders(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        public Builder setCookies(Cookie[] cookies) {
            this.cookies = cookies;
            return this;
        }

        public Builder setRemoteAddr(String remoteAddr) {
            this.remoteAddr = remoteAddr;
            return this;
        }

        public Builder setHttpSession(HttpSession httpSession) {
            this.httpSession = httpSession;
            return this;
        }

        public XWikiServletRequestStub build() {
            return new XWikiServletRequestStub(this);
        }
    }
}

