/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.web;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.user.api.XWikiUser;
import com.xpn.xwiki.web.Utils;
import com.xpn.xwiki.web.XWikiServletContext;
import com.xpn.xwiki.web.XWikiServletRequest;
import com.xpn.xwiki.web.XWikiServletResponse;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.xwiki.container.Container;
import org.xwiki.container.servlet.ServletContainerException;
import org.xwiki.container.servlet.ServletContainerInitializer;
import org.xwiki.context.Execution;
import org.xwiki.jakartabridge.servlet.JakartaServletBridge;
import org.xwiki.model.reference.DocumentReference;

public class XWikiContextInitializationFilter
implements Filter {
    private int mode;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(jakarta.servlet.ServletRequest request, jakarta.servlet.ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            if (request instanceof HttpServletRequest) {
                this.initializeXWikiContext(request, response);
            }
            chain.doFilter(request, response);
        }
        finally {
            if (request instanceof HttpServletRequest) {
                this.cleanupComponents();
            }
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        try {
            this.mode = Integer.parseInt(filterConfig.getInitParameter("mode"));
        }
        catch (Exception e) {
            this.mode = -1;
        }
    }

    @Deprecated(since="17.0.0RC1")
    protected void initializeXWikiContext(ServletRequest request, ServletResponse response) throws ServletException {
        this.initializeXWikiContext(JakartaServletBridge.toJakarta((ServletRequest)request), JakartaServletBridge.toJakarta((ServletResponse)response));
    }

    protected void initializeXWikiContext(jakarta.servlet.ServletRequest request, jakarta.servlet.ServletResponse response) throws ServletException {
        try {
            String action = "";
            XWikiServletContext xwikiEngine = new XWikiServletContext(JakartaServletBridge.toJavax((ServletContext)request.getServletContext()));
            XWikiServletRequest xwikiRequest = new XWikiServletRequest(JakartaServletBridge.toJavax((HttpServletRequest)((HttpServletRequest)request)));
            XWikiServletResponse xwikiResponse = new XWikiServletResponse(JakartaServletBridge.toJavax((jakarta.servlet.http.HttpServletResponse)((jakarta.servlet.http.HttpServletResponse)response)));
            XWikiContext context = Utils.prepareContext(action, xwikiRequest, xwikiResponse, xwikiEngine);
            if (this.mode >= 0) {
                context.setMode(this.mode);
            }
            this.initializeContainerComponent(context);
            XWiki xwiki = XWiki.getXWiki(context);
            context.setURLFactory(xwiki.getURLFactoryService().createURLFactory(context.getMode(), context));
            xwiki.prepareResources(context);
            XWikiUser user = context.getWiki().checkAuth(context);
            if (user != null) {
                DocumentReference userReference = user.getUserReference();
                context.setUserReference("XWikiGuest".equals(userReference.getName()) ? null : userReference);
            }
        }
        catch (XWikiException e) {
            throw new ServletException("Failed to initialize the XWiki context.", (Throwable)e);
        }
    }

    protected void initializeContainerComponent(XWikiContext context) throws ServletException {
        ServletContainerInitializer containerInitializer = (ServletContainerInitializer)Utils.getComponent(ServletContainerInitializer.class);
        try {
            containerInitializer.initializeRequest(context.getRequest().getHttpServletRequest(), (Object)context);
            containerInitializer.initializeResponse((HttpServletResponse)context.getResponse());
            containerInitializer.initializeSession(context.getRequest().getHttpServletRequest());
        }
        catch (ServletContainerException e) {
            throw new ServletException("Failed to initialize Request/Response or Session", (Throwable)e);
        }
    }

    protected void cleanupComponents() {
        Container container = (Container)Utils.getComponent(Container.class);
        container.removeRequest();
        container.removeResponse();
        container.removeSession();
        Execution execution = (Execution)Utils.getComponent(Execution.class);
        execution.removeContext();
    }
}

