/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.web;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.Attachment;
import com.xpn.xwiki.api.Document;
import com.xpn.xwiki.doc.XWikiAttachment;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.web.Utils;
import com.xpn.xwiki.web.XWikiAction;
import com.xpn.xwiki.web.XWikiRequest;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.script.ScriptContext;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.EntityType;
import org.xwiki.resource.ResourceReference;
import org.xwiki.resource.ResourceReferenceManager;
import org.xwiki.resource.entity.EntityResourceReference;

@Component
@Named(value="viewattachrev")
@Singleton
public class ViewAttachRevAction
extends XWikiAction {
    public ViewAttachRevAction() {
        this.waitForXWikiInitialization = false;
    }

    @Override
    public String render(XWikiContext context) throws XWikiException {
        XWikiAttachment attachment;
        XWikiRequest request = context.getRequest();
        XWikiDocument doc = context.getDoc();
        String filename = context.getMode() == 1 ? request.getParameter("filename") : this.getFileName();
        if (context.getWiki().hasAttachmentRecycleBin(context) && request.getParameter("rid") != null) {
            int recycleId = Integer.parseInt(request.getParameter("rid"));
            attachment = new XWikiAttachment(doc, filename);
            attachment = context.getWiki().getAttachmentRecycleBinStore().restoreFromRecycleBin(attachment, recycleId, context, true);
        } else if (request.getParameter("id") != null) {
            int id = Integer.parseInt(request.getParameter("id"));
            attachment = doc.getAttachmentList().get(id);
        } else {
            attachment = doc.getAttachment(filename);
        }
        if (attachment == null) {
            context.put("message", "attachmentdoesnotexist");
            return "exception";
        }
        ScriptContext scriptContext = this.getCurrentScriptContext();
        scriptContext.setAttribute("attachment", new Attachment((Document)scriptContext.getAttribute("doc"), attachment, context), 100);
        return "viewattachrev";
    }

    @Override
    protected boolean supportRedirections() {
        return true;
    }

    private String getFileName() {
        ResourceReference resourceReference = Utils.getComponent(ResourceReferenceManager.class).getResourceReference();
        EntityResourceReference entityResource = (EntityResourceReference)resourceReference;
        return entityResource.getEntityReference().extractReference(EntityType.ATTACHMENT).getName();
    }
}

