/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.web;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.DeletedDocument;
import com.xpn.xwiki.doc.XWikiDeletedDocument;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.web.Utils;
import com.xpn.xwiki.web.XWikiAction;
import com.xpn.xwiki.web.XWikiRequest;
import com.xpn.xwiki.web.XWikiResponse;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.component.annotation.Component;
import org.xwiki.job.Job;
import org.xwiki.job.JobException;
import org.xwiki.job.JobExecutor;
import org.xwiki.job.Request;
import org.xwiki.refactoring.job.RestoreRequest;
import org.xwiki.refactoring.script.RefactoringScriptService;
import org.xwiki.script.service.ScriptService;

@Component
@Named(value="undelete")
@Singleton
public class UndeleteAction
extends XWikiAction {
    private static final String ID_PARAMETER = "id";
    private static final String SHOW_BATCH_PARAMETER = "showBatch";
    private static final String INCLUDE_BATCH_PARAMETER = "includeBatch";
    private static final String CONFIRM_PARAMETER = "confirm";
    private static final String ASYNC_PARAM = "async";
    private static final String TRUE = "true";
    private static final String VIEW_ACTION = "view";
    private static final Logger LOGGER = LoggerFactory.getLogger(UndeleteAction.class);

    @Override
    public boolean action(XWikiContext context) throws XWikiException {
        XWikiRequest request = context.getRequest();
        XWikiResponse response = context.getResponse();
        XWikiDocument doc = context.getDoc();
        XWikiDeletedDocument deletedDocument = this.getDeletedDocument(context);
        if (deletedDocument == null) {
            this.sendRedirect(response, doc.getURL(VIEW_ACTION, context));
            return false;
        }
        if (TRUE.equals(request.getParameter(SHOW_BATCH_PARAMETER)) && !TRUE.equals(request.getParameter(CONFIRM_PARAMETER))) {
            return true;
        }
        if (!this.csrfTokenCheck(context)) {
            return false;
        }
        DeletedDocument deletedDocumentAPI = new DeletedDocument(deletedDocument, context);
        if (!deletedDocumentAPI.canUndelete()) {
            return true;
        }
        boolean redirected = false;
        if (deletedDocument != null) {
            redirected = this.restoreDocument(deletedDocument, context);
        }
        if (!redirected) {
            String queryString = this.getRedirectQueryString(context, deletedDocument.getLocale());
            this.sendRedirect(response, doc.getURL(VIEW_ACTION, queryString, context));
            redirected = true;
        }
        return !redirected;
    }

    private XWikiDeletedDocument getDeletedDocument(XWikiContext context) throws XWikiException {
        XWikiDeletedDocument result = null;
        XWikiRequest request = context.getRequest();
        XWiki xwiki = context.getWiki();
        String sindex = request.getParameter(ID_PARAMETER);
        try {
            long index = Long.parseLong(sindex);
            result = xwiki.getDeletedDocument(index, context);
        }
        catch (Exception e) {
            LOGGER.error("Failed to get deleted document with ID [{}]", (Object)sindex, (Object)e);
        }
        return result;
    }

    private boolean restoreDocument(XWikiDeletedDocument deletedDocument, XWikiContext context) throws XWikiException {
        Job restoreJob = this.startRestoreJob(deletedDocument, context);
        if (this.isAsync(context.getRequest())) {
            List jobId = restoreJob.getRequest().getId();
            String queryString = "xpage=restore&jobId=" + this.serializeJobId(jobId) + "&spaceRedirect=false";
            this.sendRedirect(context.getResponse(), Utils.getRedirect(VIEW_ACTION, queryString, context));
            return true;
        }
        try {
            restoreJob.join();
        }
        catch (InterruptedException e) {
            throw new XWikiException(String.format("Failed to restore [%s] from batch [%s]", deletedDocument.getFullName(), deletedDocument.getBatchId()), e);
        }
        return false;
    }

    private String serializeJobId(List<String> jobId) {
        return StringUtils.join(jobId, (String)"/");
    }

    private Job startRestoreJob(XWikiDeletedDocument deletedDocument, XWikiContext context) throws XWikiException {
        XWikiRequest request = context.getRequest();
        RefactoringScriptService refactoring = (RefactoringScriptService)Utils.getComponent(ScriptService.class, "refactoring");
        RestoreRequest restoreRequest = null;
        if (TRUE.equals(request.getParameter(INCLUDE_BATCH_PARAMETER))) {
            String batchId = deletedDocument.getBatchId();
            restoreRequest = refactoring.getRequestFactory().createRestoreRequest(batchId);
        } else {
            restoreRequest = refactoring.getRequestFactory().createRestoreRequest(Arrays.asList(deletedDocument.getId()));
        }
        restoreRequest.setInteractive(this.isAsync(request));
        restoreRequest.setCheckAuthorRights(false);
        try {
            JobExecutor jobExecutor = Utils.getComponent(JobExecutor.class);
            return jobExecutor.execute("refactoring/restore", (Request)restoreRequest);
        }
        catch (JobException e) {
            throw new XWikiException(String.format("Failed to schedule the restore job for deleted document [%s], id [%s] of batch [%s]", deletedDocument.getFullName(), deletedDocument.getId(), deletedDocument.getBatchId()), e);
        }
    }

    private boolean isAsync(XWikiRequest request) {
        return TRUE.equals(request.get(ASYNC_PARAM));
    }

    private String getRedirectQueryString(XWikiContext context, Locale deletedDocumentLocale) {
        String result = null;
        XWiki xwiki = context.getWiki();
        if (deletedDocumentLocale != null && xwiki.isMultiLingual(context)) {
            result = String.format("language=%s", deletedDocumentLocale);
        }
        return result;
    }

    @Override
    public String render(XWikiContext context) throws XWikiException {
        DeletedDocument deletedDocumentAPI;
        XWikiDeletedDocument deletedDocument;
        String result = null;
        XWikiRequest request = context.getRequest();
        if (TRUE.equals(request.getParameter(SHOW_BATCH_PARAMETER)) && !TRUE.equals(request.getParameter(CONFIRM_PARAMETER))) {
            result = "restore";
        }
        if ((deletedDocument = this.getDeletedDocument(context)) != null && !(deletedDocumentAPI = new DeletedDocument(deletedDocument, context)).canUndelete()) {
            return "accessdenied";
        }
        return result;
    }
}

