/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.web;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.internal.web.LegacyAction;
import com.xpn.xwiki.web.EditForm;
import com.xpn.xwiki.web.PropUpdateAction;
import com.xpn.xwiki.web.SaveAction;
import com.xpn.xwiki.web.Utils;
import com.xpn.xwiki.web.XWikiAction;
import com.xpn.xwiki.web.XWikiForm;
import com.xpn.xwiki.web.XWikiRequest;
import java.io.IOException;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.component.annotation.Component;

@Component
@Named(value="saveandcontinue")
@Singleton
public class SaveAndContinueAction
extends XWikiAction {
    private static final String WRAPPED_ACTION_CONTEXT_KEY = "SaveAndContinueAction.wrappedAction";
    private static final String MERGED_DOCUMENTS_VALUE = "true";
    private static final Logger LOGGER = LoggerFactory.getLogger(SaveAndContinueAction.class);
    @Inject
    @Named(value="save")
    private LegacyAction saveAction;
    @Inject
    @Named(value="propupdate")
    private LegacyAction propupdateAction;

    @Override
    protected Class<? extends XWikiForm> getFormClass() {
        return EditForm.class;
    }

    @Override
    protected String getName() {
        return "save";
    }

    private boolean doWrappedAction(boolean isAjaxRequest, String back, XWikiContext context) throws XWikiException {
        boolean failure = false;
        if (back != null && back.contains("editor=class")) {
            PropUpdateAction pua = (PropUpdateAction)this.propupdateAction;
            if (pua.propUpdate(context)) {
                if (isAjaxRequest) {
                    String errorMessage = this.localizePlainOrKey((String)context.get("message"), new Object[0]);
                    this.writeAjaxErrorResponse(500, errorMessage, context);
                } else {
                    context.put(WRAPPED_ACTION_CONTEXT_KEY, pua);
                }
                failure = true;
            }
        } else {
            SaveAction sa = (SaveAction)this.saveAction;
            if (sa.save(context)) {
                if (isAjaxRequest && context.getResponse().getStatus() != 409) {
                    String errorMessage = this.localizePlainOrKey("core.editors.saveandcontinue.theDocumentWasNotSaved", new Object[0]);
                    LOGGER.error("SaveAction.save(context) returned true while using save & continue");
                    this.writeAjaxErrorResponse(500, errorMessage, context);
                } else if (context.getResponse().getStatus() != 409) {
                    context.put(WRAPPED_ACTION_CONTEXT_KEY, sa);
                }
                failure = true;
            } else {
                context.getDoc().getTranslatedDocument(context).setLock(context.getUser(), context);
            }
        }
        return failure;
    }

    @Override
    public boolean action(XWikiContext context) throws XWikiException {
        boolean isAjaxRequest = Utils.isAjaxRequest(context);
        if (!this.csrfTokenCheck(context, true)) {
            return false;
        }
        String back = this.findBackURL(context);
        try {
            if (this.doWrappedAction(isAjaxRequest, back, context)) {
                return !isAjaxRequest;
            }
        }
        catch (Exception e) {
            this.handleSaveException(isAjaxRequest, e, context);
            return !isAjaxRequest;
        }
        if (isAjaxRequest) {
            Map jsonAnswer = (Map)context.get("SaveAction.jsonAnswer");
            if (jsonAnswer != null) {
                this.answerJSON(context, 200, jsonAnswer);
            } else {
                context.getResponse().setStatus(204);
            }
            return false;
        }
        try {
            context.getResponse().sendRedirect(back);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public String render(XWikiContext context) throws XWikiException {
        XWikiAction wrappedAction = (XWikiAction)context.get(WRAPPED_ACTION_CONTEXT_KEY);
        if (wrappedAction != null) {
            return wrappedAction.render(context);
        }
        return "exception";
    }

    private String findBackURL(XWikiContext context) {
        XWikiRequest request = context.getRequest();
        String back = request.getParameter("xcontinue");
        if (StringUtils.isEmpty((CharSequence)back)) {
            back = request.getParameter("xredirect");
        }
        if (StringUtils.isEmpty((CharSequence)back)) {
            back = this.removeAllParametersFromQueryStringExceptEditor(request.getHeader("Referer"));
        }
        if (StringUtils.isEmpty((CharSequence)back)) {
            back = context.getDoc().getURL("edit", context);
        }
        return back;
    }

    private String removeAllParametersFromQueryStringExceptEditor(String url) {
        if (url == null) {
            return "";
        }
        String[] baseAndQuery = url.split("\\?");
        if (baseAndQuery.length < 2) {
            return url;
        }
        String[] queryBeforeAndAfterEditor = baseAndQuery[1].split("editor=");
        if (queryBeforeAndAfterEditor.length < 2) {
            return baseAndQuery[0];
        }
        return baseAndQuery[0] + "?editor=" + queryBeforeAndAfterEditor[1].split("&")[0];
    }
}

