/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.web;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.DocumentRevisionProvider;
import com.xpn.xwiki.doc.MetaDataDiff;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.doc.XWikiLock;
import com.xpn.xwiki.doc.merge.MergeConfiguration;
import com.xpn.xwiki.internal.mandatory.RedirectClassDocumentInitializer;
import com.xpn.xwiki.objects.ObjectDiff;
import com.xpn.xwiki.web.EditAction;
import com.xpn.xwiki.web.EditForm;
import com.xpn.xwiki.web.Utils;
import com.xpn.xwiki.web.XWikiRequest;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.suigeneris.jrcs.diff.DifferentiationFailedException;
import org.suigeneris.jrcs.diff.delta.Delta;
import org.suigeneris.jrcs.rcs.Version;
import org.xwiki.bridge.DocumentModelBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.diff.ConflictDecision;
import org.xwiki.job.Job;
import org.xwiki.model.document.DocumentAuthors;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.refactoring.job.CreateRequest;
import org.xwiki.refactoring.script.RefactoringScriptService;
import org.xwiki.script.service.ScriptService;
import org.xwiki.store.TemporaryAttachmentSessionsManager;
import org.xwiki.store.merge.MergeConflictDecisionsManager;
import org.xwiki.store.merge.MergeDocumentResult;
import org.xwiki.store.merge.MergeManager;
import org.xwiki.user.CurrentUserReference;
import org.xwiki.user.UserReference;
import org.xwiki.user.UserReferenceResolver;

@Component
@Named(value="save")
@Singleton
public class SaveAction
extends EditAction {
    public static final String ACTION_NAME = "save";
    protected static final String ASYNC_PARAM = "async";
    private static final Logger LOGGER = LoggerFactory.getLogger(SaveAction.class);
    static final String JSON_ANSWER_KEY = "SaveAction.jsonAnswer";
    private static final String FORCE_SAVE_MERGE = "merge";
    private static final String FORCE_SAVE_OVERRIDE = "override";
    @Inject
    private DocumentRevisionProvider documentRevisionProvider;
    @Inject
    private MergeManager mergeManager;
    @Inject
    private MergeConflictDecisionsManager conflictDecisionsManager;
    @Inject
    private TemporaryAttachmentSessionsManager temporaryAttachmentSessionsManager;
    @Inject
    private UserReferenceResolver<CurrentUserReference> currentUserResolver;

    public SaveAction() {
        this.waitForXWikiInitialization = true;
    }

    public boolean save(XWikiContext context) throws XWikiException {
        XWikiDocument tdoc;
        XWikiDocument originalDoc;
        int sectionNumber;
        EditForm form;
        XWikiDocument doc;
        XWikiRequest request;
        XWiki xwiki;
        block28: {
            xwiki = context.getWiki();
            request = context.getRequest();
            doc = context.getDoc();
            form = (EditForm)context.getForm();
            sectionNumber = 0;
            if (request.getParameter("section") != null && xwiki.hasSectionEdit(context)) {
                sectionNumber = Integer.parseInt(request.getParameter("section"));
            }
            if (doc.isNew() && !this.isEntityReferenceNameValid((EntityReference)doc.getDocumentReference())) {
                context.put("message", "entitynamevalidation.create.invalidname");
                context.put("messageParameters", new Object[]{this.getLocalSerializer().serialize((EntityReference)doc.getDocumentReference(), new Object[0])});
                return true;
            }
            originalDoc = doc;
            doc = doc.clone();
            String language = form.getLanguage();
            if (doc.isNew() || language == null || language.equals("") || language.equals("default") || language.equals(doc.getDefaultLanguage())) {
                tdoc = doc;
            } else {
                tdoc = doc.getTranslatedDocument(language, context);
                if (tdoc == doc && xwiki.isMultiLingual(context)) {
                    tdoc = new XWikiDocument(doc.getDocumentReference());
                    tdoc.setLanguage(language);
                    tdoc.setStore(doc.getStore());
                    originalDoc = tdoc;
                } else if (tdoc != doc) {
                    originalDoc = tdoc;
                    tdoc = tdoc.clone();
                }
            }
            if (doc.isNew()) {
                doc.setLocale(Locale.ROOT);
                if (doc.getDefaultLocale() == Locale.ROOT) {
                    doc.setDefaultLocale(xwiki.getLocalePreference(context));
                }
            }
            try {
                this.readFromTemplate(tdoc, form.getTemplate(), context);
            }
            catch (XWikiException e) {
                if (e.getCode() != 11002) break block28;
                context.put("exception", e);
                return true;
            }
        }
        if (form.isConvertSyntax() && !tdoc.getSyntax().toIdString().equals(form.getSyntaxId())) {
            this.convertSyntax(tdoc, form.getSyntaxId(), context);
        }
        if (sectionNumber != 0) {
            XWikiDocument sectionDoc = tdoc.clone();
            sectionDoc.readFromForm(form, context);
            String sectionContent = sectionDoc.getContent() + "\n";
            String content = tdoc.updateDocumentSection(sectionNumber, sectionContent);
            tdoc.setAttachmentList(sectionDoc.getAttachmentList());
            tdoc.setContent(content);
            tdoc.setComment(sectionDoc.getComment());
            tdoc.setMinorEdit(sectionDoc.isMinorEdit());
        } else {
            tdoc.readFromForm(form, context);
        }
        if (tdoc.getXObject((EntityReference)RedirectClassDocumentInitializer.REFERENCE) != null && request.getParameter("XWiki.RedirectClass_0_location") == null) {
            tdoc.removeXObjects((EntityReference)RedirectClassDocumentInitializer.REFERENCE);
        }
        boolean dirtyBeforeSettingAuthors = tdoc.isContentDirty() || tdoc.isMetaDataDirty();
        UserReference currentUserReference = this.currentUserResolver.resolve((Object)CurrentUserReference.INSTANCE, new Object[0]);
        tdoc.getAuthors().setOriginalMetadataAuthor(currentUserReference);
        request.getEffectiveAuthor().ifPresent(arg_0 -> ((DocumentAuthors)tdoc.getAuthors()).setEffectiveMetadataAuthor(arg_0));
        if (tdoc.isNew()) {
            tdoc.getAuthors().setCreator(currentUserReference);
        }
        if ("1".equals(request.getParameter("xvalidate")) && !tdoc.validate(context)) {
            context.put("display", "edit");
            context.setAction(tdoc.getDefaultEditMode(context));
            context.put("doc", doc);
            context.put("cdoc", tdoc);
            context.put("tdoc", tdoc);
            this.getCurrentScriptContext().setAttribute("editor", "inline", 100);
            return true;
        }
        LinkedHashMap<String, String> jsonAnswer = new LinkedHashMap<String, String>();
        context.put(JSON_ANSWER_KEY, jsonAnswer);
        if (this.isConflictCheckEnabled() && Utils.isAjaxRequest(context).booleanValue() && request.getParameter("previousVersion") != null && this.isConflictingWithVersion(context, originalDoc, tdoc)) {
            return true;
        }
        xwiki.checkSavingDocument(context.getUserReference(), tdoc, tdoc.getComment(), tdoc.isMinorEdit(), context);
        if (tdoc.isNew() || dirtyBeforeSettingAuthors || StringUtils.isNotEmpty((CharSequence)tdoc.getComment()) || !"true".equals(request.getParameter("preventEmptyRevision"))) {
            tdoc.setMetaDataDirty(true);
            xwiki.saveDocument(tdoc, tdoc.getComment(), tdoc.isMinorEdit(), context);
        } else {
            jsonAnswer.put("noChanges", "true");
        }
        jsonAnswer.put("newVersion", tdoc.getRCSVersion().toString());
        this.temporaryAttachmentSessionsManager.removeUploadedAttachments(tdoc.getDocumentReference());
        Job createJob = this.startCreateJob((EntityReference)tdoc.getDocumentReference(), form);
        if (createJob != null) {
            if (this.isAsync(request)) {
                if (Utils.isAjaxRequest(context).booleanValue()) {
                    this.sendRedirect(context.getResponse(), String.format("%s/rest/jobstatus/%s?media=json", context.getRequest().getContextPath(), this.serializeJobId(createJob.getRequest().getId())));
                }
            } else {
                try {
                    createJob.join();
                }
                catch (InterruptedException e) {
                    throw new XWikiException(String.format("Interrupted while waiting for template [%s] to be processed when creating the document [%s]", form.getTemplate(), tdoc.getDocumentReference()), e);
                }
            }
        } else {
            XWikiLock lock = tdoc.getLock(context);
            if (lock != null) {
                tdoc.removeLock(context);
            }
        }
        return false;
    }

    private boolean isConflictCheckEnabled() {
        ConfigurationSource configurationSource = Utils.getComponent(ConfigurationSource.class, "xwikiproperties");
        return (Boolean)configurationSource.getProperty("edit.conflictChecking.enabled", (Object)true);
    }

    private void recordConflictDecisions(XWikiContext context, DocumentReference documentReference) {
        String conflictReference;
        XWikiRequest request = context.getRequest();
        String[] mergeChoices = request.getParameterValues("mergeChoices");
        String[] customChoices = request.getParameterValues("customChoices");
        HashMap<String, String> customChoicesMap = new HashMap<String, String>();
        if (customChoices != null) {
            for (String customChoice : customChoices) {
                String[] splittedCustomChoiceInfo = customChoice.split("=");
                conflictReference = splittedCustomChoiceInfo[0];
                String customValue = customChoice.substring(conflictReference.length() + 1);
                try {
                    customValue = URLDecoder.decode(customValue, request.getCharacterEncoding());
                }
                catch (UnsupportedEncodingException e) {
                    LOGGER.error("Error while decoding a custom value decision.", (Throwable)e);
                }
                customChoicesMap.put(conflictReference, customValue);
            }
        }
        if (mergeChoices != null) {
            for (String choice : mergeChoices) {
                String[] splittedChoiceInfo = choice.split("=");
                conflictReference = splittedChoiceInfo[0];
                String selectedChoice = splittedChoiceInfo[1];
                List<String> customValue = null;
                ConflictDecision.DecisionType decisionType = ConflictDecision.DecisionType.valueOf((String)selectedChoice.toUpperCase());
                if (decisionType == ConflictDecision.DecisionType.CUSTOM) {
                    customValue = Collections.singletonList((String)customChoicesMap.get(conflictReference));
                }
                this.conflictDecisionsManager.recordDecision(documentReference, (EntityReference)context.getUserReference(), conflictReference, decisionType, customValue);
            }
        }
    }

    private boolean isConflictingWithVersion(XWikiContext context, XWikiDocument originalDoc, XWikiDocument modifiedDoc) throws XWikiException {
        XWikiRequest request = context.getRequest();
        if (FORCE_SAVE_OVERRIDE.equals(request.getParameter("forceSave"))) {
            return false;
        }
        if ("true".equals(request.getParameter("isNew")) && originalDoc.isNew()) {
            return false;
        }
        Version previousVersion = new Version(request.getParameter("previousVersion"));
        Version latestVersion = originalDoc.getRCSVersion();
        Date editingVersionDate = new Date(Long.parseLong(request.getParameter("editingVersionDate")));
        Date latestVersionDate = originalDoc.getDate();
        if (!latestVersion.equals((Object)previousVersion) || latestVersionDate.after(editingVersionDate)) {
            try {
                XWikiDocument previousDoc = this.documentRevisionProvider.getRevision(originalDoc, previousVersion.toString());
                if (!originalDoc.isNew() && previousDoc != null) {
                    List<Delta> contentDiff = originalDoc.getContentDiff(previousVersion.toString(), latestVersion.toString(), context);
                    List<List<ObjectDiff>> objectDiff = originalDoc.getObjectDiff(previousVersion.toString(), latestVersion.toString(), context);
                    List<MetaDataDiff> metaDataDiff = originalDoc.getMetaDataDiff(previousVersion.toString(), latestVersion.toString(), context);
                    ArrayList<MetaDataDiff> filteredMetaDataDiff = new ArrayList<MetaDataDiff>();
                    for (MetaDataDiff dataDiff : metaDataDiff) {
                        if (dataDiff.getField().equals("author")) continue;
                        filteredMetaDataDiff.add(dataDiff);
                    }
                    if (contentDiff.isEmpty() && objectDiff.isEmpty() && filteredMetaDataDiff.isEmpty()) {
                        return false;
                    }
                    MergeConfiguration mergeConfiguration = new MergeConfiguration();
                    mergeConfiguration.setUserReference((EntityReference)context.getUserReference());
                    mergeConfiguration.setConcernedDocument(modifiedDoc.getDocumentReferenceWithLocale());
                    mergeConfiguration.setProvidedVersionsModifiables(true);
                    this.recordConflictDecisions(context, modifiedDoc.getDocumentReferenceWithLocale());
                    MergeDocumentResult mergeDocumentResult = this.mergeManager.mergeDocument((DocumentModelBridge)previousDoc, (DocumentModelBridge)originalDoc, (DocumentModelBridge)modifiedDoc, mergeConfiguration);
                    this.conflictDecisionsManager.removeConflictDecisionList(modifiedDoc.getDocumentReferenceWithLocale(), (EntityReference)context.getUserReference());
                    if (FORCE_SAVE_MERGE.equals(request.getParameter("forceSave")) || !mergeDocumentResult.hasConflicts()) {
                        this.getJSONAnswer(context).put("mergedDocument", "true");
                        return false;
                    }
                    this.conflictDecisionsManager.recordConflicts(modifiedDoc.getDocumentReferenceWithLocale(), (EntityReference)context.getUserReference(), mergeDocumentResult.getConflicts(MergeDocumentResult.DocumentPart.CONTENT));
                }
                LinkedHashMap<String, String> jsonObject = new LinkedHashMap<String, String>();
                jsonObject.put("previousVersion", previousVersion.toString());
                jsonObject.put("previousVersionDate", editingVersionDate.toString());
                jsonObject.put("latestVersion", latestVersion.toString());
                jsonObject.put("latestVersionDate", latestVersionDate.toString());
                this.answerJSON(context, 409, jsonObject);
                return true;
            }
            catch (DifferentiationFailedException e) {
                throw new XWikiException("Error while loading the diff", e);
            }
        }
        return false;
    }

    Map<String, String> getJSONAnswer(XWikiContext context) {
        return (Map)context.get(JSON_ANSWER_KEY);
    }

    @Override
    public boolean action(XWikiContext context) throws XWikiException {
        if (!this.csrfTokenCheck(context, true)) {
            return false;
        }
        Boolean isAjaxRequest = Utils.isAjaxRequest(context);
        try {
            if (this.save(context)) {
                return true;
            }
        }
        catch (XWikiException e) {
            this.handleSaveException(isAjaxRequest, e, context);
            return isAjaxRequest == false;
        }
        if (isAjaxRequest.booleanValue()) {
            this.answerJSON(context, 200, this.getJSONAnswer(context));
        } else {
            this.sendRedirect(context.getResponse(), Utils.getRedirect("view", context));
        }
        return false;
    }

    @Override
    public String render(XWikiContext context) throws XWikiException {
        XWikiException e = (XWikiException)context.get("exception");
        if (e != null && e.getCode() == 11002) {
            return "docalreadyexists";
        }
        if ("edit".equals(context.get("display"))) {
            return context.getAction();
        }
        return "exception";
    }

    private boolean isAsync(XWikiRequest request) {
        return "true".equals(request.get(ASYNC_PARAM));
    }

    private Job startCreateJob(EntityReference entityReference, EditForm editForm) throws XWikiException {
        DocumentReference templateReference = this.resolveTemplate(editForm.getTemplate());
        if (templateReference == null) {
            return null;
        }
        RefactoringScriptService refactoring = (RefactoringScriptService)Utils.getComponent(ScriptService.class, "refactoring");
        CreateRequest request = refactoring.getRequestFactory().createCreateRequest(Arrays.asList(entityReference));
        request.setCheckAuthorRights(false);
        request.setEntityReferences(Arrays.asList(entityReference));
        request.setTemplateReference((EntityReference)templateReference);
        request.setSkippedEntities(Arrays.asList(entityReference));
        Job createJob = refactoring.create(request);
        if (createJob != null) {
            return createJob;
        }
        throw new XWikiException(String.format("Failed to schedule the create job for [%s]", entityReference), refactoring.getLastError());
    }

    private String serializeJobId(List<String> jobId) {
        return StringUtils.join(jobId, (String)"/");
    }

    private void convertSyntax(XWikiDocument doc, String targetSyntaxId, XWikiContext xcontext) throws XWikiException {
        doc.convertSyntax(targetSyntaxId, xcontext);
        for (Locale locale : doc.getTranslationLocales(xcontext)) {
            XWikiDocument tdoc;
            if (Objects.equals(locale, doc.getLocale()) || (tdoc = doc.getTranslatedDocument(locale, xcontext)).getSyntax().toIdString().equals(targetSyntaxId)) continue;
            tdoc.convertSyntax(targetSyntaxId, xcontext);
            xcontext.getWiki().saveDocument(tdoc, String.format("Document converted from syntax %s to syntax %s", tdoc.getSyntax().toIdString(), targetSyntaxId), xcontext);
        }
    }
}

