/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.web;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.util.Util;
import com.xpn.xwiki.web.Utils;
import com.xpn.xwiki.web.XWikiAction;
import com.xpn.xwiki.web.XWikiRequest;
import com.xpn.xwiki.web.XWikiResponse;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;

@Component
@Named(value="reset")
@Singleton
public class ResetVersionsAction
extends XWikiAction {
    @Override
    public boolean action(XWikiContext context) throws XWikiException {
        XWikiRequest request = context.getRequest();
        XWikiResponse response = context.getResponse();
        XWikiDocument doc = context.getDoc();
        String language = Util.normalizeLanguage(context.getRequest().getParameter("language"));
        String confirm = request.getParameter("confirm");
        if (confirm != null && confirm.equals("1")) {
            if (!this.csrfTokenCheck(context)) {
                return false;
            }
            XWikiDocument tdoc = this.getTranslatedDocument(doc, language, context);
            tdoc.resetArchive(context);
            return true;
        }
        String redirect = Utils.getRedirect(request, null);
        if (redirect == null) {
            return true;
        }
        this.sendRedirect(response, redirect);
        return false;
    }

    @Override
    public String render(XWikiContext context) throws XWikiException {
        XWikiRequest request = context.getRequest();
        String confirm = request.getParameter("confirm");
        if (confirm != null && confirm.equals("1")) {
            return "resetversionsdone";
        }
        return "resetversions";
    }
}

