/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.web;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.web.Utils;
import com.xpn.xwiki.web.XWikiAction;
import com.xpn.xwiki.web.XWikiRequest;
import com.xpn.xwiki.web.XWikiResponse;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.captcha.Captcha;
import org.xwiki.captcha.CaptchaConfiguration;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.security.authentication.RegistrationConfiguration;

@Component
@Named(value="register")
@Singleton
public class RegisterAction
extends XWikiAction {
    private static final String REGISTER = "register";
    private static final String REG_CONSTANT = "reg";
    private static final Logger LOGGER = LoggerFactory.getLogger(RegisterAction.class);
    private static final String WIKI_SPACE = "XWiki";
    private static final List<String> ALLOWED_TEMPLATES = Arrays.asList("register", "registerinline");
    @Inject
    private RegistrationConfiguration registrationConfiguration;

    @Override
    public boolean action(XWikiContext context) throws XWikiException {
        XWiki xwiki = context.getWiki();
        XWikiRequest request = context.getRequest();
        XWikiResponse response = context.getResponse();
        if (!ALLOWED_TEMPLATES.contains(Utils.getPage(context.getRequest(), REGISTER))) {
            throw new XWikiException(0, 9001, String.format("Forbidden template override with 'xpage' in [%s] action.", REGISTER));
        }
        String register = request.getParameter(REGISTER);
        if (register != null && register.equals("1")) {
            if (!this.csrfTokenCheck(context)) {
                return false;
            }
            int result = !this.verifyCaptcha(context, xwiki) ? -9 : (this.registrationConfiguration.isEmailValidationRequired() ? xwiki.createUser(true, "edit", context) : xwiki.createUser(context));
            this.getCurrentScriptContext().setAttribute(REG_CONSTANT, result, 100);
            String redirect = Utils.getRedirect(request, null);
            if (redirect == null) {
                return true;
            }
            this.sendRedirect(response, redirect);
            return false;
        }
        return true;
    }

    @Override
    public String render(XWikiContext context) throws XWikiException {
        return REGISTER;
    }

    private boolean verifyCaptcha(XWikiContext context, XWiki xwiki) throws XWikiException {
        if (xwiki.getRightService().hasProgrammingRights(context)) {
            return true;
        }
        DocumentReference configRef = new DocumentReference(context.getWikiId(), WIKI_SPACE, "RegistrationConfig");
        DocumentReference classReference = new DocumentReference(context.getWikiId(), WIKI_SPACE, "Registration");
        XWikiDocument configDoc = xwiki.getDocument(configRef, context);
        int requireCaptcha = configDoc.getIntValue(classReference, "requireCaptcha");
        if (requireCaptcha == 1) {
            CaptchaConfiguration captchaConfiguration = Utils.getComponent(CaptchaConfiguration.class);
            String defaultCaptchaName = captchaConfiguration.getDefaultName();
            try {
                Captcha captcha = Utils.getComponent(Captcha.class, defaultCaptchaName);
                if (!captcha.isValid()) {
                    LOGGER.warn("Incorrect CAPTCHA answer");
                    return false;
                }
            }
            catch (Exception e) {
                LOGGER.warn("Cannot verify answer for CAPTCHA of type [{}]: {}", (Object)defaultCaptchaName, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
                return false;
            }
        }
        return true;
    }
}

