/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.web;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.classes.BaseClass;
import com.xpn.xwiki.objects.classes.PropertyClass;
import com.xpn.xwiki.util.Util;
import com.xpn.xwiki.web.EditForm;
import com.xpn.xwiki.web.Utils;
import com.xpn.xwiki.web.XWikiAction;
import com.xpn.xwiki.web.XWikiForm;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;

@Component
@Named(value="propupdate")
@Singleton
public class PropUpdateAction
extends XWikiAction {
    @Override
    protected Class<? extends XWikiForm> getFormClass() {
        return EditForm.class;
    }

    public boolean propUpdate(XWikiContext context) throws XWikiException {
        XWiki xwiki = context.getWiki();
        XWikiDocument doc = context.getDoc();
        XWikiForm form = context.getForm();
        doc = doc.clone();
        BaseClass bclass = doc.getXClass();
        BaseClass bclass2 = bclass.clone();
        bclass2.setFields(new HashMap());
        HashMap<String, String> fieldsToRename = new HashMap<String, String>();
        for (PropertyClass originalProperty : bclass.getFieldList()) {
            PropertyClass newProperty = originalProperty.clone();
            String name = newProperty.getName();
            Map<String, String[]> map = ((EditForm)form).getObject(name);
            newProperty.getXClass(context).fromMap(map, newProperty);
            String newName = newProperty.getName();
            if (!Util.isValidXMLElementName(newName)) {
                context.put("message", "propertynamenotcorrect");
                return true;
            }
            if (newName.indexOf(" ") != -1) {
                newName = newName.replaceAll(" ", "");
                newProperty.setName(newName);
            }
            bclass2.addField(newName, newProperty);
            if (newName.equals(name)) continue;
            fieldsToRename.put(name, newName);
            bclass2.addPropertyForRemoval(originalProperty);
        }
        doc.setXClass(bclass2);
        doc.renameProperties(bclass.getName(), fieldsToRename);
        doc.setMetaDataDirty(true);
        if (doc.isNew()) {
            doc.setCreator(context.getUser());
        }
        doc.setAuthor(context.getUser());
        String comment = this.localizePlainOrKey("core.comment.updateClassProperty", new Object[0]);
        context.getWiki().checkSavingDocument(context.getUserReference(), doc, comment, true, context);
        xwiki.saveDocument(doc, comment, true, context);
        if (fieldsToRename.size() > 0) {
            List<String> list = xwiki.getStore().searchDocumentsNames(", BaseObject as obj where obj.name=doc.fullName and obj.className='" + Utils.SQLFilter(bclass.getName()) + "' and doc.fullName <> '" + Utils.SQLFilter(bclass.getName()) + "'", context);
            for (String docName : list) {
                XWikiDocument doc2 = xwiki.getDocument(docName, context);
                doc2.renameProperties(bclass.getName(), fieldsToRename);
                xwiki.saveDocument(doc2, this.localizePlainOrKey("core.comment.updateClassPropertyName", new Object[0]), true, context);
            }
        }
        return false;
    }

    @Override
    public boolean action(XWikiContext context) throws XWikiException {
        if (!this.csrfTokenCheck(context)) {
            return false;
        }
        try {
            if (this.propUpdate(context)) {
                return true;
            }
        }
        catch (XWikiException ex) {
            context.put("exception", ex);
            return true;
        }
        String redirect = Utils.getRedirect("view", context);
        this.sendRedirect(context.getResponse(), redirect);
        return false;
    }

    @Override
    public String render(XWikiContext context) throws XWikiException {
        return "exception";
    }
}

