/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.web;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.classes.BaseClass;
import com.xpn.xwiki.objects.classes.PropertyClass;
import com.xpn.xwiki.objects.meta.MetaClass;
import com.xpn.xwiki.objects.meta.PropertyMetaClass;
import com.xpn.xwiki.util.Util;
import com.xpn.xwiki.web.PropAddForm;
import com.xpn.xwiki.web.Utils;
import com.xpn.xwiki.web.XWikiAction;
import com.xpn.xwiki.web.XWikiForm;
import com.xpn.xwiki.web.XWikiResponse;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;

@Component
@Named(value="propadd")
@Singleton
public class PropAddAction
extends XWikiAction {
    @Override
    protected Class<? extends XWikiForm> getFormClass() {
        return PropAddForm.class;
    }

    @Override
    public boolean action(XWikiContext context) throws XWikiException {
        if (!this.csrfTokenCheck(context)) {
            return false;
        }
        XWiki xwiki = context.getWiki();
        XWikiResponse response = context.getResponse();
        XWikiDocument doc = context.getDoc();
        doc = doc.clone();
        XWikiForm form = context.getForm();
        String propName = ((PropAddForm)form).getPropName();
        if (!Util.isValidXMLElementName(propName)) {
            this.writeAjaxErrorResponse(400, this.localizePlainOrKey("action.addClassProperty.error.invalidName", new Object[0]), context);
            return false;
        }
        String propType = ((PropAddForm)form).getPropType();
        BaseClass bclass = doc.getXClass();
        bclass.setName(doc.getFullName());
        if (bclass.get(propName) != null) {
            String localizedMessage = this.localizePlainOrReturnKey("action.addClassProperty.error.alreadyExists", propName);
            this.writeAjaxErrorResponse(400, localizedMessage, context);
            return false;
        }
        MetaClass mclass = xwiki.getMetaclass();
        PropertyMetaClass pmclass = (PropertyMetaClass)mclass.get(propType);
        if (pmclass != null) {
            PropertyClass pclass = (PropertyClass)pmclass.newObject(context);
            pclass.setObject(bclass);
            pclass.setName(propName);
            pclass.setPrettyName(propName);
            bclass.put(propName, pclass);
            doc.setAuthorReference(context.getUserReference());
            if (doc.isNew()) {
                doc.setCreatorReference(context.getUserReference());
            }
            doc.setMetaDataDirty(true);
            String comment = this.localizePlainOrKey("core.comment.addClassProperty", new Object[0]);
            context.getWiki().checkSavingDocument(context.getUserReference(), doc, comment, true, context);
            xwiki.saveDocument(doc, comment, true, context);
        }
        String redirect = Utils.getRedirect("edit", "editor=class", context);
        this.sendRedirect(response, redirect);
        return false;
    }

    @Override
    public String render(XWikiContext context) throws XWikiException {
        return "exception";
    }
}

