/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.web;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.internal.web.LegacyAction;
import com.xpn.xwiki.web.EditAction;
import com.xpn.xwiki.web.XWikiAction;
import com.xpn.xwiki.web.XWikiRequest;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.document.DocumentAuthors;
import org.xwiki.user.CurrentUserReference;
import org.xwiki.user.UserReference;
import org.xwiki.user.UserReferenceResolver;

@Component
@Named(value="preview")
@Singleton
public class PreviewAction
extends EditAction {
    @Inject
    @Named(value="save")
    private LegacyAction saveAction;
    @Inject
    @Named(value="cancel")
    private LegacyAction cancelAction;
    @Inject
    @Named(value="saveandcontinue")
    private LegacyAction saveandcontinueAction;
    @Inject
    private UserReferenceResolver<CurrentUserReference> currentUserResolver;

    public PreviewAction() {
        this.waitForXWikiInitialization = true;
    }

    private boolean isActionSelected(String action) {
        return StringUtils.isNotEmpty((CharSequence)action);
    }

    @Override
    public boolean action(XWikiContext context) throws XWikiException {
        XWikiRequest request = context.getRequest();
        String formactionsave = request.getParameter("formactionsave");
        String formactioncancel = request.getParameter("formactioncancel");
        String formactionsac = request.getParameter("formactionsac");
        if (this.isActionSelected(formactionsave)) {
            if (((XWikiAction)this.saveAction).action(context)) {
                ((XWikiAction)this.saveAction).render(context);
            }
            return false;
        }
        if (this.isActionSelected(formactioncancel)) {
            if (((XWikiAction)this.cancelAction).action(context)) {
                ((XWikiAction)this.cancelAction).render(context);
            }
            return false;
        }
        if (this.isActionSelected(formactionsac)) {
            if (((XWikiAction)this.saveandcontinueAction).action(context)) {
                ((XWikiAction)this.saveandcontinueAction).render(context);
            }
            return false;
        }
        return this.csrfTokenCheck(context, true);
    }

    @Override
    public String render(XWikiContext context) throws XWikiException {
        XWikiDocument editedDocument = this.prepareEditedDocument(context);
        DocumentAuthors editedDocumentAuthors = editedDocument.getAuthors();
        UserReference currentUserReference = this.currentUserResolver.resolve((Object)CurrentUserReference.INSTANCE, new Object[0]);
        editedDocumentAuthors.setOriginalMetadataAuthor(currentUserReference);
        if (editedDocument.isNew()) {
            editedDocumentAuthors.setCreator(currentUserReference);
        }
        context.getRequest().getEffectiveAuthor().ifPresent(arg_0 -> ((DocumentAuthors)editedDocumentAuthors).setEffectiveMetadataAuthor(arg_0));
        if (editedDocument.isContentDirty()) {
            editedDocumentAuthors.setContentAuthor(editedDocumentAuthors.getEffectiveMetadataAuthor());
        }
        if ("1".equals(context.getRequest().getParameter("diff")) && StringUtils.isNotEmpty((CharSequence)context.getRequest().getParameter("version"))) {
            return "previewdiff";
        }
        return "preview";
    }
}

