/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.web;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.BaseProperty;
import com.xpn.xwiki.web.Utils;
import com.xpn.xwiki.web.XWikiAction;
import com.xpn.xwiki.web.XWikiRequest;
import com.xpn.xwiki.web.XWikiResponse;
import java.util.List;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;

@Component
@Named(value="objectsync")
@Singleton
public class ObjectsSynchronizeAction
extends XWikiAction {
    @Override
    public boolean action(XWikiContext context) throws XWikiException {
        XWiki xwiki = context.getWiki();
        XWikiResponse response = context.getResponse();
        XWikiDocument doc = context.getDoc();
        XWikiRequest request = context.getRequest();
        String className = request.getParameter("classname");
        String objectNumber = request.getParameter("object");
        if (className != null && objectNumber != null) {
            try {
                BaseObject object = doc.getObject(className, Integer.valueOf(objectNumber));
                this.synchronizeObject(object, context);
            }
            catch (Exception ex) {
                return true;
            }
        } else {
            for (List<BaseObject> classObjects : doc.getXObjects().values()) {
                for (BaseObject object : classObjects) {
                    if (object == null) continue;
                    this.synchronizeObject(object, context);
                }
            }
        }
        doc.setAuthorReference(context.getUserReference());
        xwiki.saveDocument(doc, this.localizePlainOrKey("core.model.xobject.synchronizeObjects.versionSummary", new Object[0]), true, context);
        if (Utils.isAjaxRequest(context).booleanValue()) {
            response.setStatus(204);
            response.setContentLength(0);
        } else {
            String redirect = Utils.getRedirect("edit", "editor=object", context);
            this.sendRedirect(response, redirect);
        }
        return false;
    }

    @Override
    public String render(XWikiContext context) throws XWikiException {
        context.getResponse().setStatus(404);
        context.put("message", "core.model.xobject.synchronizeObjects.error.missingObject");
        return "exception";
    }

    private void synchronizeObject(BaseObject object, XWikiContext context) {
        for (BaseProperty property : object.getXClass(context).getDeprecatedObjectProperties(object)) {
            object.removeField(property.getName());
        }
    }
}

