/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.web;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.web.ObjectRemoveForm;
import com.xpn.xwiki.web.Utils;
import com.xpn.xwiki.web.XWikiAction;
import com.xpn.xwiki.web.XWikiForm;
import com.xpn.xwiki.web.XWikiResponse;
import java.io.IOException;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;

@Component
@Named(value="objectremove")
@Singleton
public class ObjectRemoveAction
extends XWikiAction {
    @Override
    protected Class<? extends XWikiForm> getFormClass() {
        return ObjectRemoveForm.class;
    }

    protected BaseObject getObject(XWikiDocument doc, XWikiContext context) {
        ObjectRemoveForm form = (ObjectRemoveForm)context.getForm();
        BaseObject obj = null;
        String className = form.getClassName();
        int classId = form.getClassId();
        if (StringUtils.isBlank((CharSequence)className)) {
            this.getCurrentScriptContext().setAttribute("message", this.localizePlainOrKey("platform.core.action.objectRemove.noClassnameSpecified", new Object[0]), 100);
        } else if (classId < 0) {
            this.getCurrentScriptContext().setAttribute("message", this.localizePlainOrKey("platform.core.action.objectRemove.noObjectSpecified", new Object[0]), 100);
        } else {
            obj = doc.getObject(className, classId);
            if (obj == null) {
                this.getCurrentScriptContext().setAttribute("message", this.localizePlainOrKey("platform.core.action.objectRemove.invalidObject", new Object[0]), 100);
            }
        }
        return obj;
    }

    @Override
    public boolean action(XWikiContext context) throws XWikiException {
        if (!this.csrfTokenCheck(context)) {
            return false;
        }
        XWiki xwiki = context.getWiki();
        XWikiResponse response = context.getResponse();
        DocumentReference userReference = context.getUserReference();
        XWikiDocument doc = context.getDoc();
        BaseObject obj = this.getObject(doc = doc.clone(), context);
        if (obj == null) {
            return true;
        }
        doc.removeObject(obj);
        doc.setAuthorReference(userReference);
        String comment = this.localizePlainOrKey("core.comment.deleteObject", new Object[0]);
        context.getWiki().checkSavingDocument(userReference, doc, comment, true, context);
        xwiki.saveDocument(doc, comment, true, context);
        if (Utils.isAjaxRequest(context).booleanValue()) {
            response.setStatus(204);
            response.setContentLength(0);
        } else {
            String redirect = Utils.getRedirect("edit", context);
            this.sendRedirect(response, redirect);
        }
        return false;
    }

    @Override
    public String render(XWikiContext context) throws XWikiException {
        if (Utils.isAjaxRequest(context).booleanValue()) {
            XWikiResponse response = context.getResponse();
            response.setStatus(409);
            response.setContentType("text/plain");
            try {
                response.getWriter().write("failed");
                response.setContentLength(6);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return null;
        }
        return "error";
    }
}

