/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.web;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.classes.BaseClass;
import com.xpn.xwiki.objects.classes.PropertyClass;
import com.xpn.xwiki.web.ObjectAddForm;
import com.xpn.xwiki.web.Utils;
import com.xpn.xwiki.web.XWikiAction;
import com.xpn.xwiki.web.XWikiForm;
import com.xpn.xwiki.web.XWikiResponse;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Pattern;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceResolver;

@Component
@Named(value="objectadd")
@Singleton
public class ObjectAddAction
extends XWikiAction {
    private static final String[] EMPTY_PROPERTY = new String[]{""};
    private static final Pattern XOBJECT_NUMBER_PARAMETER = Pattern.compile("(\\?|&)xobjectNumber=?(&|#|$)");
    private EntityReferenceResolver<String> relativeResolver = (EntityReferenceResolver)Utils.getComponent(EntityReferenceResolver.TYPE_STRING, "relative");

    @Override
    protected Class<? extends XWikiForm> getFormClass() {
        return ObjectAddForm.class;
    }

    @Override
    public boolean action(XWikiContext context) throws XWikiException {
        if (!this.csrfTokenCheck(context)) {
            return false;
        }
        XWiki xwiki = context.getWiki();
        XWikiResponse response = context.getResponse();
        DocumentReference userReference = context.getUserReference();
        XWikiDocument doc = context.getDoc();
        doc = doc.clone();
        ObjectAddForm oform = (ObjectAddForm)context.getForm();
        String className = oform.getClassName();
        EntityReference classReference = this.relativeResolver.resolve((Object)className, EntityType.DOCUMENT, new Object[0]);
        BaseObject object = doc.newXObject(classReference, context);
        BaseClass baseclass = object.getXClass(context);
        Map<String, String[]> objmap = oform.getObject(className);
        Collection fields = baseclass.getFieldList();
        for (PropertyClass property : fields) {
            String name = property.getName();
            if (objmap.get(name) != null) continue;
            objmap.put(name, EMPTY_PROPERTY);
        }
        baseclass.fromMap(objmap, object);
        doc.setAuthorReference(userReference);
        if (doc.isNew()) {
            doc.setCreatorReference(userReference);
        }
        String comment = this.localizePlainOrKey("core.comment.addObject", new Object[0]);
        context.getWiki().checkSavingDocument(userReference, doc, comment, true, context);
        xwiki.saveDocument(doc, comment, true, context);
        if (Utils.isAjaxRequest(context).booleanValue()) {
            context.getResponse().setStatus(204);
            return false;
        }
        String redirect = Utils.getRedirect("edit", "editor=object", "xcontinue", "xredirect");
        redirect = XOBJECT_NUMBER_PARAMETER.matcher(redirect).replaceFirst("$1xobjectNumber=" + object.getNumber() + "$2");
        this.sendRedirect(response, redirect);
        return false;
    }
}

