/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.web;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.web.Utils;
import com.xpn.xwiki.web.XWikiAction;
import com.xpn.xwiki.web.XWikiRequest;
import com.xpn.xwiki.web.XWikiResponse;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.WikiReference;

@Component
@Named(value="logout")
@Singleton
public class LogoutAction
extends XWikiAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogoutAction.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean action(XWikiContext context) throws XWikiException {
        XWikiRequest request = context.getRequest();
        XWikiResponse response = context.getResponse();
        HttpSession currentSession = request.getSession(false);
        if (currentSession != null) {
            HttpSession httpSession = currentSession;
            synchronized (httpSession) {
                currentSession.invalidate();
                request.getSession(true);
            }
        }
        if (!response.isCommitted()) {
            String redirect = context.getRequest().getParameter("xredirect");
            if (StringUtils.isEmpty((CharSequence)redirect)) {
                DocumentReferenceResolver resolver = (DocumentReferenceResolver)Utils.getComponent(DocumentReferenceResolver.TYPE_REFERENCE);
                DocumentReference reference = resolver.resolve(null, new Object[]{EntityType.DOCUMENT});
                reference = reference.setWikiReference(new WikiReference(context.getWikiId()));
                redirect = context.getWiki().getURL(reference, "view", context);
            }
            this.sendRedirect(response, redirect);
        } else {
            LOGGER.debug("Skipping the redirect because the response has already been committed (e.g. by a custom authenticator)");
        }
        return false;
    }
}

