/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.web;

import com.xpn.xwiki.internal.web.LegacyAction;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.Collections;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.util.DefaultParameterizedType;
import org.xwiki.resource.ResourceReferenceResolver;
import org.xwiki.resource.ResourceType;
import org.xwiki.resource.ResourceTypeResolver;
import org.xwiki.resource.entity.EntityResourceReference;
import org.xwiki.url.ExtendedURL;

public class LegacyActionServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private ResourceTypeResolver<ExtendedURL> typeResolver;
    private ResourceReferenceResolver<ExtendedURL> resolver;
    private ComponentManager rootComponentManager;

    public void init() throws ServletException {
        super.init();
        this.rootComponentManager = (ComponentManager)this.getServletContext().getAttribute(ComponentManager.class.getName());
        try {
            this.typeResolver = (ResourceTypeResolver)this.rootComponentManager.getInstance((Type)new DefaultParameterizedType(null, ResourceTypeResolver.class, new Type[]{ExtendedURL.class}));
        }
        catch (ComponentLookupException e) {
            throw new ServletException("Failed to lookup the resource type resolve for ExtendedURL", (Throwable)e);
        }
        try {
            this.resolver = (ResourceReferenceResolver)this.rootComponentManager.getInstance((Type)new DefaultParameterizedType(null, ResourceReferenceResolver.class, new Type[]{ExtendedURL.class}));
        }
        catch (ComponentLookupException e) {
            throw new ServletException("Failed to lookup the resource reference resolve for ExtendedURL", (Throwable)e);
        }
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        LegacyAction action;
        String actionName = this.getActionName(req);
        if (this.rootComponentManager.hasComponent(LegacyAction.class, actionName)) {
            try {
                action = (LegacyAction)this.rootComponentManager.getInstance(LegacyAction.class, actionName);
            }
            catch (ComponentLookupException e) {
                throw new ServletException("Failed to lookup the action with name [" + actionName + "]", (Throwable)e);
            }
        }
        try {
            actionName = "unknown";
            action = (LegacyAction)this.rootComponentManager.getInstance(LegacyAction.class);
        }
        catch (ComponentLookupException e) {
            throw new ServletException("Failed to lookup the default action", (Throwable)e);
        }
        try {
            action.execute(req, resp);
        }
        catch (Exception e) {
            throw new ServletException("Failed to execute the action with name [" + actionName + "]", (Throwable)e);
        }
    }

    private String getActionName(HttpServletRequest req) throws ServletException {
        String url = req.getRequestURL().toString();
        try {
            ExtendedURL extendedURL = new ExtendedURL(new URL(url), req.getContextPath());
            ResourceType type = this.typeResolver.resolve((Object)extendedURL, Collections.emptyMap());
            EntityResourceReference entityResourceReference = (EntityResourceReference)this.resolver.resolve((Object)extendedURL, type, Collections.emptyMap());
            return entityResourceReference.getAction().getActionName();
        }
        catch (Exception e) {
            throw new ServletException("Failed to extract the Entity Action from URL [" + url + "]", (Throwable)e);
        }
    }
}

