/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.web;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiAttachment;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.internal.filter.input.XWikiAttachmentContentInputSource;
import com.xpn.xwiki.util.Util;
import com.xpn.xwiki.web.Utils;
import com.xpn.xwiki.web.XWikiAction;
import com.xpn.xwiki.web.XWikiRequest;
import com.xpn.xwiki.web.XWikiResponse;
import java.io.IOException;
import java.io.OutputStream;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.apache.tika.mime.MediaType;
import org.xwiki.component.annotation.Component;
import org.xwiki.filter.FilterException;
import org.xwiki.filter.input.InputSource;
import org.xwiki.internal.filter.Importer;
import org.xwiki.localization.LocaleUtils;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceResolver;
import org.xwiki.model.reference.EntityReferenceSet;
import org.xwiki.model.reference.LocalDocumentReference;
import org.xwiki.xar.XarException;
import org.xwiki.xar.XarPackage;

@Component
@Named(value="import")
@Singleton
public class ImportAction
extends XWikiAction {
    private static final String TEMPLATE_ADMIN = "admin";
    private static final String TEMPLATE_IMPORTED = "imported";

    @Override
    public String render(XWikiContext context) throws XWikiException {
        String result = null;
        try {
            XWikiRequest request = context.getRequest();
            XWikiResponse response = context.getResponse();
            XWikiDocument doc = context.getDoc();
            String name = request.get("name");
            String action = request.get("action");
            if (!context.getWiki().getRightService().hasWikiAdminRights(context)) {
                context.put("message", "needadminrights");
                return "exception";
            }
            if (name == null) {
                return TEMPLATE_ADMIN;
            }
            if ("getPackageInfos".equals(action)) {
                this.getPackageInfos(doc.getAttachment(name), response, context);
            } else if ("import".equals(action)) {
                result = this.importPackage(doc.getAttachment(name), request, context);
            }
        }
        catch (Exception e) {
            throw new XWikiException(11, 11015, "Exception while importing", e);
        }
        return result;
    }

    private void getPackageInfos(XWikiAttachment packFile, XWikiResponse response, XWikiContext xcontext) throws IOException, XWikiException, XarException {
        String encoding = xcontext.getWiki().getEncoding();
        response.setContentType(MediaType.APPLICATION_XML.toString());
        response.setCharacterEncoding(encoding);
        XarPackage xarPackage = new XarPackage(packFile.getContentInputStream(xcontext));
        xarPackage.write((OutputStream)response.getOutputStream(), encoding);
    }

    private String importPackage(XWikiAttachment packFile, XWikiRequest request, XWikiContext context) throws IOException, XWikiException, FilterException {
        String all = request.get("all");
        if (!"1".equals(all)) {
            this.importPackageFilterStream(packFile, request, context);
            if (!StringUtils.isBlank((CharSequence)request.getParameter("ajax"))) {
                return TEMPLATE_IMPORTED;
            }
            return TEMPLATE_ADMIN;
        }
        return null;
    }

    private String getLocale(String pageName, XWikiRequest request) {
        return Util.normalizeLanguage(request.get("language_" + pageName));
    }

    private int getAction(String pageName, String language, XWikiRequest request) {
        int iAction;
        String defaultAction;
        String actionName = "action_" + pageName;
        if (!StringUtils.isBlank((CharSequence)language)) {
            actionName = actionName + "_" + language;
        }
        if (StringUtils.isBlank((CharSequence)(defaultAction = request.get(actionName)))) {
            iAction = 0;
        } else {
            try {
                iAction = Integer.parseInt(defaultAction);
            }
            catch (Exception e) {
                iAction = 1;
            }
        }
        return iAction;
    }

    private String getDocumentReference(String pageEntry) {
        return pageEntry.replaceAll(":[^:]*$", "");
    }

    private void importPackageFilterStream(XWikiAttachment packFile, XWikiRequest request, XWikiContext context) throws IOException, XWikiException, FilterException {
        EntityReferenceSet entities;
        XWikiAttachmentContentInputSource source = new XWikiAttachmentContentInputSource(packFile.getAttachmentContent(context));
        String historyStrategy = request.getParameter("historyStrategy");
        boolean importAsBackup = Strings.CS.equals(request.getParameter("importAsBackup"), "true");
        String[] pages = request.getParameterValues("pages");
        if (pages != null) {
            entities = new EntityReferenceSet();
            EntityReferenceResolver resolver = (EntityReferenceResolver)Utils.getComponent(EntityReferenceResolver.TYPE_STRING, "relative");
            for (String pageEntry : pages) {
                if (!StringUtils.isNotEmpty((CharSequence)pageEntry)) continue;
                String locale = this.getLocale(pageEntry, request);
                int iAction = this.getAction(pageEntry, locale, request);
                String documentReference = this.getDocumentReference(pageEntry);
                if (iAction != 0) continue;
                entities.includes((EntityReference)new LocalDocumentReference(resolver.resolve((Object)documentReference, EntityType.DOCUMENT, new Object[0]), LocaleUtils.toLocale((String)locale)));
            }
        } else {
            entities = null;
        }
        Utils.getComponent(Importer.class).importXAR((InputSource)source, entities, historyStrategy, importAsBackup, context);
    }
}

