/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.web;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiAttachment;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.internal.model.LegacySpaceResolver;
import com.xpn.xwiki.internal.web.LegacyAction;
import com.xpn.xwiki.web.ExportURLFactoryActionHandler;
import com.xpn.xwiki.web.SkinAction;
import com.xpn.xwiki.web.Utils;
import com.xpn.xwiki.web.XWikiServletResponseStub;
import com.xpn.xwiki.web.XWikiServletURLFactory;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Provider;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.component.util.DefaultParameterizedType;
import org.xwiki.model.reference.AttachmentReference;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.url.filesystem.FilesystemExportContext;

public class ExportURLFactory
extends XWikiServletURLFactory {
    protected static final Logger LOGGER = LoggerFactory.getLogger(ExportURLFactory.class);
    private static Pattern CSSIMPORT = Pattern.compile("^\\s*@import\\s*\"(.*)\"\\s*;$", 8);
    private LegacySpaceResolver legacySpaceResolver = Utils.getComponent(LegacySpaceResolver.class);
    private EntityReferenceSerializer<String> fsPathEntityReferenceSerializer = (EntityReferenceSerializer)Utils.getComponent(EntityReferenceSerializer.TYPE_STRING, "fspath");
    @Deprecated
    protected Set<String> exportedPages = new HashSet<String>();
    @Deprecated
    protected File exportDir;
    private FilesystemExportContext exportContext;

    public FilesystemExportContext getFilesystemExportContext() {
        return this.exportContext;
    }

    @Deprecated
    public Collection<String> getNeededSkins() {
        return this.getFilesystemExportContext().getNeededSkins();
    }

    @Deprecated
    public Collection<String> getExportedSkinFiles() {
        return this.getFilesystemExportContext().getExportedSkinFiles();
    }

    public void init(Collection<DocumentReference> exportedPages, File exportDir, FilesystemExportContext exportContext, XWikiContext context) {
        super.init(context);
        this.exportContext = exportContext;
        if (exportDir != null) {
            this.getFilesystemExportContext().setExportDir(exportDir);
            this.exportDir = this.getFilesystemExportContext().getExportDir();
        }
        if (exportedPages != null) {
            for (DocumentReference pageReference : exportedPages) {
                this.getFilesystemExportContext().addExportedPage((String)this.fsPathEntityReferenceSerializer.serialize((EntityReference)pageReference, new Object[0]));
                EntityReferenceSerializer defaultEntityReferenceSerializer = (EntityReferenceSerializer)Utils.getComponent(EntityReferenceSerializer.TYPE_STRING);
                this.exportedPages.add((String)defaultEntityReferenceSerializer.serialize((EntityReference)pageReference, new Object[0]));
            }
        }
    }

    @Deprecated
    public void init(Collection<String> exportedPages, File exportDir, XWikiContext context) {
        Provider exportContextProvider = (Provider)Utils.getComponent((Type)new DefaultParameterizedType(null, Provider.class, new Type[]{FilesystemExportContext.class}));
        DocumentReferenceResolver resolver = (DocumentReferenceResolver)Utils.getComponent(DocumentReferenceResolver.TYPE_STRING, "current");
        ArrayList<DocumentReference> references = new ArrayList<DocumentReference>();
        for (String exportedPage : exportedPages) {
            references.add(resolver.resolve((Object)exportedPage, new Object[0]));
        }
        this.init(references, exportDir, (FilesystemExportContext)exportContextProvider.get(), context);
    }

    @Override
    public URL createSkinURL(String filename, String skin, XWikiContext context, Map<String, Object> queryParameters) {
        return this.createSkinURL(filename, skin, context);
    }

    @Override
    public URL createSkinURL(String filename, String skin, XWikiContext context) {
        try {
            this.getFilesystemExportContext().addNeededSkin(skin);
            StringBuilder newPath = new StringBuilder("file://");
            this.adjustCSSPath(newPath);
            newPath.append("skins/");
            newPath.append(skin);
            this.addFileName(newPath, filename, false, context);
            return new URL(newPath.toString());
        }
        catch (Exception e) {
            LOGGER.error("Failed to create skin URL", (Throwable)e);
            return super.createSkinURL(filename, skin, context);
        }
    }

    @Override
    public URL createSkinURL(String filename, String spaces, String name, XWikiContext context) {
        return this.createSkinURL(filename, spaces, name, null, context, false);
    }

    public URL createSkinURL(String filename, String spaces, String name, XWikiContext context, boolean skipSkinDirectory) {
        return this.createSkinURL(filename, spaces, name, null, context, skipSkinDirectory);
    }

    @Override
    public URL createSkinURL(String fileName, String spaces, String name, String wikiId, XWikiContext context) {
        return this.createSkinURL(fileName, spaces, name, wikiId, context, false);
    }

    @Override
    public URL createSkinURL(String filename, String spaces, String name, String xwikidb, XWikiContext context, Map<String, Object> queryParameters) {
        return this.createSkinURL(filename, spaces, name, xwikidb, context, false);
    }

    public URL createSkinURL(String fileName, String spaces, String name, String wikiId, XWikiContext context, boolean skipSkinDirectory) {
        URL skinURL = wikiId == null ? super.createSkinURL(fileName, spaces, name, context, Collections.emptyMap()) : super.createSkinURL(fileName, spaces, name, wikiId, context, Collections.emptyMap());
        if (!"skins".equals(spaces)) {
            return skinURL;
        }
        try {
            this.getFilesystemExportContext().addNeededSkin(name);
            StringBuffer filePathBuffer = new StringBuffer();
            if (!skipSkinDirectory) {
                filePathBuffer.append("skins/");
                filePathBuffer.append(name);
                filePathBuffer.append("/");
            }
            filePathBuffer.append(fileName);
            String filePath = filePathBuffer.toString();
            if (!this.getFilesystemExportContext().hasExportedSkinFile(filePath)) {
                this.getFilesystemExportContext().addExportedSkinFile(filePath);
                File file = new File(this.getFilesystemExportContext().getExportDir(), filePath);
                if (!file.exists()) {
                    File folder = file.getParentFile();
                    if (!folder.exists()) {
                        folder.mkdirs();
                    }
                    this.renderSkinFile(skinURL.getPath(), spaces, name, wikiId, file, StringUtils.countMatches((CharSequence)filePath, (CharSequence)"/"), context);
                }
                this.followCssImports(file, spaces, name, wikiId, context);
            }
            StringBuilder newPath = new StringBuilder("file://");
            this.adjustCSSPath(newPath);
            newPath.append(filePath);
            skinURL = new URL(newPath.toString());
        }
        catch (Exception e) {
            LOGGER.error("Failed to create skin URL", (Throwable)e);
        }
        return skinURL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderSkinFile(String path, String spaces, String name, String wikiId, File outputFile, int cssPathAdjustmentValue, XWikiContext context) throws IOException, XWikiException {
        FileOutputStream fos = new FileOutputStream(outputFile);
        String database = context.getWikiId();
        try {
            XWikiServletResponseStub response = new XWikiServletResponseStub();
            response.setOutpuStream(fos);
            context.setResponse(response);
            if (wikiId != null) {
                context.setWikiId(wikiId);
            }
            this.getFilesystemExportContext().pushCSSParentLevels(cssPathAdjustmentValue);
            try {
                this.renderWithSkinAction(spaces, name, wikiId, path, context);
            }
            finally {
                this.getFilesystemExportContext().popCSSParentLevels();
            }
        }
        finally {
            fos.close();
            if (wikiId != null) {
                context.setWikiId(database);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderWithSkinAction(String spaces, String name, String wikiId, String path, XWikiContext context) throws IOException, XWikiException {
        DocumentReference dummyDocumentReference = new DocumentReference(wikiId, this.legacySpaceResolver.resolve(spaces), name);
        XWikiDocument dummyDocument = context.getWiki().getDocument(dummyDocumentReference, context);
        HashMap<String, Object> backup = new HashMap<String, Object>();
        XWikiDocument.backupContext(backup, context);
        try {
            dummyDocument.setAsContextDoc(context);
            SkinAction skinAction = (SkinAction)Utils.getComponent(LegacyAction.class, "skin");
            skinAction.render(path, context);
        }
        finally {
            XWikiDocument.restoreContext(backup, context);
        }
    }

    private void followCssImports(File file, String spaces, String name, String wikiId, XWikiContext context) throws IOException {
        if (file.getName().endsWith(".css")) {
            String content = FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
            Matcher matcher = CSSIMPORT.matcher(content);
            while (matcher.find()) {
                String fileName = matcher.group(1);
                while (fileName.startsWith("../")) {
                    fileName = Strings.CS.removeStart(fileName, (CharSequence)"../");
                }
                if (wikiId == null) {
                    this.createSkinURL(fileName, spaces, name, context, true);
                    continue;
                }
                this.createSkinURL(fileName, spaces, name, wikiId, context, true);
            }
        }
    }

    @Override
    public URL createResourceURL(String filename, boolean forceSkinAction, XWikiContext context, Map<String, Object> queryParameters) {
        return this.createResourceURL(filename, forceSkinAction, context);
    }

    @Override
    public URL createResourceURL(String filename, boolean forceSkinAction, XWikiContext context) {
        try {
            File targetFile = new File(this.getFilesystemExportContext().getExportDir(), "resources/" + filename);
            if (!targetFile.exists()) {
                if (!targetFile.getParentFile().exists()) {
                    targetFile.getParentFile().mkdirs();
                }
                if (forceSkinAction) {
                    int pos = filename.indexOf(47, 0);
                    String page = filename.substring(0, pos);
                    this.renderSkinFile("resource/" + filename, "resources", page, context.getWikiId(), targetFile, StringUtils.countMatches((CharSequence)filename, (CharSequence)"/") + 1, context);
                } else {
                    try (InputStream source = context.getEngineContext().getResourceAsStream("/resources/" + filename);){
                        FileUtils.copyInputStreamToFile((InputStream)source, (File)targetFile);
                    }
                }
            }
            StringBuilder newPath = new StringBuilder("file://");
            this.adjustCSSPath(newPath);
            newPath.append("resources");
            this.addFileName(newPath, filename, false, context);
            return new URL(newPath.toString());
        }
        catch (Exception e) {
            LOGGER.error("Failed to create skin URL", (Throwable)e);
            return super.createResourceURL(filename, forceSkinAction, context);
        }
    }

    @Override
    public URL createURL(String spaces, String name, String action, String querystring, String anchor, String xwikidb, XWikiContext context) {
        try {
            ExportURLFactoryActionHandler handler = Utils.getComponent(ExportURLFactoryActionHandler.class, action);
            return handler.createURL(spaces, name, querystring, anchor, xwikidb, context, this.getFilesystemExportContext());
        }
        catch (Exception handler) {
            try {
                String wikiname = xwikidb == null ? context.getWikiId().toLowerCase() : xwikidb.toLowerCase();
                String serializedReference = (String)this.fsPathEntityReferenceSerializer.serialize((EntityReference)new DocumentReference(wikiname, this.legacySpaceResolver.resolve(spaces), name), new Object[0]);
                if (this.getFilesystemExportContext().hasExportedPage(serializedReference) && "view".equals(action) && context.getLinksAction() == null) {
                    StringBuffer newpath = new StringBuffer();
                    newpath.append("file://");
                    newpath.append(StringUtils.repeat((String)"../", (int)this.getFilesystemExportContext().getDocParentLevel()));
                    newpath.append("pages/");
                    String relativeURLPath = new File("").toURI().relativize(new File(serializedReference).toURI()).toString();
                    newpath.append(relativeURLPath);
                    newpath.append(".html");
                    if (!StringUtils.isEmpty((CharSequence)anchor)) {
                        newpath.append("#");
                        newpath.append(anchor);
                    }
                    return new URL(newpath.toString());
                }
            }
            catch (Exception e) {
                LOGGER.error("Failed to create page URL", (Throwable)e);
            }
            return super.createURL(spaces, name, action, querystring, anchor, xwikidb, context);
        }
    }

    private URL createAttachmentURL(String filename, String spaces, String name, String xwikidb, XWikiContext context) throws XWikiException, IOException, URISyntaxException {
        XWikiDocument doc;
        XWikiAttachment attachment;
        String db = xwikidb == null ? context.getWikiId() : xwikidb;
        DocumentReference documentReference = new DocumentReference(db, this.legacySpaceResolver.resolve(spaces), name);
        String serializedReference = (String)this.fsPathEntityReferenceSerializer.serialize((EntityReference)new AttachmentReference(filename, documentReference), new Object[0]);
        String path = "attachment/" + serializedReference;
        File file = new File(this.getFilesystemExportContext().getExportDir(), path);
        if (!file.exists() && (attachment = (doc = context.getWiki().getDocument(documentReference, context)).getAttachment(filename)) != null) {
            file.getParentFile().mkdirs();
            try (InputStream stream = attachment.getContentInputStream(context);){
                FileUtils.copyInputStreamToFile((InputStream)stream, (File)file);
            }
        }
        StringBuilder newPath = new StringBuilder("file://");
        this.adjustCSSPath(newPath);
        String relativeURLPath = new File("").toURI().relativize(new File(path).toURI()).toString();
        newPath.append(relativeURLPath);
        return new URL(newPath.toString());
    }

    @Override
    public URL createAttachmentURL(String filename, String spaces, String name, String action, String querystring, String xwikidb, XWikiContext context) {
        try {
            return this.createAttachmentURL(filename, spaces, name, xwikidb, context);
        }
        catch (Exception e) {
            LOGGER.error("Failed to create attachment URL", (Throwable)e);
            return super.createAttachmentURL(filename, spaces, name, action, null, xwikidb, context);
        }
    }

    @Override
    public URL createAttachmentRevisionURL(String filename, String spaces, String name, String revision, String xwikidb, XWikiContext context) {
        try {
            return this.createAttachmentURL(filename, spaces, name, xwikidb, context);
        }
        catch (Exception e) {
            LOGGER.error("Failed to create attachment URL", (Throwable)e);
            return super.createAttachmentRevisionURL(filename, spaces, name, revision, xwikidb, context);
        }
    }

    @Override
    public String getURL(URL url, XWikiContext context) {
        if (url == null) {
            return "";
        }
        String path = url.toString();
        if (url.getProtocol().equals("file")) {
            path = path.substring("file://".length());
        }
        return path;
    }

    private void adjustCSSPath(StringBuilder path) {
        path.append(StringUtils.repeat((String)"../", (int)(this.getFilesystemExportContext().getCSSParentLevel() + this.getFilesystemExportContext().getDocParentLevel())));
    }
}

