/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.web;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.export.html.HtmlPackager;
import com.xpn.xwiki.internal.export.DocumentSelectionResolver;
import com.xpn.xwiki.internal.export.OfficeExporter;
import com.xpn.xwiki.internal.export.OfficeExporterURLFactory;
import com.xpn.xwiki.pdf.api.PdfExport;
import com.xpn.xwiki.pdf.impl.PdfExportImpl;
import com.xpn.xwiki.plugin.packaging.PackageAPI;
import com.xpn.xwiki.util.Util;
import com.xpn.xwiki.web.ExternalServletURLFactory;
import com.xpn.xwiki.web.Utils;
import com.xpn.xwiki.web.XWikiAction;
import com.xpn.xwiki.web.XWikiRequest;
import com.xpn.xwiki.web.XWikiResponse;
import com.xpn.xwiki.web.XWikiServletURLFactory;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.filter.FilterException;
import org.xwiki.filter.input.InputFilterStream;
import org.xwiki.filter.input.InputFilterStreamFactory;
import org.xwiki.filter.instance.input.DocumentInstanceInputProperties;
import org.xwiki.filter.output.BeanOutputFilterStream;
import org.xwiki.filter.output.BeanOutputFilterStreamFactory;
import org.xwiki.filter.output.DefaultOutputStreamOutputTarget;
import org.xwiki.filter.output.OutputFilterStreamFactory;
import org.xwiki.filter.output.OutputTarget;
import org.xwiki.filter.type.FilterStreamType;
import org.xwiki.filter.xar.output.XAROutputProperties;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.model.reference.EntityReferenceSet;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.security.authorization.ContextualAuthorizationManager;
import org.xwiki.security.authorization.Right;

@Component
@Named(value="export")
@Singleton
public class ExportAction
extends XWikiAction {
    @Override
    public String render(XWikiContext context) throws XWikiException {
        String defaultPage;
        try {
            XWikiRequest request = context.getRequest();
            String format = request.get("format");
            if (!this.validateExportRequest(request)) {
                return "docdoesnotexist";
            }
            defaultPage = format == null || format.equals("xar") ? this.exportXAR(context) : (format.equals("html") ? this.exportHTML(context) : this.export(format, context));
        }
        catch (Exception e) {
            throw new XWikiException(11, 11015, "Exception while exporting", e);
        }
        return defaultPage;
    }

    private boolean validateExportRequest(XWikiRequest request) {
        String secFetchDest = request.getHeader("Sec-Fetch-Dest");
        return secFetchDest == null || "document".equals(secFetchDest);
    }

    private String exportHTML(XWikiContext context) throws XWikiException, IOException {
        DocumentSelectionResolver documentSelectionResolver = this.getDocumentSelectionResover();
        Collection<Object> pageList = documentSelectionResolver.isSelectionSpecified() ? documentSelectionResolver.getSelectedDocuments() : List.of(context.getDoc().getDocumentReference());
        ContextualAuthorizationManager authorization = Utils.getComponent(ContextualAuthorizationManager.class);
        if ((pageList = (Collection<Object>)pageList.stream().filter(documentReference -> authorization.hasAccess(Right.VIEW, (EntityReference)documentReference)).collect(Collectors.toSet())).isEmpty()) {
            return null;
        }
        HtmlPackager packager = new HtmlPackager();
        String name = context.getRequest().getParameter("name");
        if (StringUtils.isBlank((CharSequence)name)) {
            name = context.getDoc().getFullName();
        }
        packager.setName(name);
        String description = context.getRequest().get("description");
        if (description != null) {
            packager.setDescription(description);
        }
        packager.addPageReferences((Collection<DocumentReference>)pageList);
        packager.export(context);
        return null;
    }

    private String export(String format, XWikiContext context) throws XWikiException, IOException {
        this.handleRevision(context);
        XWikiServletURLFactory urlFactory = new OfficeExporterURLFactory();
        PdfExportImpl exporter = new OfficeExporter();
        PdfExport.ExportType exportType = ((OfficeExporter)exporter).getExportType(format);
        if ("pdf".equalsIgnoreCase(format)) {
            urlFactory = new ExternalServletURLFactory();
            exporter = new PdfExportImpl();
            exportType = PdfExport.ExportType.PDF;
        } else if (exportType == null) {
            context.put("message", "core.export.formatUnknown");
            return "exception";
        }
        urlFactory.init(context);
        context.setURLFactory(urlFactory);
        XWikiDocument doc = context.getDoc();
        context.getResponse().setContentType(exportType.getMimeType());
        EntityReferenceSerializer serializer = (EntityReferenceSerializer)Utils.getComponent(EntityReferenceSerializer.TYPE_STRING, "path");
        String filename = ((String)serializer.serialize((EntityReference)doc.getDocumentReference(), new Object[0])).replaceAll("/", "_");
        filename = StringUtils.abbreviateMiddle((String)filename, (String)"__", (int)255);
        context.getResponse().addHeader("Content-disposition", String.format("inline; filename=%s.%s", filename, exportType.getExtension()));
        exporter.export(doc, (OutputStream)context.getResponse().getOutputStream(), exportType, context);
        return null;
    }

    private boolean getBooleanProperty(String requestProperty, String cfgProperty, boolean def, XWikiContext context) {
        String valueString = context.getRequest().get(requestProperty);
        boolean value = valueString == null ? (def ? context.getWiki().ParamAsLong(cfgProperty, 1L) != 0L : context.getWiki().ParamAsLong(cfgProperty, 0L) == 1L) : Boolean.parseBoolean(valueString);
        return value;
    }

    private String exportXAR(XWikiContext context) throws XWikiException, IOException, FilterException {
        boolean all;
        if (!context.getWiki().getRightService().hasWikiAdminRights(context)) {
            context.put("message", "needadminrights");
            return "exception";
        }
        XWikiRequest request = context.getRequest();
        String name = request.get("name");
        String description = request.get("description");
        boolean history = Boolean.valueOf(request.get("history"));
        boolean attachmentJRCS = this.getBooleanProperty("attachment_jrcs", "xwiki.action.export.xar.attachment.jrcs", true, context);
        boolean optimized = this.getBooleanProperty("optimized", "xwiki.action.export.xar.optimized", true, context);
        boolean backup = Boolean.valueOf(request.get("backup"));
        String author = request.get("author");
        String licence = request.get("licence");
        String version = request.get("version");
        DocumentSelectionResolver documentSelectionResolver = this.getDocumentSelectionResover();
        boolean bl = all = !documentSelectionResolver.isSelectionSpecified();
        if (StringUtils.isEmpty((CharSequence)name)) {
            String string = name = all ? "backup" : "export";
        }
        if (context.getWiki().ParamAsLong("xwiki.action.export.xar.usefilter", 1L) == 1L) {
            DocumentInstanceInputProperties inputProperties = new DocumentInstanceInputProperties();
            inputProperties.setVerbose(false);
            inputProperties.setWithJRCSRevisions(history);
            inputProperties.setWithRevisions(false);
            if (history) {
                inputProperties.setWithWikiAttachmentsRevisions(!attachmentJRCS);
                inputProperties.setWithWikiAttachmentJRCSRevisions(attachmentJRCS);
            }
            EntityReferenceSet entities = new EntityReferenceSet();
            if (all) {
                entities.includes((EntityReference)new WikiReference(context.getWikiId()));
            } else {
                documentSelectionResolver.getSelectedDocuments().forEach(arg_0 -> ((EntityReferenceSet)entities).includes(arg_0));
            }
            inputProperties.setEntities(entities);
            InputFilterStreamFactory inputFilterStreamFactory = Utils.getComponent(InputFilterStreamFactory.class, FilterStreamType.XWIKI_INSTANCE.serialize());
            try (InputFilterStream inputFilterStream = inputFilterStreamFactory.createInputFilterStream((Map)inputProperties);){
                XAROutputProperties xarProperties = new XAROutputProperties();
                xarProperties.setVerbose(false);
                if (optimized) {
                    xarProperties.setOptimized(optimized);
                }
                XWikiResponse response = context.getResponse();
                xarProperties.setTarget((OutputTarget)new DefaultOutputStreamOutputTarget((OutputStream)response.getOutputStream()));
                xarProperties.setPackageName(name);
                if (description != null) {
                    xarProperties.setPackageDescription(description);
                }
                if (licence != null) {
                    xarProperties.setPackageLicense(licence);
                }
                if (author != null) {
                    xarProperties.setPackageAuthor(author);
                }
                if (version != null) {
                    xarProperties.setPackageVersion(version);
                }
                xarProperties.setPackageBackupPack(backup);
                xarProperties.setPreserveVersion(backup || history);
                BeanOutputFilterStreamFactory xarFilterStreamFactory = (BeanOutputFilterStreamFactory)Utils.getComponent(OutputFilterStreamFactory.class, FilterStreamType.XWIKI_XAR_CURRENT.serialize());
                try (BeanOutputFilterStream outputFilterStream = xarFilterStreamFactory.createOutputFilterStream((Object)xarProperties);){
                    response.setContentType("application/zip");
                    response.addHeader("Content-disposition", "attachment; filename=" + Util.encodeURI(name, context) + ".xar");
                    inputFilterStream.read(outputFilterStream.getFilter());
                }
                response.getOutputStream().flush();
            }
            context.setFinished(true);
        } else {
            PackageAPI export = (PackageAPI)context.getWiki().getPluginApi("package", context);
            if (export == null) {
                return "exception";
            }
            export.setWithVersions(history);
            if (author != null) {
                export.setAuthorName(author);
            }
            if (description != null) {
                export.setDescription(description);
            }
            if (licence != null) {
                export.setLicence(licence);
            }
            if (version != null) {
                export.setVersion(version);
            }
            export.setBackupPack(backup);
            export.setName(name);
            if (all) {
                export.backupWiki();
            } else {
                for (DocumentReference documentReference : documentSelectionResolver.getSelectedDocuments()) {
                    int iAction;
                    String defaultAction = request.get("action_" + documentReference.getName());
                    try {
                        iAction = Integer.parseInt(defaultAction);
                    }
                    catch (Exception e) {
                        iAction = 0;
                    }
                    export.add(documentReference.getName(), iAction);
                }
                export.export();
            }
        }
        return null;
    }

    private DocumentSelectionResolver getDocumentSelectionResover() {
        return Utils.getComponent(DocumentSelectionResolver.class);
    }

    private static enum ExportFormat {
        XAR,
        HTML,
        OTHER;

    }
}

