/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.web;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.doc.XWikiLock;
import com.xpn.xwiki.web.EditForm;
import com.xpn.xwiki.web.XWikiAction;
import com.xpn.xwiki.web.XWikiForm;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.component.annotation.Component;
import org.xwiki.csrf.CSRFToken;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.user.UserReference;
import org.xwiki.user.UserReferenceResolver;

@Component
@Named(value="edit")
@Singleton
public class EditAction
extends XWikiAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(EditAction.class);
    @Inject
    @Named(value="document")
    private UserReferenceResolver<DocumentReference> documentReferenceUserReferenceResolver;
    @Inject
    private CSRFToken csrf;

    public EditAction() {
        this.waitForXWikiInitialization = false;
    }

    @Override
    protected Class<? extends XWikiForm> getFormClass() {
        return EditForm.class;
    }

    @Override
    public String render(XWikiContext context) throws XWikiException {
        try {
            XWikiDocument editedDocument = this.prepareEditedDocument(context);
            this.maybeLockDocument(editedDocument, context);
        }
        catch (XWikiException e) {
            if (e.getCode() == 11002) {
                context.put("exception", e);
                return "docalreadyexists";
            }
            throw e;
        }
        context.put("display", "edit");
        return "edit";
    }

    protected XWikiDocument prepareEditedDocument(XWikiContext context) throws XWikiException {
        UserReference userReference;
        String token;
        EditForm editForm = (EditForm)context.getForm();
        XWikiDocument editedDocument = this.getEditedDocument(editForm, context);
        boolean metadataDirty = editedDocument.isMetaDataDirty();
        boolean contentDirty = editedDocument.isContentDirty();
        editedDocument.setMetaDataDirty(false);
        editedDocument.setContentDirty(false);
        editedDocument.readDocMetaFromForm(editForm, context);
        this.readFromTemplate(editedDocument, editForm.getTemplate(), context);
        this.updateDocumentTitleAndContentFromRequest(editedDocument, editForm, context);
        editedDocument.readAddedUpdatedAndRemovedObjectsFromForm(editForm, context);
        if ((editedDocument.isMetaDataDirty() || editedDocument.isContentDirty()) && !this.csrf.isTokenValid(token = context.getRequest().getParameter("form_token"))) {
            editedDocument.setRestricted(true);
        }
        editedDocument.setMetaDataDirty(editedDocument.isMetaDataDirty() || metadataDirty);
        editedDocument.setContentDirty(editedDocument.isContentDirty() || contentDirty);
        if (editedDocument.isMetaDataDirty()) {
            userReference = this.documentReferenceUserReferenceResolver.resolve((Object)context.getUserReference(), new Object[0]);
            editedDocument.setAuthor(userReference);
        }
        if (editedDocument.isContentDirty()) {
            userReference = this.documentReferenceUserReferenceResolver.resolve((Object)context.getUserReference(), new Object[0]);
            editedDocument.getAuthors().setContentAuthor(userReference);
        }
        if (editedDocument.isNew()) {
            editedDocument.setCreatorReference(context.getUserReference());
            editedDocument.setAuthorReference(context.getUserReference());
            editedDocument.setContentAuthorReference(context.getUserReference());
        }
        editedDocument.readTemporaryUploadedFiles(editForm);
        this.putDocumentOnContext(editedDocument, context);
        return editedDocument;
    }

    private XWikiDocument getEditedDocument(EditForm editForm, XWikiContext context) throws XWikiException {
        XWikiDocument tdoc;
        String languageToEdit;
        XWikiDocument doc = context.getDoc();
        boolean hasTranslation = doc != context.get("tdoc");
        doc = doc.clone();
        context.put("doc", doc);
        String language = context.getWiki().getLanguagePreference(context);
        if (doc.isNew() && doc.getDefaultLanguage().equals("")) {
            doc.setDefaultLanguage(language);
        }
        String string = languageToEdit = StringUtils.isEmpty((CharSequence)editForm.getLanguage()) ? language : editForm.getLanguage();
        if (languageToEdit == null || languageToEdit.equals("default")) {
            languageToEdit = "";
        }
        if (doc.isNew() || doc.getDefaultLanguage().equals(languageToEdit)) {
            languageToEdit = "";
        }
        if (!hasTranslation && StringUtils.isEmpty((CharSequence)editForm.getLanguage())) {
            languageToEdit = "";
        }
        if (languageToEdit.equals("")) {
            tdoc = doc;
            if (doc.isNew()) {
                doc.setDefaultLanguage(language);
                doc.setLanguage("");
            }
        } else if (!hasTranslation && context.getWiki().isMultiLingual(context)) {
            tdoc = new XWikiDocument(doc.getDocumentReference());
            tdoc.setLanguage(languageToEdit);
            tdoc.setDefaultLocale(doc.getDefaultLocale());
            tdoc.setTitle(doc.getTitle());
            tdoc.setContent(doc.getContent());
            tdoc.setSyntax(doc.getSyntax());
            tdoc.setAuthorReference(context.getUserReference());
            tdoc.setStore(doc.getStore());
        } else {
            tdoc = ((XWikiDocument)context.get("tdoc")).clone();
        }
        return tdoc;
    }

    private void updateDocumentTitleAndContentFromRequest(XWikiDocument document, EditForm editForm, XWikiContext context) throws XWikiException {
        String sectionTitle;
        boolean sectionEditingEnabled = context.getWiki().hasSectionEdit(context);
        int sectionNumber = sectionEditingEnabled ? NumberUtils.toInt((String)context.getRequest().getParameter("section")) : 0;
        this.getCurrentScriptContext().setAttribute("sectionNumber", sectionNumber, 100);
        if (editForm.getContent() != null) {
            document.setContent(editForm.getContent());
        } else if (sectionNumber > 0) {
            document.setContent(document.getContentOfSection(sectionNumber));
        }
        if (editForm.getTitle() != null) {
            document.setTitle(editForm.getTitle());
        } else if (sectionNumber > 0 && document.getSections().size() > 0 && StringUtils.isNotBlank((CharSequence)(sectionTitle = document.getDocumentSection(1).getSectionTitle()))) {
            String sectionPlainTitle = document.getRenderedContent(sectionTitle, document.getSyntax().toIdString(), Syntax.PLAIN_1_0.toIdString(), context);
            document.setTitle(this.localizePlainOrKey("core.editors.content.titleField.sectionEditingFormat", document.getRenderedTitle(Syntax.PLAIN_1_0, context), sectionNumber, sectionPlainTitle));
        }
    }

    private void putDocumentOnContext(XWikiDocument document, XWikiContext context) {
        context.put("tdoc", document);
        context.put("cdoc", context.get("tdoc"));
    }

    private void maybeLockDocument(XWikiDocument document, XWikiContext context) {
        try {
            XWikiLock lock = document.getLock(context);
            EditForm editForm = (EditForm)context.getForm();
            if (lock == null || lock.getUserName().equals(context.getUser()) || editForm.isLockForce()) {
                document.setLock(context.getUser(), context);
            }
        }
        catch (Exception e) {
            LOGGER.error("Exception while setting up lock", (Throwable)e);
        }
    }
}

