/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.web;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.DeletedAttachment;
import com.xpn.xwiki.doc.XWikiAttachment;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.web.Utils;
import com.xpn.xwiki.web.XWikiAction;
import com.xpn.xwiki.web.XWikiRequest;
import com.xpn.xwiki.web.XWikiResponse;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.script.ScriptContext;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.EntityType;
import org.xwiki.resource.ResourceReference;
import org.xwiki.resource.ResourceReferenceManager;
import org.xwiki.resource.entity.EntityResourceReference;

@Component
@Named(value="delattachment")
@Singleton
public class DeleteAttachmentAction
extends XWikiAction {
    @Override
    public boolean action(XWikiContext context) throws XWikiException {
        String filename;
        if (!this.csrfTokenCheck(context)) {
            return false;
        }
        XWikiRequest request = context.getRequest();
        XWikiResponse response = context.getResponse();
        XWikiDocument doc = context.getDoc();
        XWikiAttachment attachment = null;
        XWiki xwiki = context.getWiki();
        if (request.getParameter("trashId") != null) {
            long trashId = NumberUtils.toLong((String)request.getParameter("trashId"));
            DeletedAttachment da = xwiki.getAttachmentRecycleBinStore().getDeletedAttachment(trashId, context, true);
            if (da != null) {
                com.xpn.xwiki.api.DeletedAttachment daapi = new com.xpn.xwiki.api.DeletedAttachment(da, context);
                if (!daapi.canDelete()) {
                    throw new XWikiException(9, 9001, "You are not allowed to delete an attachment from the trash immediately after it has been deleted from the wiki");
                }
                if (!da.getDocName().equals(doc.getFullName())) {
                    throw new XWikiException(11, 11007, "The specified trash entry does not match the current document");
                }
                xwiki.getAttachmentRecycleBinStore().deleteFromRecycleBin(trashId, context, true);
            }
            this.sendRedirect(response, Utils.getRedirect("attach", context));
            return false;
        }
        if (context.getMode() == 1) {
            filename = request.getParameter("filename");
        } else {
            String requestUri = request.getRequestURI();
            filename = this.getFileName();
        }
        XWikiDocument newdoc = doc.clone();
        if (request.getParameter("id") != null) {
            int id = NumberUtils.toInt((String)request.getParameter("id"));
            if (newdoc.getAttachmentList().size() > id) {
                attachment = newdoc.getAttachmentList().get(id);
            }
        } else {
            attachment = newdoc.getAttachment(filename);
        }
        if (attachment == null) {
            response.setStatus(404);
            ScriptContext scriptContext = this.getCurrentScriptContext();
            if (scriptContext != null) {
                scriptContext.setAttribute("message", this.localizePlainOrKey("core.action.deleteAttachment.failed", filename), 100);
                scriptContext.setAttribute("details", this.localizePlainOrKey("platform.core.action.deleteAttachment.noAttachment", new Object[0]), 100);
            }
            return true;
        }
        newdoc.setAuthorReference(context.getUserReference());
        String comment = attachment.isImage(context) ? this.localizePlainOrReturnKey("core.comment.deleteImageComment", filename) : this.localizePlainOrReturnKey("core.comment.deleteAttachmentComment", filename);
        try {
            newdoc.removeAttachment(attachment);
            context.getWiki().checkSavingDocument(context.getUserReference(), doc, comment, context);
            xwiki.saveDocument(newdoc, comment, context);
        }
        catch (Exception ex) {
            response.setStatus(500);
            ScriptContext scriptContext = this.getCurrentScriptContext();
            if (scriptContext != null) {
                scriptContext.setAttribute("message", this.localizePlainOrKey("core.action.deleteAttachment.failed", filename), 100);
                scriptContext.setAttribute("details", ExceptionUtils.getRootCauseMessage((Throwable)ex), 100);
            }
            return true;
        }
        if (!((Boolean)context.get("ajax")).booleanValue()) {
            String redirect = Utils.getRedirect("attach", context);
            this.sendRedirect(response, redirect);
        }
        return false;
    }

    @Override
    public String render(XWikiContext context) {
        return "error";
    }

    private String getFileName() {
        ResourceReference resourceReference = Utils.getComponent(ResourceReferenceManager.class).getResourceReference();
        EntityResourceReference entityResource = (EntityResourceReference)resourceReference;
        return entityResource.getEntityReference().extractReference(EntityType.ATTACHMENT).getName();
    }
}

