/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.web;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.DeletedDocument;
import com.xpn.xwiki.doc.XWikiDeletedDocument;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.web.DeleteActionCompatibilityAspect;
import com.xpn.xwiki.web.Utils;
import com.xpn.xwiki.web.XWikiAction;
import com.xpn.xwiki.web.XWikiRequest;
import com.xpn.xwiki.web.XWikiResponse;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.job.Job;
import org.xwiki.job.JobException;
import org.xwiki.job.JobExecutor;
import org.xwiki.job.Request;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.SpaceReference;
import org.xwiki.refactoring.job.DeleteRequest;
import org.xwiki.refactoring.job.PermanentlyDeleteRequest;
import org.xwiki.refactoring.script.RefactoringScriptService;
import org.xwiki.script.service.ScriptService;
import org.xwiki.stability.Unstable;

@Component
@Named(value="delete")
@Singleton
public class DeleteAction
extends XWikiAction {
    protected static final String CONFIRM_PARAM = "confirm";
    protected static final String ACTION_NAME = "delete";
    protected static final String ASYNC_PARAM = "async";
    protected static final String RECYCLED_DOCUMENT_ID_PARAM = "id";
    protected static final String EMPTY_RECYCLE_BIN = "emptybin";
    @Inject
    @Named(value="current")
    private DocumentReferenceResolver<String> currentStringDocumentReferenceResolver;

    private boolean isAsync(XWikiRequest request) {
        return "true".equals(request.get(ASYNC_PARAM));
    }

    private boolean doesAffectChildren(XWikiRequest request, DocumentReference documentReference) {
        return StringUtils.isNotEmpty((CharSequence)request.getParameter("affectChildren")) && "WebHome".equals(documentReference.getName());
    }

    @Override
    public boolean action(XWikiContext context) throws XWikiException {
        String redirect;
        XWikiRequest request = context.getRequest();
        if (!"1".equals(request.getParameter(CONFIRM_PARAM))) {
            return true;
        }
        if (!this.csrfTokenCheck(context)) {
            return false;
        }
        boolean redirected = this.delete(context);
        if (!redirected && (redirect = Utils.getRedirect(request, null)) != null) {
            this.sendRedirect(context.getResponse(), redirect);
            redirected = true;
        }
        return !redirected;
    }

    @Override
    public String render(XWikiContext context) throws XWikiException {
        XWikiRequest request = context.getRequest();
        XWikiDocument doc = context.getDoc();
        String sindex = request.getParameter(RECYCLED_DOCUMENT_ID_PARAM);
        boolean recycleIdIsValid = false;
        if (sindex != null) {
            long index = Long.parseLong(sindex);
            if (context.getWiki().getRecycleBinStore().getDeletedDocument(index, context, true) != null) {
                recycleIdIsValid = true;
            }
        }
        if ("1".equals(request.getParameter(CONFIRM_PARAM))) {
            return "deleted";
        }
        if (doc.isNew() && !recycleIdIsValid) {
            return Utils.getPage(request, "docdoesnotexist");
        }
        return ACTION_NAME;
    }

    protected boolean delete(XWikiContext context) throws XWikiException {
        XWiki xwiki = context.getWiki();
        XWikiRequest request = context.getRequest();
        XWikiResponse response = context.getResponse();
        XWikiDocument doc = context.getDoc();
        String sindex = request.getParameter(RECYCLED_DOCUMENT_ID_PARAM);
        String emptyBin = request.getParameter(EMPTY_RECYCLE_BIN);
        if ("true".equals(emptyBin)) {
            return this.deleteAllFromRecycleBin(context);
        }
        if (sindex != null && xwiki.hasRecycleBin(context)) {
            this.deleteFromRecycleBin(Long.parseLong(sindex), context);
            return true;
        }
        if (doc.isNew()) {
            this.sendRedirect(response, Utils.getRedirect("view", context));
            return true;
        }
        boolean shouldSkipRecycleBin = Boolean.parseBoolean(request.getParameter("shouldSkipRecycleBin"));
        DocumentReference newBacklinkTarget = this.currentStringDocumentReferenceResolver.resolve((Object)request.getParameter("newBacklinkTarget"), new Object[0]);
        boolean updateLinks = Boolean.parseBoolean(request.getParameter("updateLinks"));
        boolean autoRedirect = Boolean.parseBoolean(request.getParameter("autoRedirect"));
        return this.deleteDocument(context, shouldSkipRecycleBin, newBacklinkTarget, updateLinks, autoRedirect);
    }

    private boolean deleteAllFromRecycleBin(XWikiContext context) throws XWikiException {
        RefactoringScriptService refactoring = (RefactoringScriptService)Utils.getComponent(ScriptService.class, "refactoring");
        PermanentlyDeleteRequest deleteRequest = refactoring.getRequestFactory().createPermanentlyDeleteRequest(Collections.emptyList());
        deleteRequest.setInteractive(this.isAsync(context.getRequest()));
        deleteRequest.setCheckAuthorRights(false);
        try {
            JobExecutor jobExecutor = Utils.getComponent(JobExecutor.class);
            Job job = jobExecutor.execute("refactoring/permanentlyDelete", (Request)deleteRequest);
            if (this.isAsync(context.getRequest())) {
                List jobId = job.getRequest().getId();
                this.sendRedirect(context.getResponse(), Utils.getRedirect("view", "xpage=delete&jobId=" + this.serializeJobId(jobId), context));
                return true;
            }
            try {
                job.join();
            }
            catch (InterruptedException e) {
                throw new XWikiException("Failed to delete all from the recycle bin", e);
            }
            return false;
        }
        catch (JobException e) {
            throw new XWikiException("Failed to schedule the delete all from recycle bin job", e);
        }
    }

    private void deleteFromRecycleBin(long index, XWikiContext context) throws XWikiException {
        XWiki xwiki = context.getWiki();
        XWikiResponse response = context.getResponse();
        XWikiDocument doc = context.getDoc();
        XWikiDeletedDocument dd = xwiki.getRecycleBinStore().getDeletedDocument(index, context, true);
        if (dd != null) {
            DeletedDocument ddapi = new DeletedDocument(dd, context);
            if (!ddapi.canDelete()) {
                throw new XWikiException(9, 9001, "You are not allowed to delete a document from the trash immediately after it has been deleted from the wiki");
            }
            if (!dd.getFullName().equals(doc.getFullName())) {
                throw new XWikiException(11, 11007, "The specified trash entry does not match the current document");
            }
            xwiki.getRecycleBinStore().deleteFromRecycleBin(index, context, true);
        }
        this.sendRedirect(response, Utils.getRedirect("view", context));
    }

    private boolean deleteDocument(XWikiContext context, boolean shouldSkipRecycleBin, DocumentReference newBacklinkTarget, boolean updateLinks, boolean autoRedirect) throws XWikiException {
        XWikiRequest request = context.getRequest();
        XWikiDocument doc = context.getDoc();
        context.getWiki().checkDeletingDocument(context.getUserReference(), doc, context);
        SpaceReference documentReference = this.doesAffectChildren(request, doc.getDocumentReference()) ? doc.getDocumentReference().getLastSpaceReference() : doc.getTranslatedDocument(context).getDocumentReferenceWithLocale();
        return this.deleteDocument((EntityReference)documentReference, context, shouldSkipRecycleBin, newBacklinkTarget, updateLinks, autoRedirect);
    }

    protected boolean deleteDocument(EntityReference entityReference, XWikiContext context, boolean shouldSkipRecycleBin, DocumentReference newBacklinkTarget, boolean updateLinks, boolean autoRedirect) throws XWikiException {
        Job deleteJob = this.startDeleteJob(entityReference, context, shouldSkipRecycleBin, newBacklinkTarget, updateLinks, autoRedirect);
        if (this.isAsync(context.getRequest())) {
            List jobId = deleteJob.getRequest().getId();
            this.sendRedirect(context.getResponse(), Utils.getRedirect("view", "xpage=delete&jobId=" + this.serializeJobId(jobId), context));
            return true;
        }
        try {
            deleteJob.join();
        }
        catch (InterruptedException e) {
            throw new XWikiException(String.format("Failed to delete [%s]", entityReference), e);
        }
        return false;
    }

    private String serializeJobId(List<String> jobId) {
        return StringUtils.join(jobId, (String)"/");
    }

    private Job startDeleteJob(EntityReference entityReference, XWikiContext context, boolean shouldSkipRecycleBin, DocumentReference newBacklinkTarget, boolean updateLinks, boolean autoRedirect) throws XWikiException {
        RefactoringScriptService refactoring = (RefactoringScriptService)Utils.getComponent(ScriptService.class, "refactoring");
        DeleteRequest deleteRequest = (DeleteRequest)refactoring.getRequestFactory().createDeleteRequest(Arrays.asList(entityReference));
        deleteRequest.setInteractive(this.isAsync(context.getRequest()));
        deleteRequest.setCheckAuthorRights(false);
        deleteRequest.setShouldSkipRecycleBin(shouldSkipRecycleBin);
        deleteRequest.setNewBacklinkTargets(Collections.singletonMap(context.getDoc().getDocumentReference(), newBacklinkTarget));
        deleteRequest.setUpdateLinks(updateLinks);
        deleteRequest.setAutoRedirect(autoRedirect);
        try {
            JobExecutor jobExecutor = Utils.getComponent(JobExecutor.class);
            return jobExecutor.execute("refactoring/delete", (Request)deleteRequest);
        }
        catch (JobException e) {
            throw new XWikiException(String.format("Failed to schedule the delete job for [%s]", entityReference), e);
        }
    }

    public /* synthetic */ boolean ajc$protectedDispatch$com_xpn_xwiki_web_DeleteAction$deleteDocument(EntityReference entityReference, XWikiContext xWikiContext, boolean bl, DocumentReference documentReference, boolean bl2, boolean bl3) throws XWikiException {
        return this.deleteDocument(entityReference, xWikiContext, bl, documentReference, bl2, bl3);
    }

    @Deprecated
    public boolean deleteDocument(EntityReference entityReference, XWikiContext xWikiContext, boolean bl) throws XWikiException {
        return DeleteActionCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_web_DeleteActionCompatibilityAspect$com_xpn_xwiki_web_DeleteAction$deleteDocument(this, entityReference, xWikiContext, bl);
    }

    @Deprecated
    @Unstable
    public boolean deleteToRecycleBin(EntityReference entityReference, XWikiContext xWikiContext) throws XWikiException {
        return DeleteActionCompatibilityAspect.ajc$interMethod$com_xpn_xwiki_web_DeleteActionCompatibilityAspect$com_xpn_xwiki_web_DeleteAction$deleteToRecycleBin(this, entityReference, xWikiContext);
    }
}

