/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.web;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.Document;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.internal.mandatory.RedirectClassDocumentInitializer;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.web.Utils;
import com.xpn.xwiki.web.XWikiRequest;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.script.ScriptContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.apache.velocity.VelocityContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceResolver;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.model.reference.SpaceReference;
import org.xwiki.model.reference.SpaceReferenceResolver;
import org.xwiki.query.Query;
import org.xwiki.query.QueryManager;
import org.xwiki.script.ScriptContextManager;
import org.xwiki.security.authorization.ContextualAuthorizationManager;
import org.xwiki.security.authorization.Right;
import org.xwiki.stability.Unstable;
import org.xwiki.velocity.VelocityManager;

public class CreateActionRequestHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(CreateActionRequestHandler.class);
    private static final String SPACE_REFERENCE = "spaceReference";
    private static final String NAME = "name";
    @Deprecated
    private static final String SPACE = "space";
    @Deprecated
    private static final String PAGE = "page";
    private static final String TOCREATE_SPACE = "space";
    private static final String TYPE = "type";
    private static final String TOCREATE_TERMINAL = "terminal";
    private static final String TOCREATE_NONTERMINAL = "nonterminal";
    private static final String TEMPLATE = "template";
    private static final String TEMPLATE_PROVIDER = "templateprovider";
    private static final EntityReference TEMPLATE_PROVIDER_CLASS = new EntityReference("TemplateProviderClass", EntityType.DOCUMENT, new EntityReference("XWiki", EntityType.SPACE));
    @Deprecated
    private static final String SPACES_PROPERTY = "spaces";
    private static final String EXCEPTION = "createException";
    private static final String CURRENT_RESOLVER_HINT = "current";
    private static final String CURRENT_MIXED_RESOLVER_HINT = "currentmixed";
    private static final String TP_TERMINAL_PROPERTY = "terminal";
    private static final String TP_TYPE_PROPERTY = "type";
    private static final String TP_TYPE_PROPERTY_SPACE_VALUE = "space";
    private static final String TP_CREATION_RESTRICTIONS_PROPERTY = "creationRestrictions";
    private static final String TP_VISIBILITY_RESTRICTIONS_PROPERTY = "visibilityRestrictions";
    private static final String TP_CREATION_RESTRICTIONS_ARE_SUGGESTIONS_PROPERTY = "creationRestrictionsAreSuggestions";
    private static final String WEBHOME = "WebHome";
    private ScriptContextManager scriptContextManager;
    private SpaceReference spaceReference;
    private String name;
    private boolean isSpace;
    private XWikiContext context;
    private XWikiDocument document;
    private XWikiRequest request;
    private BaseObject templateProvider;
    private List<Document> availableTemplateProviders;
    private List<Document> recommendedTemplateProviders;
    private String type;
    private EntityReferenceSerializer<String> localEntityReferenceSerializer;

    public CreateActionRequestHandler(XWikiContext context) {
        this.context = context;
        this.document = context.getDoc();
        this.request = context.getRequest();
    }

    public void processRequest() throws XWikiException {
        DocumentReferenceResolver referenceResolver = (DocumentReferenceResolver)Utils.getComponent(DocumentReferenceResolver.TYPE_REFERENCE, CURRENT_RESOLVER_HINT);
        DocumentReference templateProviderClassReference = referenceResolver.resolve((Object)TEMPLATE_PROVIDER_CLASS, new Object[0]);
        this.templateProvider = this.getTemplateProvider(templateProviderClassReference);
        this.availableTemplateProviders = this.loadAvailableTemplateProviders(this.document.getDocumentReference().getLastSpaceReference(), templateProviderClassReference, this.context);
        this.type = this.request.get("type");
        String toCreate = this.request.getParameter("tocreate");
        if (this.document.isNew()) {
            this.processNewDocument(toCreate);
        } else if (this.request.getParameter("space") != null || this.request.getParameter(PAGE) != null) {
            this.processDeprecatedParameters(toCreate);
        } else {
            boolean providerTerminal;
            String spaceReferenceParameter = this.request.getParameter(SPACE_REFERENCE);
            if (StringUtils.isNotEmpty((CharSequence)spaceReferenceParameter)) {
                EntityReferenceResolver genericResolver = (EntityReferenceResolver)Utils.getComponent(EntityReferenceResolver.TYPE_STRING, CURRENT_RESOLVER_HINT);
                EntityReference resolvedEntityReference = genericResolver.resolve((Object)spaceReferenceParameter, EntityType.SPACE, new Object[0]);
                this.spaceReference = new SpaceReference(resolvedEntityReference);
            }
            this.name = this.request.getParameter(NAME);
            this.isSpace = "terminal".equals(toCreate) || TOCREATE_NONTERMINAL.equals(toCreate) ? !"terminal".equals(toCreate) : (this.templateProvider != null ? !(providerTerminal = this.getTemplateProviderTerminalValue()) : true);
        }
    }

    private void processNewDocument(String toCreate) {
        boolean providerTerminal;
        this.spaceReference = this.document.getDocumentReference().getLastSpaceReference();
        this.name = this.document.getDocumentReference().getName();
        EntityReference parentSpaceReference = this.spaceReference.getParent();
        boolean isTopLevelSpace = parentSpaceReference.extractReference(EntityType.SPACE) == null;
        String originalName = this.name;
        if (WEBHOME.equals(this.name)) {
            this.name = this.spaceReference.getName();
            this.spaceReference = !isTopLevelSpace ? new SpaceReference(parentSpaceReference) : null;
        }
        this.isSpace = "terminal".equals(toCreate) || TOCREATE_NONTERMINAL.equals(toCreate) ? !"terminal".equals(toCreate) : (this.templateProvider != null ? !(providerTerminal = this.getTemplateProviderTerminalValue()) : WEBHOME.equals(originalName));
    }

    private boolean getTemplateProviderTerminalValue() {
        String providerType;
        int providerTerminalValue = this.templateProvider.getIntValue("terminal", -1);
        boolean providerTerminal = providerTerminalValue == -1 ? !"space".equals(providerType = this.templateProvider.getStringValue("type")) : 1 == providerTerminalValue;
        return providerTerminal;
    }

    private void processDeprecatedParameters(String toCreate) {
        String spaceParameter = this.request.getParameter("space");
        this.isSpace = "space".equals(toCreate);
        if (this.isSpace) {
            this.spaceReference = null;
            this.name = spaceParameter;
        } else {
            if (StringUtils.isNotEmpty((CharSequence)spaceParameter)) {
                this.spaceReference = new SpaceReference(spaceParameter, this.document.getDocumentReference().getWikiReference());
            }
            this.name = this.request.getParameter(PAGE);
        }
    }

    private BaseObject getTemplateProvider(DocumentReference templateProviderClass) throws XWikiException {
        BaseObject result = null;
        String templateProviderDocReferenceString = this.request.getParameter(TEMPLATE_PROVIDER);
        if (!StringUtils.isEmpty((CharSequence)templateProviderDocReferenceString)) {
            DocumentReference templateProviderRef = this.getCurrentMixedResolver().resolve((Object)templateProviderDocReferenceString, new Object[0]);
            XWikiDocument templateProviderDoc = this.context.getWiki().getDocument(templateProviderRef, this.context);
            result = templateProviderDoc.getXObject(templateProviderClass);
        }
        return result;
    }

    private List<Document> loadAvailableTemplateProviders(SpaceReference spaceReference, DocumentReference templateClassReference, XWikiContext context) {
        ArrayList<Document> templates = new ArrayList<Document>();
        try {
            QueryManager queryManager = (QueryManager)Utils.getComponent(QueryManager.class, "secure");
            Query query = queryManager.createQuery("from doc.object(XWiki.TemplateProviderClass) as template where doc.fullName not like 'XWiki.TemplateProviderTemplate' order by template.name", "xwql");
            ArrayList<XWikiDocument> recommendedTemplates = new ArrayList<XWikiDocument>();
            List templateProviderDocNames = query.execute();
            for (String templateProviderName : templateProviderDocNames) {
                XWikiDocument templateDoc;
                BaseObject templateObject;
                DocumentReference reference = this.getCurrentMixedResolver().resolve((Object)templateProviderName, new Object[0]);
                if (!this.getAuthManager().hasAccess(Right.VIEW, (EntityReference)reference) || !this.isTemplateProviderAllowedInSpace(templateObject = (templateDoc = context.getWiki().getDocument(reference, context)).getXObject(templateClassReference), spaceReference, TP_VISIBILITY_RESTRICTIONS_PROPERTY)) continue;
                List<String> creationRestrictions = this.getTemplateProviderRestrictions(templateObject, TP_CREATION_RESTRICTIONS_PROPERTY);
                if (creationRestrictions.size() > 0 && this.isTemplateProviderAllowedInSpace(templateObject, spaceReference, TP_CREATION_RESTRICTIONS_PROPERTY)) {
                    recommendedTemplates.add(templateDoc);
                    continue;
                }
                templates.add(new Document(templateDoc, context));
            }
            EntityReferenceSerializer<String> localSerializer = this.getLocalEntityReferenceSerializer();
            String spaceStringReference = (String)localSerializer.serialize((EntityReference)spaceReference, new Object[0]);
            recommendedTemplates.sort(Comparator.comparing(templateProviderDocument -> {
                BaseObject templateProviderObject = templateProviderDocument.getXObject(templateClassReference);
                List<String> restrictions = this.getTemplateProviderRestrictions(templateProviderObject, TP_CREATION_RESTRICTIONS_PROPERTY);
                return restrictions.stream().filter(restriction -> this.matchesRestriction(spaceStringReference, (String)restriction)).mapToInt(restriction -> {
                    SpaceReferenceResolver spaceResolver = (SpaceReferenceResolver)Utils.getComponent(SpaceReferenceResolver.TYPE_STRING);
                    SpaceReference restrictionSpaceReference = spaceResolver.resolve(restriction, new Object[0]);
                    int specificity = restrictionSpaceReference.getReversedReferenceChain().size();
                    return specificity;
                }).max().orElse(0);
            }).reversed());
            this.recommendedTemplateProviders = recommendedTemplates.stream().map(recommendedTemplate -> new Document((XWikiDocument)recommendedTemplate, context)).collect(Collectors.toList());
            templates.addAll(0, this.recommendedTemplateProviders);
        }
        catch (Exception e) {
            LOGGER.warn("There was an error getting the available templates for space {0}", (Object)spaceReference, (Object)e);
        }
        return templates;
    }

    private DocumentReferenceResolver<String> getCurrentMixedResolver() {
        return (DocumentReferenceResolver)Utils.getComponent(DocumentReferenceResolver.TYPE_STRING, CURRENT_MIXED_RESOLVER_HINT);
    }

    private boolean isTemplateProviderAllowedInSpace(BaseObject templateObject, SpaceReference spaceReference, String restrictionsProperty) {
        List<String> restrictions = this.getTemplateProviderRestrictions(templateObject, restrictionsProperty);
        if (restrictions.size() > 0) {
            EntityReferenceSerializer<String> localSerializer = this.getLocalEntityReferenceSerializer();
            String spaceStringReference = (String)localSerializer.serialize((EntityReference)spaceReference, new Object[0]);
            for (String allowedSpace : restrictions) {
                if (!this.matchesRestriction(spaceStringReference, allowedSpace)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private boolean matchesRestriction(String spaceStringReferenceToTest, String allowedSpaceRestriction) {
        return allowedSpaceRestriction.equals(spaceStringReferenceToTest) || Strings.CS.startsWith((CharSequence)spaceStringReferenceToTest, (CharSequence)String.format("%s.", allowedSpaceRestriction));
    }

    private List<String> getTemplateProviderRestrictions(BaseObject templateObject, String restrictionsProperty) {
        List creationRestrictions = templateObject.getListValue(restrictionsProperty);
        if (creationRestrictions.size() == 0) {
            creationRestrictions = templateObject.getListValue(SPACES_PROPERTY);
        }
        return creationRestrictions;
    }

    @Unstable
    public DocumentReference getDocumentReference() {
        if (StringUtils.isEmpty((CharSequence)this.name)) {
            return null;
        }
        SpaceReference newSpaceReference = this.spaceReference;
        String newName = this.name;
        if (this.isSpace) {
            SpaceReference parentSpaceReference = this.spaceReference;
            if (parentSpaceReference == null) {
                parentSpaceReference = this.context.getDoc().getDocumentReference().getWikiReference();
            }
            newSpaceReference = new SpaceReference(this.name, (EntityReference)parentSpaceReference);
            newName = WEBHOME;
        }
        if (newSpaceReference == null) {
            return null;
        }
        return new DocumentReference(newName, newSpaceReference);
    }

    @Deprecated(since="15.10.12,16.4.1,16.6.0RC1")
    public DocumentReference getNewDocumentReference() {
        return this.isTemplateInfoProvided() ? this.getDocumentReference() : null;
    }

    @Unstable
    public boolean isTemplateInfoProvided() {
        return this.hasTemplate() || this.availableTemplateProviders.isEmpty();
    }

    public boolean hasTemplate() {
        return this.request.getParameter(TEMPLATE_PROVIDER) != null || this.request.getParameter(TEMPLATE) != null;
    }

    public boolean isTemplateProviderAllowedToCreateInCurrentSpace() {
        if (this.templateProvider != null) {
            boolean creationRestrictionsEnforced;
            boolean bl = creationRestrictionsEnforced = this.templateProvider.getIntValue(TP_CREATION_RESTRICTIONS_ARE_SUGGESTIONS_PROPERTY, 0) == 0;
            if (creationRestrictionsEnforced && !this.isTemplateProviderAllowedInSpace(this.templateProvider, this.spaceReference, TP_CREATION_RESTRICTIONS_PROPERTY)) {
                Object[] args = new Object[]{this.templateProvider.getStringValue(TEMPLATE), this.spaceReference, this.name};
                XWikiException exception = new XWikiException(3, 11016, "Template {0} cannot be used in space {1} when creating page {2}", null, args);
                ScriptContext scontext = this.getCurrentScriptContext();
                scontext.setAttribute(EXCEPTION, exception, 100);
                scontext.setAttribute("createAllowedSpaces", this.getTemplateProviderRestrictions(this.templateProvider, TP_CREATION_RESTRICTIONS_PROPERTY), 100);
                return false;
            }
        }
        return true;
    }

    public boolean isDocumentAlreadyExisting(XWikiDocument newDocument) {
        if (!this.isEmptyDocument(newDocument)) {
            ScriptContext scontext = this.getCurrentScriptContext();
            scontext.setAttribute("existingDocumentReference", newDocument.getDocumentReference(), 100);
            Object[] args = new Object[]{newDocument.getDocumentReference()};
            XWikiException documentAlreadyExists = new XWikiException(3, 11002, "Cannot create document {0} because it already has content", null, args);
            scontext.setAttribute(EXCEPTION, documentAlreadyExists, 100);
            return true;
        }
        return false;
    }

    public boolean isDocumentPathTooLong(DocumentReference reference) {
        boolean isTooLong;
        int maxLength = this.document.getLocalReferenceMaxLength();
        String serializedDocumentName = (String)this.getLocalEntityReferenceSerializer().serialize((EntityReference)reference, new Object[0]);
        boolean bl = isTooLong = serializedDocumentName.length() > maxLength;
        if (isTooLong) {
            Object[] args = new Object[]{serializedDocumentName, maxLength, serializedDocumentName.length()};
            XWikiException documentPathIsTooLong = new XWikiException(3, 11017, "Cannot create document {0} because its full path is too long: only {1} characters are allowed and current length is {2}.", null, args);
            ScriptContext scontext = this.getCurrentScriptContext();
            scontext.setAttribute(EXCEPTION, documentPathIsTooLong, 100);
            scontext.setAttribute("tooLongPath", serializedDocumentName, 100);
        }
        return isTooLong;
    }

    private EntityReferenceSerializer<String> getLocalEntityReferenceSerializer() {
        if (this.localEntityReferenceSerializer == null) {
            this.localEntityReferenceSerializer = (EntityReferenceSerializer)Utils.getComponent(EntityReferenceSerializer.TYPE_STRING, "local");
        }
        return this.localEntityReferenceSerializer;
    }

    private boolean isEmptyDocument(XWikiDocument document) {
        if (document.isNew() || document.getXObject((EntityReference)RedirectClassDocumentInitializer.REFERENCE) != null) {
            return true;
        }
        String content = document.getContent();
        if (!(content.equals("\n") || content.equals("") || content.equals("\\\\"))) {
            return false;
        }
        for (Map.Entry<DocumentReference, List<BaseObject>> objList : document.getXObjects().entrySet()) {
            for (BaseObject obj : objList.getValue()) {
                if (obj == null) continue;
                return false;
            }
        }
        return true;
    }

    @Deprecated
    public VelocityContext getVelocityContext() {
        return Utils.getComponent(VelocityManager.class).getVelocityContext();
    }

    protected ContextualAuthorizationManager getAuthManager() {
        return Utils.getComponent(ContextualAuthorizationManager.class);
    }

    protected ScriptContext getCurrentScriptContext() {
        if (this.scriptContextManager == null) {
            this.scriptContextManager = Utils.getComponent(ScriptContextManager.class);
        }
        return this.scriptContextManager.getCurrentScriptContext();
    }

    public SpaceReference getSpaceReference() {
        return this.spaceReference;
    }

    public String getName() {
        return this.name;
    }

    public boolean isSpace() {
        return this.isSpace;
    }

    public List<Document> getAvailableTemplateProviders() {
        return this.availableTemplateProviders;
    }

    public List<Document> getRecommendedTemplateProviders() {
        return this.recommendedTemplateProviders;
    }

    public BaseObject getTemplateProvider() {
        return this.templateProvider;
    }

    public String getType() {
        return this.type;
    }
}

