/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.web;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.web.CommentAddAction;
import com.xpn.xwiki.web.EditForm;
import com.xpn.xwiki.web.Utils;
import com.xpn.xwiki.web.XWikiForm;
import com.xpn.xwiki.web.XWikiRequest;
import com.xpn.xwiki.web.XWikiResponse;
import java.util.Enumeration;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.localization.ContextualLocalizationManager;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.security.authorization.AuthorizationManager;
import org.xwiki.security.authorization.Right;

@Component
@Named(value="commentsave")
@Singleton
public class CommentSaveAction
extends CommentAddAction {
    private static final String COMMENT_FIELD_NAME = "comment";
    private DocumentReferenceResolver<String> documentReferenceResolver = (DocumentReferenceResolver)Utils.getComponent(DocumentReferenceResolver.TYPE_STRING, "current");
    private AuthorizationManager authorizationManager = Utils.getComponent(AuthorizationManager.class);
    private ContextualLocalizationManager localizationManager = Utils.getComponent(ContextualLocalizationManager.class);
    private final Pattern pattern = Pattern.compile("XWiki.XWikiComments_(\\d+)_comment");

    @Override
    protected Class<? extends XWikiForm> getFormClass() {
        return EditForm.class;
    }

    private int getCommentIdFromRequest(XWikiRequest request) throws XWikiException {
        Enumeration parameterNames = request.getParameterNames();
        while (parameterNames.hasMoreElements()) {
            String parameterName = (String)parameterNames.nextElement();
            Matcher m = this.pattern.matcher(parameterName);
            if (!m.find()) continue;
            String number = m.group(1);
            return Integer.parseInt(number);
        }
        throw new XWikiException("Failed to find the comment to save.", null);
    }

    @Override
    public boolean action(XWikiContext context) throws XWikiException {
        int commentId;
        XWiki xwiki = context.getWiki();
        XWikiResponse response = context.getResponse();
        XWikiRequest request = context.getRequest();
        XWikiDocument doc = context.getDoc();
        if (!this.csrfTokenCheck(context) || doc.isNew()) {
            return false;
        }
        DocumentReference commentClass = new DocumentReference(context.getWikiId(), "XWiki", XWikiDocument.COMMENTSCLASS_REFERENCE.getName());
        BaseObject commentObj = doc.getXObject(commentClass, commentId = this.getCommentIdFromRequest(request));
        if (commentObj == null) {
            return false;
        }
        String commentAuthor = commentObj.getStringValue("author");
        DocumentReference authorReference = this.documentReferenceResolver.resolve((Object)commentAuthor, new Object[0]);
        if (!authorReference.equals((Object)context.getUserReference()) && !this.authorizationManager.hasAccess(Right.ADMIN, context.getUserReference(), (EntityReference)context.getDoc().getDocumentReference())) {
            return false;
        }
        commentObj.set(COMMENT_FIELD_NAME, request.getParameter(String.format("XWiki.XWikiComments_%d_comment", commentId)), context);
        String comment = this.localizationManager.getTranslationPlain("core.comment.editComment", new Object[0]);
        this.handleTemporaryUploadedFiles(doc, context.getRequest());
        context.getWiki().checkSavingDocument(context.getUserReference(), doc, comment, true, context);
        xwiki.saveDocument(doc, comment, true, context);
        if (context.getRequest().get("xpage") != null) {
            return true;
        }
        String redirect = Utils.getRedirect("edit", context);
        this.sendRedirect(response, redirect);
        return false;
    }
}

