/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.web;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.BaseProperty;
import com.xpn.xwiki.objects.StringProperty;
import com.xpn.xwiki.objects.classes.BaseClass;
import com.xpn.xwiki.web.ObjectAddForm;
import com.xpn.xwiki.web.Utils;
import com.xpn.xwiki.web.XWikiAction;
import com.xpn.xwiki.web.XWikiForm;
import com.xpn.xwiki.web.XWikiRequest;
import com.xpn.xwiki.web.XWikiResponse;
import java.util.Arrays;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.captcha.Captcha;
import org.xwiki.captcha.CaptchaConfiguration;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.security.authorization.ContextualAuthorizationManager;
import org.xwiki.security.authorization.Right;
import org.xwiki.store.TemporaryAttachmentSessionsManager;
import org.xwiki.user.CurrentUserReference;
import org.xwiki.user.UserReferenceResolver;

@Component
@Named(value="commentadd")
@Singleton
public class CommentAddAction
extends XWikiAction {
    private static final String AUTHOR_PROPERTY_NAME = "author";
    private static final String USER_SPACE_PREFIX = "XWiki.";
    private static final Logger LOGGER = LoggerFactory.getLogger(CommentAddAction.class);
    @Inject
    private UserReferenceResolver<CurrentUserReference> currentUserReferenceUserReferenceResolver;
    @Inject
    private TemporaryAttachmentSessionsManager temporaryAttachmentSessionsManager;
    @Inject
    private ContextualAuthorizationManager authorization;

    @Override
    protected Class<? extends XWikiForm> getFormClass() {
        return ObjectAddForm.class;
    }

    @Override
    public boolean action(XWikiContext context) throws XWikiException {
        if (!this.csrfTokenCheck(context)) {
            return false;
        }
        XWiki xwiki = context.getWiki();
        XWikiResponse response = context.getResponse();
        XWikiDocument doc = context.getDoc();
        ObjectAddForm oform = (ObjectAddForm)context.getForm();
        BaseClass baseclass = xwiki.getCommentsClass(context);
        if (doc.isNew()) {
            return true;
        }
        if (context.getUser().equals("XWiki.XWikiGuest") && !this.checkCaptcha(context)) {
            this.getCurrentScriptContext().setAttribute("captchaAnswerWrong", Boolean.TRUE, 100);
        } else {
            String className = baseclass.getName();
            BaseObject object = doc.newObject(className, context);
            baseclass.fromMap(oform.getObject(className), object);
            if ("XWiki.XWikiGuest".equals(context.getUser())) {
                Object author = String.valueOf(((BaseProperty)object.get(AUTHOR_PROPERTY_NAME)).getValue());
                author = StringUtils.remove((String)author, (char)':');
                while (((String)author).startsWith(USER_SPACE_PREFIX)) {
                    author = Strings.CS.removeStart((String)author, (CharSequence)USER_SPACE_PREFIX);
                }
                int limit = xwiki.getStore().getLimitSize(context, StringProperty.class, "value");
                author = ((String)author).substring(0, Math.min(((String)author).length(), limit));
                object.set(AUTHOR_PROPERTY_NAME, author, context);
            } else {
                object.set(AUTHOR_PROPERTY_NAME, context.getUser(), context);
            }
            doc.getAuthors().setOriginalMetadataAuthor(this.currentUserReferenceUserReferenceResolver.resolve((Object)CurrentUserReference.INSTANCE, new Object[0]));
            String comment = this.localizePlainOrKey("core.comment.addComment", new Object[0]);
            this.handleTemporaryUploadedFiles(doc, context.getRequest());
            context.getWiki().checkSavingDocument(context.getUserReference(), doc, comment, true, context);
            xwiki.saveDocument(doc, comment, true, context);
        }
        if (context.getRequest().get("xpage") != null) {
            return true;
        }
        String redirect = Utils.getRedirect("edit", context);
        this.sendRedirect(response, redirect);
        return false;
    }

    @Override
    public String render(XWikiContext context) throws XWikiException {
        if (context.getDoc().isNew()) {
            context.put("message", "nocommentwithnewdoc");
            return "exception";
        }
        return "";
    }

    private boolean checkCaptcha(XWikiContext context) throws XWikiException {
        if (context.getWiki().getSpacePreferenceAsInt("guest_comment_requires_captcha", 0, context) == 1) {
            CaptchaConfiguration captchaConfiguration = Utils.getComponent(CaptchaConfiguration.class);
            String defaultCaptchaName = captchaConfiguration.getDefaultName();
            try {
                Captcha captcha = Utils.getComponent(Captcha.class, defaultCaptchaName);
                return captcha.isValid();
            }
            catch (Exception e) {
                LOGGER.error("Failed to verify CAPTCHA of type [{}]. Assuming wrong answer.", (Object)defaultCaptchaName, (Object)e);
                return false;
            }
        }
        return true;
    }

    @Deprecated(since="17.0.0RC1")
    protected void handleTemporaryUploadedFiles(XWikiDocument document, XWikiRequest request) throws XWikiException {
        String[] uploadedFiles = request.getParameterValues("uploadedFiles");
        if (uploadedFiles != null && this.authorization.hasAccess(Right.EDIT, (EntityReference)document.getDocumentReference())) {
            this.temporaryAttachmentSessionsManager.attachTemporaryAttachmentsInDocument(document, Arrays.asList(uploadedFiles));
        }
    }
}

