/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.web;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.web.Utils;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Objects;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.configuration.ConfigurationSource;

public class ActionFilter
implements Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActionFilter.class);
    private static final String ACTION_PREFIX = "action_";
    private static final String PATH_SEPARATOR = "/";
    private static final String ATTRIBUTE_ACTION_DISPATCHED = ActionFilter.class.getName() + ".actionDispatched";

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest) {
            HttpServletRequest hrequest = (HttpServletRequest)request;
            if (!Boolean.parseBoolean((String)request.getAttribute(ATTRIBUTE_ACTION_DISPATCHED))) {
                Enumeration parameterNames = hrequest.getParameterNames();
                while (parameterNames.hasMoreElements()) {
                    String targetURL;
                    RequestDispatcher dispatcher;
                    String parameter = (String)parameterNames.nextElement();
                    String[] xactions = request.getParameterValues("xaction");
                    if (!parameter.startsWith(ACTION_PREFIX) || xactions != null && !Stream.of(xactions).anyMatch(it -> Objects.equals(parameter, String.format("action_%s", it))) || (dispatcher = hrequest.getRequestDispatcher(targetURL = this.getTargetURL(hrequest, parameter))) == null) continue;
                    LOGGER.debug("Forwarding request to [{}]", (Object)targetURL);
                    request.setAttribute(ATTRIBUTE_ACTION_DISPATCHED, (Object)"true");
                    dispatcher.forward((ServletRequest)hrequest, response);
                    request.removeAttribute(ATTRIBUTE_ACTION_DISPATCHED);
                    return;
                }
            }
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }

    private String getTargetURL(HttpServletRequest request, String action) {
        String newAction = PATH_SEPARATOR + action.substring(ACTION_PREFIX.length());
        String path = request.getRequestURI();
        path = XWiki.stripSegmentFromPath(path, request.getContextPath());
        Object servletPath = request.getServletPath();
        path = XWiki.stripSegmentFromPath(path, (String)servletPath);
        int index = path.indexOf(PATH_SEPARATOR, 1);
        ConfigurationSource configuration = Utils.getComponent(ConfigurationSource.class, "xwikicfg");
        if ("1".equals(configuration.getProperty("xwiki.virtual.usepath", (Object)"1")) && ((String)servletPath).equals(PATH_SEPARATOR + (String)configuration.getProperty("xwiki.virtual.usepath.servletpath", (Object)"wiki"))) {
            servletPath = (String)servletPath + path.substring(0, index);
            index = path.indexOf(PATH_SEPARATOR, index + 1);
        }
        String document = path.substring(index);
        return (String)servletPath + newAction + document;
    }
}

