/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.util;

import com.xpn.xwiki.web.Utils;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.context.Execution;
import org.xwiki.context.ExecutionContext;
import org.xwiki.context.ExecutionContextException;
import org.xwiki.context.ExecutionContextManager;

public abstract class AbstractXWikiRunnable
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractXWikiRunnable.class);
    private final Map<String, Object> properties = new HashMap<String, Object>();
    private Execution execution;

    protected AbstractXWikiRunnable() {
    }

    protected AbstractXWikiRunnable(String propertyName, Object propertyValue) {
        this.properties.put(propertyName, propertyValue);
    }

    protected AbstractXWikiRunnable(Map<String, Object> properties) {
        this.properties.putAll(properties);
    }

    protected void declareProperties(ExecutionContext executionContext) {
    }

    protected ExecutionContext initExecutionContext() throws ExecutionContextException {
        this.execution = Utils.getComponent(Execution.class);
        ExecutionContextManager ecim = Utils.getComponent(ExecutionContextManager.class);
        ExecutionContext context = new ExecutionContext();
        this.declareProperties(context);
        ecim.initialize(context);
        context.setProperties(this.properties);
        return context;
    }

    protected void cleanupExecutionContext() {
        this.execution.removeContext();
    }

    @Override
    public final void run() {
        try {
            this.initExecutionContext();
        }
        catch (ExecutionContextException e) {
            LOGGER.error("Failed to initialize execution context", (Throwable)e);
            return;
        }
        try {
            this.runInternal();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            this.cleanupExecutionContext();
        }
    }

    protected abstract void runInternal() throws InterruptedException;
}

