/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.user.impl.xwiki;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.user.api.XWikiGroupService;
import com.xpn.xwiki.user.api.XWikiRightService;
import com.xpn.xwiki.util.Util;
import com.xpn.xwiki.web.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.bridge.event.DocumentCreatedEvent;
import org.xwiki.bridge.event.DocumentDeletedEvent;
import org.xwiki.bridge.event.DocumentUpdatedEvent;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.observation.EventListener;
import org.xwiki.observation.ObservationManager;
import org.xwiki.observation.event.Event;
import org.xwiki.query.Query;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryManager;

public class XWikiGroupServiceImpl
implements XWikiGroupService,
EventListener {
    public static final EntityReference GROUPCLASS_REFERENCE = new EntityReference("XWikiGroups", EntityType.DOCUMENT, new EntityReference("XWiki", EntityType.SPACE));
    private static final Logger LOGGER = LoggerFactory.getLogger(XWikiDocument.class);
    private static final String CLASS_SUFFIX_XWIKIGROUPS = "XWikiGroups";
    private static final String CLASS_SUFFIX_XWIKIUSERS = "XWikiUsers";
    private static final String CLASS_XWIKIGROUPS = "XWiki.XWikiGroups";
    private static final String CLASSTEMPLATE_XWIKIGROUPS = "XWiki.XWikiGroupTemplate";
    private static final String CLASSTEMPLATE_XWIKIUSERS = "XWiki.XWikiUserTemplate";
    private static final String FIELD_XWIKIGROUPS_MEMBER = "member";
    private static final String DEFAULT_MEMBER_SPACE = "XWiki";
    private static final String WIKI_FULLNAME_SEP = ":";
    private static final String SPACE_NAME_SEP = ".";
    private static final String HQLLIKE_ALL_SYMBOL = "%";
    private static final String ALL_GROUPS_WITH_MEMBER_QUERY = ", BaseObject as obj, StringProperty as prop where doc.fullName=obj.name and obj.className=?1 and obj.id=prop.id.id and prop.name=?2 and prop.value like ?3";
    private static final String NAME = "groupservice";
    private static final List<Event> EVENTS = new ArrayList<Event>(){
        {
            this.add(new DocumentCreatedEvent());
            this.add(new DocumentUpdatedEvent());
            this.add(new DocumentDeletedEvent());
        }
    };
    private DocumentReferenceResolver<String> currentMixedDocumentReferenceResolver = (DocumentReferenceResolver)Utils.getComponent(DocumentReferenceResolver.TYPE_STRING, "currentmixed");
    private EntityReferenceSerializer<String> entityReferenceSerializer = (EntityReferenceSerializer)Utils.getComponent(EntityReferenceSerializer.TYPE_STRING);
    private EntityReferenceSerializer<String> localWikiEntityReferenceSerializer = (EntityReferenceSerializer)Utils.getComponent(EntityReferenceSerializer.TYPE_STRING, "local");
    private EntityReferenceSerializer<String> compactWikiEntityReferenceSerializer = (EntityReferenceSerializer)Utils.getComponent(EntityReferenceSerializer.TYPE_STRING, "compactwiki");

    @Override
    public synchronized void init(XWiki xwiki, XWikiContext context) throws XWikiException {
        Utils.getComponent(ObservationManager.class).addListener((EventListener)this);
    }

    @Override
    public synchronized void initCache(XWikiContext context) throws XWikiException {
    }

    @Override
    public synchronized void initCache(int iCapacity, XWikiContext context) throws XWikiException {
    }

    @Override
    public void flushCache() {
    }

    protected boolean isAllGroupImplicit(XWikiContext context) {
        return context.getWiki().isAllGroupImplicit();
    }

    @Override
    @Deprecated
    public Collection<String> listGroupsForUser(String member, XWikiContext context) throws XWikiException {
        return this.getAllGroupsNamesForMember(member, -1, 0, context);
    }

    @Override
    @Deprecated
    public void addUserToGroup(String username, String database, String group, XWikiContext context) throws XWikiException {
    }

    private boolean isMemberEquals(String currentMember, String memberWiki, String memberSpace, String memberName, XWikiContext context) {
        boolean equals = false;
        if (memberWiki != null) {
            equals |= currentMember.equals(memberWiki + WIKI_FULLNAME_SEP + memberSpace + SPACE_NAME_SEP + memberName);
            if (memberSpace == null || memberSpace.equals(DEFAULT_MEMBER_SPACE)) {
                equals |= currentMember.equals(memberSpace + SPACE_NAME_SEP + memberName);
            }
        }
        if (context.getWikiId() == null || context.getWikiId().equalsIgnoreCase(memberWiki)) {
            equals |= currentMember.equals(memberName);
            if (memberSpace == null || memberSpace.equals(DEFAULT_MEMBER_SPACE)) {
                equals |= currentMember.equals(memberSpace + SPACE_NAME_SEP + memberName);
            }
        }
        return equals;
    }

    private boolean removeUserOrGroupFromGroup(XWikiDocument groupDocument, String memberWiki, String memberSpace, String memberName, XWikiContext context) {
        boolean needUpdate = false;
        List<BaseObject> groups = groupDocument.getXObjects(GROUPCLASS_REFERENCE);
        if (groups != null) {
            for (BaseObject bobj : groups) {
                String member;
                if (bobj == null || !this.isMemberEquals(member = bobj.getStringValue(FIELD_XWIKIGROUPS_MEMBER), memberWiki, memberSpace, memberName, context)) continue;
                needUpdate = groupDocument.removeXObject(bobj);
            }
        }
        return needUpdate;
    }

    private boolean replaceMemberFromGroup(XWikiDocument groupDocument, DocumentReference memberSourceReference, DocumentReference memberTargetReference, XWikiContext context) throws XWikiException {
        boolean needUpdate = false;
        List<BaseObject> groups = groupDocument.getXObjects(GROUPCLASS_REFERENCE);
        String memberSource = (String)this.compactWikiEntityReferenceSerializer.serialize((EntityReference)memberSourceReference, new Object[0]);
        String memberTarget = (String)this.compactWikiEntityReferenceSerializer.serialize((EntityReference)memberTargetReference, new Object[0]);
        if (groups != null) {
            for (BaseObject bobj : groups) {
                String member;
                if (bobj == null || !(member = bobj.getStringValue(FIELD_XWIKIGROUPS_MEMBER)).equals(memberSource)) continue;
                bobj.set(FIELD_XWIKIGROUPS_MEMBER, memberTarget, context);
                needUpdate = true;
            }
        }
        return needUpdate;
    }

    @Override
    public void replaceMemberInAllGroups(DocumentReference memberSourceReference, DocumentReference memberTargetReference, XWikiContext context) throws XWikiException {
        String memberSource = (String)this.compactWikiEntityReferenceSerializer.serialize((EntityReference)memberSourceReference, new Object[0]);
        ArrayList<String> parameterValues = new ArrayList<String>();
        parameterValues.add(CLASS_XWIKIGROUPS);
        parameterValues.add(FIELD_XWIKIGROUPS_MEMBER);
        parameterValues.add(memberSource);
        List<XWikiDocument> documentList = context.getWiki().getStore().searchDocuments(ALL_GROUPS_WITH_MEMBER_QUERY, parameterValues, context);
        for (XWikiDocument groupDocument : documentList) {
            XWikiDocument clonedDocument = groupDocument.clone();
            if (!this.replaceMemberFromGroup(clonedDocument, memberSourceReference, memberTargetReference, context)) continue;
            context.getWiki().saveDocument(clonedDocument, context);
        }
    }

    @Override
    public void removeUserOrGroupFromAllGroups(String memberWiki, String memberSpace, String memberName, XWikiContext context) throws XWikiException {
        ArrayList<Object> parameterValues = new ArrayList<Object>();
        parameterValues.add(CLASS_XWIKIGROUPS);
        parameterValues.add(FIELD_XWIKIGROUPS_MEMBER);
        if (context.getWikiId() == null || context.getWikiId().equalsIgnoreCase(memberWiki)) {
            if (memberSpace == null || memberSpace.equals(DEFAULT_MEMBER_SPACE)) {
                parameterValues.add(HQLLIKE_ALL_SYMBOL + memberName + HQLLIKE_ALL_SYMBOL);
            } else {
                parameterValues.add(HQLLIKE_ALL_SYMBOL + memberSpace + SPACE_NAME_SEP + memberName + HQLLIKE_ALL_SYMBOL);
            }
        } else {
            parameterValues.add(HQLLIKE_ALL_SYMBOL + memberWiki + WIKI_FULLNAME_SEP + memberSpace + SPACE_NAME_SEP + memberName + HQLLIKE_ALL_SYMBOL);
        }
        List<XWikiDocument> documentList = context.getWiki().getStore().searchDocuments(ALL_GROUPS_WITH_MEMBER_QUERY, parameterValues, context);
        for (XWikiDocument groupDocument : documentList) {
            XWikiDocument clonedDocument = groupDocument.clone();
            if (!this.removeUserOrGroupFromGroup(clonedDocument, memberWiki, memberSpace, memberName, context)) continue;
            context.getWiki().saveDocument(clonedDocument, context);
        }
    }

    @Override
    @Deprecated
    public List<String> listMemberForGroup(String group, XWikiContext context) throws XWikiException {
        ArrayList<String> list = new ArrayList<String>();
        try {
            if (group == null) {
                try {
                    return context.getWiki().getStore().getQueryManager().getNamedQuery("getAllUsers").execute();
                }
                catch (QueryException ex) {
                    throw new XWikiException(0, 0, ex.getMessage(), ex);
                }
            }
            String gshortname = Util.getName(group, context);
            XWikiDocument docgroup = context.getWiki().getDocument(gshortname, context);
            List<BaseObject> groups = docgroup.getXObjects(GROUPCLASS_REFERENCE);
            if (groups != null) {
                for (BaseObject bobj : groups) {
                    String member;
                    if (bobj == null || !StringUtils.isNotEmpty((CharSequence)(member = bobj.getStringValue(FIELD_XWIKIGROUPS_MEMBER)))) continue;
                    list.add(member);
                }
            }
            return list;
        }
        catch (XWikiException e) {
            LOGGER.error("Failed to get group document", (Throwable)e);
            return null;
        }
    }

    @Override
    @Deprecated
    public List<String> listAllGroups(XWikiContext context) throws XWikiException {
        if (context.getWiki().getHibernateStore() != null) {
            String sql = ", BaseObject as obj where obj.name=doc.fullName and obj.className='XWiki.XWikiGroups'";
            return context.getWiki().getStore().searchDocumentsNames(sql, context);
        }
        return null;
    }

    public String getName() {
        return NAME;
    }

    public List<Event> getEvents() {
        return EVENTS;
    }

    public void onEvent(Event event, Object source, Object data) {
        XWikiDocument document = (XWikiDocument)source;
        XWikiDocument oldDocument = document.getOriginalDocument();
        if (document.getXObject(GROUPCLASS_REFERENCE) != null || oldDocument.getXObject(GROUPCLASS_REFERENCE) != null) {
            this.flushCache();
        }
    }

    @Override
    public List<?> getAllMatchedUsers(Object[][] matchFields, boolean withdetails, int nb, int start, Object[][] order, XWikiContext context) throws XWikiException {
        return this.getAllMatchedUsersOrGroups(true, matchFields, withdetails, nb, start, order, context);
    }

    @Override
    public List<?> getAllMatchedGroups(Object[][] matchFields, boolean withdetails, int nb, int start, Object[][] order, XWikiContext context) throws XWikiException {
        return this.getAllMatchedUsersOrGroups(false, matchFields, withdetails, nb, start, order, context);
    }

    protected String createMatchUserOrGroupWhereClause(boolean user, Object[][] matchFields, Object[][] order, List<Object> parameterValues) {
        String documentClass = user ? CLASS_SUFFIX_XWIKIUSERS : CLASS_SUFFIX_XWIKIGROUPS;
        String classtemplate = user ? CLASSTEMPLATE_XWIKIUSERS : CLASSTEMPLATE_XWIKIGROUPS;
        StringBuilder from = new StringBuilder(", BaseObject as obj");
        StringBuilder where = new StringBuilder(" where doc.fullName=obj.name");
        parameterValues.add(classtemplate);
        where.append(" and doc.fullName<>?" + parameterValues.size());
        parameterValues.add("XWiki." + documentClass);
        where.append(" and obj.className=?" + parameterValues.size());
        HashMap<String, Object> fieldMap = new HashMap<String, Object>();
        int fieldIndex = 0;
        if (matchFields != null) {
            for (Object[] matchField : matchFields) {
                String fieldName = (String)matchField[0];
                String type = (String)matchField[1];
                String value = (String)matchField[2];
                if (type != null) {
                    Object fieldPrefix;
                    if (!fieldMap.containsKey(fieldName)) {
                        fieldPrefix = "field" + fieldIndex;
                        from.append(", " + type + " as " + (String)fieldPrefix);
                        where.append(" and obj.id=" + (String)fieldPrefix + ".id.id");
                        parameterValues.add(fieldName);
                        where.append(" and " + (String)fieldPrefix + ".name=?" + parameterValues.size());
                        ++fieldIndex;
                    } else {
                        fieldPrefix = (String)fieldMap.get(fieldName);
                    }
                    parameterValues.add(HQLLIKE_ALL_SYMBOL + value.toLowerCase() + HQLLIKE_ALL_SYMBOL);
                    where.append(" and lower(" + (String)fieldPrefix + ".value) like ?" + parameterValues.size());
                    fieldMap.put(fieldName, fieldPrefix);
                    continue;
                }
                if (user && matchFields.length == 1 && fieldName.equals("name")) {
                    parameterValues.add(HQLLIKE_ALL_SYMBOL + value.toLowerCase() + HQLLIKE_ALL_SYMBOL);
                    from.append(", StringProperty firstName, StringProperty lastName");
                    where.append("and obj.id = firstName.id.id and firstName.id.name = 'first_name' and obj.id = lastName.id.id and lastName.id.name = 'last_name' " + String.format("and (lower(doc.name) like ?%s or lower(firstName.value) like ?%s or lower(lastName.value) like ?%s)", parameterValues.size(), parameterValues.size(), parameterValues.size()));
                    continue;
                }
                parameterValues.add(HQLLIKE_ALL_SYMBOL + value.toLowerCase() + HQLLIKE_ALL_SYMBOL);
                if (fieldName.equals("name")) {
                    where.append(String.format(" and (lower(doc.name) like ?%s or lower(doc.title) like ?%s)", parameterValues.size(), parameterValues.size()));
                    continue;
                }
                where.append(String.format(" and lower(doc.%s) like ?%s", fieldName, parameterValues.size()));
            }
        }
        StringBuilder orderString = new StringBuilder();
        if (order != null && order.length > 0) {
            orderString.append(" order by");
            for (int i = 0; i < order.length; ++i) {
                String fieldName = (String)order[i][0];
                String type = (String)order[i][1];
                Boolean asc = (Boolean)order[i][2];
                if (i > 0) {
                    orderString.append(",");
                }
                if (type != null) {
                    Object fieldPrefix;
                    if (!fieldMap.containsKey(fieldName)) {
                        fieldPrefix = "field" + fieldIndex;
                        from.append(", " + type + " as " + (String)fieldPrefix);
                        where.append(" and obj.id=" + (String)fieldPrefix + ".id.id");
                        parameterValues.add(fieldName);
                        where.append(" and " + (String)fieldPrefix + ".name=?" + parameterValues.size());
                        ++fieldIndex;
                    } else {
                        fieldPrefix = (String)fieldMap.get(fieldName);
                    }
                    orderString.append(" " + (String)fieldPrefix + ".value");
                } else {
                    orderString.append(" doc." + fieldName);
                }
                orderString.append(asc == null || asc != false ? " asc" : " desc");
            }
        }
        return from.append((CharSequence)where).append((CharSequence)orderString).toString();
    }

    protected List<?> getAllMatchedUsersOrGroups(boolean user, Object[][] matchFields, boolean withdetails, int nb, int start, Object[][] order, XWikiContext context) throws XWikiException {
        List<Object> groups = null;
        if (context.getWiki().getHibernateStore() != null) {
            ArrayList<Object> parameterValues = new ArrayList<Object>();
            String where = this.createMatchUserOrGroupWhereClause(user, matchFields, order, parameterValues);
            groups = withdetails ? context.getWiki().getStore().searchDocuments(where, false, nb, start, parameterValues, context) : context.getWiki().getStore().searchDocumentsNames(where, nb, start, parameterValues, context);
        } else if (context.getWiki().getStore().getQueryManager().hasLanguage("xpath")) {
            if (matchFields != null && matchFields.length > 0 || withdetails) {
                throw new UnsupportedOperationException("The current storage engine does not support advanced group queries");
            }
            try {
                groups = context.getWiki().getStore().getQueryManager().createQuery("/*/*[obj/XWiki/" + (user ? CLASS_SUFFIX_XWIKIUSERS : CLASS_SUFFIX_XWIKIGROUPS) + "]/@fullName", "xpath").setLimit(nb).setOffset(start).execute();
            }
            catch (QueryException ex) {
                throw new XWikiException(0, 0, ex.getMessage(), ex);
            }
        }
        return groups;
    }

    protected int countAllMatchedUsersOrGroups(boolean user, Object[][] matchFields, XWikiContext context) throws XWikiException {
        ArrayList<Object> parameterValues = new ArrayList<Object>();
        String where = this.createMatchUserOrGroupWhereClause(user, matchFields, null, parameterValues);
        String sql = "select count(distinct doc) from XWikiDocument doc" + where;
        List list = context.getWiki().getStore().search(sql, 0, 0, parameterValues, context);
        if (list == null || list.size() == 0) {
            return 0;
        }
        return ((Number)list.get(0)).intValue();
    }

    @Override
    public int countAllMatchedUsers(Object[][] matchFields, XWikiContext context) throws XWikiException {
        return this.countAllMatchedUsersOrGroups(true, matchFields, context);
    }

    @Override
    public int countAllMatchedGroups(Object[][] matchFields, XWikiContext context) throws XWikiException {
        return this.countAllMatchedUsersOrGroups(false, matchFields, context);
    }

    protected String createMatchGroupMembersWhereClause(String groupFullName, String matchField, Boolean orderAsc, Map<String, Object> parameterValues) {
        StringBuilder queryString = new StringBuilder();
        queryString.append(" FROM BaseObject as obj, StringProperty as field");
        queryString.append(" WHERE obj.name = :groupdocname and obj.className = :groupclassname").append(" and obj.id = field.id.id and field.id.name = 'member'");
        parameterValues.put("groupdocname", groupFullName);
        parameterValues.put("groupclassname", CLASS_XWIKIGROUPS);
        if (matchField != null) {
            String matchedUsers = "select userDoc.fullName from XWikiDocument userDoc, BaseObject as userObj, StringProperty as userFirstName, StringProperty as userLastName where userDoc.fullName = userObj.name and userObj.className = 'XWiki.XWikiUsers' and userObj.id = userFirstName.id.id and userFirstName.id.name = 'first_name' and userObj.id = userLastName.id.id and userLastName.id.name = 'last_name' and (lower(userDoc.name) like :matchfield or concat(concat(lower(userFirstName.value), ' '), lower(userLastName.value)) like :matchfield)";
            String matchedGroups = "select distinct(groupDoc.fullName) from XWikiDocument groupDoc, BaseObject as groupObj where groupDoc.fullName = groupObj.name and groupObj.className = 'XWiki.XWikiGroups' and (lower(groupDoc.name) like :matchfield or lower(groupDoc.title) like :matchfield)";
            queryString.append(" and (lower(field.value) like :matchfield or field.value in (").append(matchedUsers).append(") or field.value in (").append(matchedGroups).append("))");
            parameterValues.put("matchfield", HQLLIKE_ALL_SYMBOL + matchField.toLowerCase() + HQLLIKE_ALL_SYMBOL);
        } else {
            queryString.append(" and (trim(both ' ' from field.value) <> '' or (trim(both ' ' from field.value) is not null and '' is null))");
        }
        if (orderAsc != null) {
            queryString.append(" ORDER BY field.value ").append(orderAsc != false ? "asc" : "desc");
        }
        return queryString.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<String> getAllGroupsNamesForMember(String member, int nb, int start, XWikiContext context) throws XWikiException {
        ArrayList<String> groupNames = null;
        DocumentReference memberReference = this.currentMixedDocumentReferenceResolver.resolve((Object)member, new Object[0]);
        String currentWiki = context.getWikiId();
        try {
            context.setWikiId(memberReference.getWikiReference().getName());
            Collection<DocumentReference> groupReferences = this.getAllGroupsReferencesForMember(memberReference, nb, start, context);
            groupNames = new ArrayList<String>(groupReferences.size());
            for (DocumentReference groupReference : groupReferences) {
                groupNames.add((String)this.localWikiEntityReferenceSerializer.serialize((EntityReference)groupReference, new Object[0]));
            }
        }
        finally {
            context.setWikiId(currentWiki);
        }
        return groupNames;
    }

    @Override
    public Collection<DocumentReference> getAllGroupsReferencesForMember(DocumentReference memberReference, int limit, int offset, XWikiContext context) throws XWikiException {
        DocumentReference currentXWikiAllGroup;
        List groupNames;
        HashSet<DocumentReference> groupReferences = null;
        try {
            Query query = XWikiRightService.isGuest((EntityReference)memberReference) ? context.getWiki().getStore().getQueryManager().getNamedQuery("listGroupsForUser").bindValue("username", (Object)"XWiki.XWikiGuest").bindValue("shortname", (Object)"XWiki.XWikiGuest").bindValue("veryshortname", (Object)"XWikiGuest") : (memberReference.getWikiReference().getName().equals(context.getWikiId()) || memberReference.getLastSpaceReference().getName().equals(DEFAULT_MEMBER_SPACE) && memberReference.getName().equals("XWikiGuest") ? context.getWiki().getStore().getQueryManager().getNamedQuery("listGroupsForUser").bindValue("username", this.entityReferenceSerializer.serialize((EntityReference)memberReference, new Object[0])).bindValue("shortname", this.localWikiEntityReferenceSerializer.serialize((EntityReference)memberReference, new Object[0])).bindValue("veryshortname", (Object)memberReference.getName()) : context.getWiki().getStore().getQueryManager().getNamedQuery("listGroupsForUserInOtherWiki").bindValue("prefixedmembername", this.entityReferenceSerializer.serialize((EntityReference)memberReference, new Object[0])));
            query.setOffset(offset);
            query.setLimit(limit);
            groupNames = query.execute();
        }
        catch (QueryException ex) {
            throw new XWikiException(0, 0, ex.getMessage(), ex);
        }
        groupReferences = new HashSet<DocumentReference>(groupNames.size());
        for (String groupName : groupNames) {
            groupReferences.add(this.currentMixedDocumentReferenceResolver.resolve((Object)groupName, new Object[0]));
        }
        if (this.isAllGroupImplicit(context) && !XWikiRightService.isGuest((EntityReference)memberReference) && memberReference.getWikiReference().getName().equals(context.getWikiId()) && !(currentXWikiAllGroup = new DocumentReference(context.getWikiId(), DEFAULT_MEMBER_SPACE, "XWikiAllGroup")).equals((Object)memberReference)) {
            groupReferences.add(currentXWikiAllGroup);
        }
        return groupReferences;
    }

    @Override
    public Collection<String> getAllMembersNamesForGroup(String group, int nb, int start, XWikiContext context) throws XWikiException {
        return this.getAllMatchedMembersNamesForGroup(group, null, nb, start, null, context);
    }

    @Override
    public Collection<String> getAllMatchedMembersNamesForGroup(String group, String matchField, int nb, int start, Boolean orderAsc, XWikiContext context) throws XWikiException {
        DocumentReference groupReference = this.currentMixedDocumentReferenceResolver.resolve((Object)group, new Object[0]);
        String localGroupReference = (String)this.localWikiEntityReferenceSerializer.serialize((EntityReference)groupReference, new Object[0]);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        StringBuilder statement = new StringBuilder("SELECT field.value ").append(this.createMatchGroupMembersWhereClause(localGroupReference, matchField, orderAsc, parameters));
        try {
            QueryManager queryManager = context.getWiki().getStore().getQueryManager();
            Query query = queryManager.createQuery(statement.toString(), "hql");
            for (Map.Entry entry : parameters.entrySet()) {
                query.bindValue((String)entry.getKey(), entry.getValue());
            }
            query.setOffset(start);
            query.setLimit(nb);
            query.setWiki(groupReference.getWikiReference().getName());
            return query.execute();
        }
        catch (QueryException ex) {
            throw new XWikiException(0, 0, ex.getMessage(), ex);
        }
    }

    @Override
    public int countAllMatchedMembersNamesForGroup(String group, String filter, XWikiContext xcontext) throws XWikiException {
        DocumentReference groupReference = this.currentMixedDocumentReferenceResolver.resolve((Object)group, new Object[0]);
        String localGroupReference = (String)this.localWikiEntityReferenceSerializer.serialize((EntityReference)groupReference, new Object[0]);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        StringBuilder statement = new StringBuilder("select count(field.value) ").append(this.createMatchGroupMembersWhereClause(localGroupReference, filter, null, parameters));
        try {
            QueryManager queryManager = xcontext.getWiki().getStore().getQueryManager();
            Query query = queryManager.createQuery(statement.toString(), "hql");
            query.setWiki(groupReference.getWikiReference().getName());
            for (Map.Entry entry : parameters.entrySet()) {
                query.bindValue((String)entry.getKey(), entry.getValue());
            }
            return ((Long)query.execute().get(0)).intValue();
        }
        catch (QueryException ex) {
            throw new XWikiException(0, 0, ex.getMessage(), ex);
        }
    }

    @Override
    public int countAllGroupsNamesForMember(String member, XWikiContext context) throws XWikiException {
        if (member == null) {
            return 0;
        }
        return this.getAllGroupsNamesForMember(member, 0, 0, context).size();
    }

    @Override
    public int countAllMembersNamesForGroup(String group, XWikiContext context) throws XWikiException {
        if (group == null) {
            return 0;
        }
        return this.getAllMembersNamesForGroup(group, 0, 0, context).size();
    }
}

