/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.user.impl.xwiki;

import jakarta.servlet.http.HttpServletRequest;
import java.security.MessageDigest;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.securityfilter.authenticator.persistent.DefaultPersistentLoginManager;
import org.securityfilter.filter.SecurityRequestWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.container.servlet.HttpServletUtils;
import org.xwiki.jakartabridge.servlet.JakartaServletBridge;

public class MyPersistentLoginManager
extends DefaultPersistentLoginManager {
    private static final long serialVersionUID = -8454351828032103173L;
    private static final String FIELD_SEPARATOR = ":";
    private static final String COOKIE_DOT_PFX = ".";
    private static final Logger LOGGER = LoggerFactory.getLogger(MyPersistentLoginManager.class);
    private static final String DEFAULT_VALUE = "false";
    protected String[] cookieDomains;
    protected String cookiePath = "/";
    protected String cookiePrefix = "";

    public void setCookieDomains(String[] cdlist) {
        this.cookieDomains = cdlist != null && cdlist.length > 0 ? Arrays.copyOf(cdlist, cdlist.length) : null;
    }

    public void setCookiePath(String cp) {
        this.cookiePath = cp;
    }

    @Deprecated
    public void setupCookie(Cookie cookie, boolean sessionCookie, String cookieDomain, HttpServletResponse response) {
        this.setupCookie(cookie, sessionCookie, false, cookieDomain, response);
    }

    private void setupCookie(Cookie cookie, boolean sessionCookie, boolean secureCookie, String cookieDomain, HttpServletResponse response) {
        if (!sessionCookie) {
            this.setMaxAge(cookie);
        }
        cookie.setSecure(secureCookie);
        cookie.setPath(this.cookiePath);
        if (cookieDomain != null) {
            cookie.setDomain(cookieDomain);
        }
        cookie.setHttpOnly(true);
        this.addCookie(response, cookie);
    }

    public void rememberLogin(javax.servlet.http.HttpServletRequest request, HttpServletResponse response, String username, String password) {
        String protectedUsername = username;
        String protectedPassword = password;
        if (this.protection.equals("all") || this.protection.equals("encryption")) {
            protectedUsername = this.encryptText(protectedUsername);
            protectedPassword = this.encryptText(protectedPassword);
            if (protectedUsername == null || protectedPassword == null) {
                LOGGER.error("ERROR!!");
                LOGGER.error("There was a problem encrypting the username or password!!");
                LOGGER.error("Remember Me function will be disabled!!");
                return;
            }
        }
        boolean sessionCookie = !MyPersistentLoginManager.isTrue(request.getParameter("j_rememberme"));
        boolean secureCookie = request.isSecure();
        String cookieDomain = this.getCookieDomain(request);
        Cookie usernameCookie = new Cookie(this.getCookiePrefix() + "username", protectedUsername);
        this.setupCookie(usernameCookie, sessionCookie, secureCookie, cookieDomain, response);
        Cookie passwdCookie = new Cookie(this.getCookiePrefix() + "password", protectedPassword);
        this.setupCookie(passwdCookie, sessionCookie, secureCookie, cookieDomain, response);
        Cookie rememberCookie = new Cookie(this.getCookiePrefix() + "rememberme", "" + !sessionCookie);
        this.setupCookie(rememberCookie, sessionCookie, secureCookie, cookieDomain, response);
        if (this.protection.equals("all") || this.protection.equals("validation")) {
            String validationHash = this.getValidationHash(protectedUsername, protectedPassword, this.getClientIP(request));
            if (validationHash != null) {
                Cookie validationCookie = new Cookie(this.getCookiePrefix() + "validation", validationHash);
                this.setupCookie(validationCookie, sessionCookie, secureCookie, cookieDomain, response);
            } else if (LOGGER.isErrorEnabled()) {
                LOGGER.error("WARNING!!! WARNING!!!");
                LOGGER.error("PROTECTION=ALL or PROTECTION=VALIDATION was specified");
                LOGGER.error("but Validation Hash could NOT be generated");
                LOGGER.error("Validation has been disabled!!!!");
            }
        }
    }

    private void setMaxAge(Cookie cookie) {
        block2: {
            try {
                cookie.setMaxAge(Math.round(86400.0f * Float.parseFloat(this.cookieLife)));
            }
            catch (Exception e) {
                if (!LOGGER.isErrorEnabled()) break block2;
                LOGGER.error("Failed setting cookie Max age with duration " + this.cookieLife);
            }
        }
    }

    private void addCookie(HttpServletResponse response, Cookie cookie) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Adding cookie: " + cookie.getDomain() + cookie.getPath() + " " + cookie.getName() + "=" + cookie.getValue());
        }
        response.addCookie(cookie);
    }

    private String getCookieDomain(javax.servlet.http.HttpServletRequest request) {
        String cookieDomain = null;
        if (this.cookieDomains != null) {
            String servername = request.getServerName();
            for (String domain : this.cookieDomains) {
                if (!servername.endsWith(domain)) continue;
                cookieDomain = domain;
                break;
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Cookie domain is:" + cookieDomain);
        }
        return cookieDomain;
    }

    private String getValidationHash(String username, String password, String clientIP) {
        if (this.validationKey == null) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("ERROR! >> validationKey not specified...");
                LOGGER.error("you are REQUIRED to specify the validatonkey in xwiki.cfg");
            }
            return null;
        }
        MessageDigest md5 = null;
        StringBuffer sbValueBeforeMD5 = new StringBuffer();
        try {
            md5 = MessageDigest.getInstance("MD5");
            sbValueBeforeMD5.append(username);
            sbValueBeforeMD5.append(FIELD_SEPARATOR);
            sbValueBeforeMD5.append(password.toString());
            sbValueBeforeMD5.append(FIELD_SEPARATOR);
            if (MyPersistentLoginManager.isTrue(this.useIP)) {
                sbValueBeforeMD5.append(clientIP.toString());
                sbValueBeforeMD5.append(FIELD_SEPARATOR);
            }
            sbValueBeforeMD5.append(this.validationKey.toString());
            this.valueBeforeMD5 = sbValueBeforeMD5.toString();
            md5.update(this.valueBeforeMD5.getBytes());
            byte[] array = md5.digest();
            StringBuffer sb = new StringBuffer();
            for (byte element : array) {
                int b = element & 0xFF;
                if (b < 16) {
                    sb.append('0');
                }
                sb.append(Integer.toHexString(b));
            }
            this.valueAfterMD5 = sb.toString();
        }
        catch (Exception e) {
            LOGGER.error("Failed to get [" + MessageDigest.class.getName() + "] instance", (Throwable)e);
        }
        return this.valueAfterMD5;
    }

    public String encryptText(String clearText) {
        block4: {
            try {
                Cipher c1 = Cipher.getInstance(this.cipherParameters);
                if (this.secretKey != null) {
                    c1.init(1, this.secretKey);
                    byte[] clearTextBytes = clearText.getBytes();
                    byte[] encryptedText = c1.doFinal(clearTextBytes);
                    String encryptedEncodedText = new String(Base64.encodeBase64((byte[])encryptedText));
                    return encryptedEncodedText.replaceAll("=", "_");
                }
                if (LOGGER.isErrorEnabled()) {
                    LOGGER.error("ERROR! >> SecretKey not generated...");
                    LOGGER.error("you are REQUIRED to specify the encryptionKey in xwiki.cfg");
                }
            }
            catch (Exception e) {
                if (!LOGGER.isErrorEnabled()) break block4;
                LOGGER.error("Failed to encrypt text: " + clearText, (Throwable)e);
            }
        }
        return null;
    }

    public void forgetLogin(javax.servlet.http.HttpServletRequest request, HttpServletResponse response) {
        ((SecurityRequestWrapper)request).setUserPrincipal(null);
        this.removeCookie(request, response, this.getCookiePrefix() + "username");
        this.removeCookie(request, response, this.getCookiePrefix() + "password");
        this.removeCookie(request, response, this.getCookiePrefix() + "rememberme");
        this.removeCookie(request, response, this.getCookiePrefix() + "validation");
    }

    private static Cookie getCookie(Cookie[] cookies, String cookieName) {
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookieName.equals(cookie.getName())) continue;
                return cookie;
            }
        }
        return null;
    }

    private void removeCookie(javax.servlet.http.HttpServletRequest request, HttpServletResponse response, String cookieName) {
        Cookie cookie = MyPersistentLoginManager.getCookie(request.getCookies(), cookieName);
        if (cookie != null) {
            cookie.setMaxAge(0);
            cookie.setValue("");
            cookie.setPath(this.cookiePath);
            this.addCookie(response, cookie);
            String cookieDomain = this.getCookieDomain(request);
            if (cookieDomain != null) {
                cookie.setDomain(cookieDomain);
                this.addCookie(response, cookie);
            }
        }
    }

    private static boolean isTrue(String text) {
        return "true".equals(text) || "1".equals(text) || "yes".equals(text);
    }

    private static String getCookieValue(Cookie[] cookies, String cookieName, String defaultValue) {
        String value = defaultValue;
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookieName.equals(cookie.getName())) continue;
                value = cookie.getValue();
            }
        }
        return value;
    }

    private boolean checkValidation(javax.servlet.http.HttpServletRequest request, HttpServletResponse response) {
        if (this.protection.equals("all") || this.protection.equals("validation")) {
            String calculatedHash;
            String username = MyPersistentLoginManager.getCookieValue(request.getCookies(), this.getCookiePrefix() + "username", DEFAULT_VALUE);
            String password = MyPersistentLoginManager.getCookieValue(request.getCookies(), this.getCookiePrefix() + "password", DEFAULT_VALUE);
            String cookieHash = MyPersistentLoginManager.getCookieValue(request.getCookies(), this.getCookiePrefix() + "validation", DEFAULT_VALUE);
            if (cookieHash.equals(calculatedHash = this.getValidationHash(username, password, this.getClientIP(request)))) {
                return true;
            }
            LOGGER.warn("Login cookie validation hash mismatch! Cookies have been tampered with");
            LOGGER.info("Login cookie is being deleted!");
            this.forgetLogin(request, response);
        }
        return false;
    }

    public String getRememberedUsername(javax.servlet.http.HttpServletRequest request, HttpServletResponse response) {
        String username = MyPersistentLoginManager.getCookieValue(request.getCookies(), this.getCookiePrefix() + "username", DEFAULT_VALUE);
        if (!username.equals(DEFAULT_VALUE) && this.checkValidation(request, response)) {
            if (this.protection.equals("all") || this.protection.equals("encryption")) {
                username = this.decryptText(username);
            }
            return username;
        }
        return null;
    }

    public String getRememberedPassword(javax.servlet.http.HttpServletRequest request, HttpServletResponse response) {
        String password = MyPersistentLoginManager.getCookieValue(request.getCookies(), this.getCookiePrefix() + "password", DEFAULT_VALUE);
        if (!password.equals(DEFAULT_VALUE) && this.checkValidation(request, response)) {
            if (this.protection.equals("all") || this.protection.equals("encryption")) {
                password = this.decryptText(password);
            }
            return password;
        }
        return null;
    }

    public boolean rememberingLogin(javax.servlet.http.HttpServletRequest request) {
        return MyPersistentLoginManager.getCookieValue(request.getCookies(), this.getCookiePrefix() + "rememberme", DEFAULT_VALUE).equals("true");
    }

    private String decryptText(String encryptedText) {
        try {
            byte[] decodedEncryptedText = Base64.decodeBase64((byte[])encryptedText.replaceAll("_", "=").getBytes("ISO-8859-1"));
            Cipher c1 = Cipher.getInstance(this.cipherParameters);
            c1.init(2, this.secretKey);
            byte[] decryptedText = c1.doFinal(decodedEncryptedText);
            String decryptedTextString = new String(decryptedText);
            return decryptedTextString;
        }
        catch (Exception e) {
            LOGGER.error("Error decypting text: " + encryptedText, (Throwable)e);
            return null;
        }
    }

    protected String getClientIP(javax.servlet.http.HttpServletRequest request) {
        return HttpServletUtils.getClientIP((HttpServletRequest)JakartaServletBridge.toJakarta((javax.servlet.http.HttpServletRequest)request));
    }

    public void setCookiePrefix(String prefix) {
        this.cookiePrefix = prefix;
    }

    public String getCookiePrefix() {
        return this.cookiePrefix;
    }
}

