/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.user.impl.xwiki;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.internal.user.UserAuthenticatedEventNotifier;
import com.xpn.xwiki.user.impl.xwiki.XWikiAuthenticator;
import com.xpn.xwiki.web.Utils;
import java.io.IOException;
import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.securityfilter.authenticator.BasicAuthenticator;
import org.securityfilter.filter.SecurityFilter;
import org.securityfilter.filter.SecurityRequestWrapper;
import org.securityfilter.realm.SimplePrincipal;
import org.xwiki.security.authentication.AuthenticationFailureManager;

public class MyBasicAuthenticator
extends BasicAuthenticator
implements XWikiAuthenticator {
    private UserAuthenticatedEventNotifier userAuthenticatedEventNotifier;

    private UserAuthenticatedEventNotifier getUserAuthenticatedEventNotifier() {
        if (this.userAuthenticatedEventNotifier == null) {
            this.userAuthenticatedEventNotifier = Utils.getComponent(UserAuthenticatedEventNotifier.class);
        }
        return this.userAuthenticatedEventNotifier;
    }

    public boolean processLogin(SecurityRequestWrapper request, HttpServletResponse response) throws Exception {
        return this.processLogin(request, response, null);
    }

    @Override
    public boolean processLogin(SecurityRequestWrapper request, HttpServletResponse response, XWikiContext context) throws Exception {
        Principal principal = MyBasicAuthenticator.checkLogin(request, response, context);
        if (principal == null) {
            this.showLogin(request.getCurrentRequest(), response);
            return true;
        }
        return false;
    }

    @Override
    public boolean processLogin(String username, String password, String rememberme, SecurityRequestWrapper request, HttpServletResponse response, XWikiContext context) throws Exception {
        Principal principal = MyBasicAuthenticator.authenticate(username, password, context);
        if (principal != null) {
            request.getSession().removeAttribute(LOGIN_ATTEMPTS);
            if (!StringUtils.contains((CharSequence)principal.getName(), (int)58)) {
                principal = new SimplePrincipal(context.getWikiId() + ":" + principal.getName());
            }
            request.setUserPrincipal(principal);
            this.getUserAuthenticatedEventNotifier().notify(principal.getName());
            return false;
        }
        this.showLogin(request.getCurrentRequest(), response);
        return true;
    }

    private static String convertUsername(String username, XWikiContext context) {
        return context.getWiki().convertUsername(username, context);
    }

    public static Principal checkLogin(SecurityRequestWrapper request, HttpServletResponse response, XWikiContext context) throws Exception {
        String authorizationHeader = request.getHeader("Authorization");
        if (authorizationHeader != null) {
            String decoded = MyBasicAuthenticator.decodeBasicAuthorizationString(authorizationHeader);
            String username = MyBasicAuthenticator.convertUsername(MyBasicAuthenticator.parseUsername(decoded), context);
            String password = MyBasicAuthenticator.parsePassword(decoded);
            Principal principal = MyBasicAuthenticator.authenticate(username, password, context);
            AuthenticationFailureManager authenticationFailureManager = Utils.getComponent(AuthenticationFailureManager.class);
            if (principal != null && authenticationFailureManager.validateForm(username, (HttpServletRequest)request)) {
                request.getSession().removeAttribute(LOGIN_ATTEMPTS);
                authenticationFailureManager.resetAuthenticationFailureCounter(username);
                if (!StringUtils.contains((CharSequence)principal.getName(), (int)58)) {
                    principal = new SimplePrincipal(context.getWikiId() + ":" + principal.getName());
                }
                request.setUserPrincipal(principal);
                UserAuthenticatedEventNotifier notifier = Utils.getComponent(UserAuthenticatedEventNotifier.class);
                notifier.notify(principal.getName());
                return principal;
            }
            authenticationFailureManager.recordAuthenticationFailure(username, (HttpServletRequest)request);
        }
        return null;
    }

    public static String parseUsername(String decoded) {
        if (decoded == null) {
            return null;
        }
        int colon = decoded.indexOf(58);
        if (colon < 0) {
            return null;
        }
        return decoded.substring(0, colon).trim();
    }

    public static String parsePassword(String decoded) {
        if (decoded == null) {
            return null;
        }
        int colon = decoded.indexOf(58);
        if (colon < 0) {
            return null;
        }
        return decoded.substring(colon + 1).trim();
    }

    public static String decodeBasicAuthorizationString(String authorization) {
        if (authorization == null || !authorization.toLowerCase().startsWith("basic ")) {
            return null;
        }
        authorization = authorization.substring(6).trim();
        return new String(Base64.decodeBase64((byte[])authorization.getBytes()));
    }

    public static Principal authenticate(String username, String password, XWikiContext context) throws XWikiException {
        return context.getWiki().getAuthService().authenticate(username, password, context);
    }

    public static void showLogin(HttpServletRequest request, HttpServletResponse response, String realmName) throws IOException {
        int loginAttempts;
        SecurityFilter.saveRequestInformation((HttpServletRequest)request);
        if (request.getSession().getAttribute(LOGIN_ATTEMPTS) != null) {
            loginAttempts = (Integer)request.getSession().getAttribute(LOGIN_ATTEMPTS);
            ++loginAttempts;
        } else {
            loginAttempts = 1;
        }
        request.getSession().setAttribute(LOGIN_ATTEMPTS, (Object)loginAttempts);
        if (loginAttempts <= 3) {
            response.setHeader("WWW-Authenticate", "BASIC realm=\"" + realmName + "\"");
            response.setStatus(401);
        } else {
            request.getSession().removeAttribute(LOGIN_ATTEMPTS);
            response.sendError(401, "Sorry you are having problems logging in, please try again");
        }
    }

    @Override
    public void showLogin(HttpServletRequest request, HttpServletResponse response, XWikiContext context) throws IOException {
        MyBasicAuthenticator.showLogin(request, response, this.realmName);
    }
}

