/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.user.impl.xwiki;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.user.api.XWikiAuthService;
import com.xpn.xwiki.web.Utils;
import java.security.Principal;
import org.apache.commons.lang3.StringUtils;
import org.securityfilter.realm.SimplePrincipal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;

public abstract class AbstractXWikiAuthService
implements XWikiAuthService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractXWikiAuthService.class);
    private static final String SUPERADMIN_PASSWORD_CONFIG = "xwiki.superadminpassword";

    protected boolean isSuperAdmin(String username) {
        DocumentReference documentReference = ((DocumentReferenceResolver)Utils.getComponent(DocumentReferenceResolver.TYPE_STRING)).resolve((Object)username, new Object[0]);
        return StringUtils.equalsIgnoreCase((CharSequence)documentReference.getName(), (CharSequence)"superadmin");
    }

    protected Principal authenticateSuperAdmin(String password, XWikiContext context) {
        SimplePrincipal principal;
        String superadminpassword;
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Authenticate superadmin");
        }
        if ((superadminpassword = context.getWiki().Param(SUPERADMIN_PASSWORD_CONFIG)) != null && superadminpassword.equals(password)) {
            principal = context.isMainWiki() ? new SimplePrincipal("XWiki.superadmin") : new SimplePrincipal(context.getMainXWiki() + ":XWiki.superadmin");
        } else {
            principal = null;
            context.put("message", "invalidcredentials");
        }
        return principal;
    }
}

