/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.user.api;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.user.api.XWikiGroupService;
import com.xpn.xwiki.user.api.XWikiRightService;
import com.xpn.xwiki.web.Utils;
import java.util.Collection;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.localization.ContextualLocalizationManager;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.model.reference.LocalDocumentReference;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.user.GuestUserReference;
import org.xwiki.user.UserReference;
import org.xwiki.user.UserReferenceResolver;

public class XWikiUser {
    private static final String USER_CLASS = "XWiki.XWikiUsers";
    public static final String ACTIVE_PROPERTY = "active";
    public static final String EMAIL_CHECKED_PROPERTY = "email_checked";
    public static final LocalDocumentReference ACCOUNT_VALIDATION_DOCUMENT_REFERENCE = new LocalDocumentReference("XWiki", "AccountValidation");
    private DocumentReferenceResolver<String> currentMixedDocumentReferenceResolver;
    private EntityReferenceSerializer<String> localEntityReferenceSerializer;
    private ContextualLocalizationManager localization;
    private UserReferenceResolver<DocumentReference> documentReferenceUserReferenceResolver;
    private Logger logger = LoggerFactory.getLogger(XWikiUser.class);
    private String fullName;
    private boolean fullNameNull;
    private DocumentReference userReference;
    private boolean userReferenceSet;
    private boolean main;

    public XWikiUser(DocumentReference userReference) {
        this(userReference, userReference == null || "xwiki".equals(userReference.getWikiReference().getName()));
    }

    public XWikiUser(DocumentReference userReference, boolean main) {
        this.userReference = userReference;
        this.userReferenceSet = true;
        this.setMain(main);
    }

    @Deprecated
    public XWikiUser(String user) {
        this(user, false);
    }

    @Deprecated
    public XWikiUser(String user, boolean main) {
        this.setUser(user);
        this.setMain(main);
    }

    private void setUserReference(DocumentReference userReference) {
        this.userReference = userReference;
        this.userReferenceSet = true;
    }

    private String toFullName(DocumentReference userReference) {
        if (userReference != null) {
            return (String)this.getLocalEntityReferenceSerializer().serialize((EntityReference)userReference, new Object[0]);
        }
        return "XWiki.XWikiGuest";
    }

    private DocumentReference fromFullName(String fullName) {
        DocumentReference reference = null;
        if (fullName != null && !fullName.endsWith("XWiki.XWikiGuest") && !fullName.equals("XWikiGuest")) {
            reference = this.getCurrentMixedDocumentReferenceResolver().resolve((Object)fullName, new Object[0]);
        }
        return reference;
    }

    @Deprecated
    public String getUser() {
        return this.getFullName();
    }

    public String getFullName() {
        if (this.fullName == null && !this.fullNameNull) {
            this.fullName = this.toFullName(this.userReference);
            this.fullNameNull = this.fullName == null;
        }
        return this.fullName;
    }

    private DocumentReferenceResolver<String> getCurrentMixedDocumentReferenceResolver() {
        if (this.currentMixedDocumentReferenceResolver == null) {
            this.currentMixedDocumentReferenceResolver = (DocumentReferenceResolver)Utils.getComponent(DocumentReferenceResolver.TYPE_STRING, "currentmixed");
        }
        return this.currentMixedDocumentReferenceResolver;
    }

    private EntityReferenceSerializer<String> getLocalEntityReferenceSerializer() {
        if (this.localEntityReferenceSerializer == null) {
            this.localEntityReferenceSerializer = (EntityReferenceSerializer)Utils.getComponent(EntityReferenceSerializer.TYPE_STRING, "local");
        }
        return this.localEntityReferenceSerializer;
    }

    private UserReferenceResolver<DocumentReference> getDocumentReferenceUserReferenceResolver() {
        if (this.documentReferenceUserReferenceResolver == null) {
            this.documentReferenceUserReferenceResolver = (UserReferenceResolver)Utils.getComponent(UserReferenceResolver.TYPE_DOCUMENT_REFERENCE, "document");
        }
        return this.documentReferenceUserReferenceResolver;
    }

    private ContextualLocalizationManager getLocalization() {
        if (this.localization == null) {
            this.localization = Utils.getComponent(ContextualLocalizationManager.class);
        }
        return this.localization;
    }

    private String localizePlainOrKey(String key, Object ... parameters) {
        return StringUtils.defaultString((String)this.getLocalization().getTranslationPlain(key, parameters), (String)key);
    }

    public DocumentReference getUserReference() {
        if (!this.userReferenceSet) {
            this.setUserReference(this.fromFullName(this.getUser()));
        }
        return this.userReference;
    }

    private DocumentReference getUserClassReference(WikiReference userDocWiki) {
        return this.getCurrentMixedDocumentReferenceResolver().resolve((Object)(userDocWiki.getName() + ":XWiki.XWikiUsers"), new Object[0]);
    }

    private boolean isGuest() {
        return XWikiRightService.isGuest((EntityReference)this.getUserReference());
    }

    private boolean isSuperAdmin() {
        return XWikiRightService.isSuperAdmin((EntityReference)this.getUserReference());
    }

    private XWikiDocument getUserDocument(XWikiContext context) throws XWikiException {
        return context.getWiki().getDocument(this.getUserReference(), context);
    }

    public boolean isEmailChecked(XWikiContext context) {
        boolean isChecked;
        if (this.isGuest() || this.isSuperAdmin()) {
            isChecked = true;
        } else {
            try {
                XWikiDocument userdoc = this.getUserDocument(context);
                DocumentReference userClassReference = this.getUserClassReference(userdoc.getDocumentReference().getWikiReference());
                isChecked = userdoc.getIntValue(userClassReference, EMAIL_CHECKED_PROPERTY, 1) != 0;
            }
            catch (XWikiException e) {
                this.logger.error("Error while checking email_checked status of user [{}]", (Object)this.getUser(), (Object)e);
                isChecked = true;
            }
        }
        return isChecked;
    }

    public void setEmailChecked(boolean checked, XWikiContext context) {
        if (!this.isGuest() && !this.isSuperAdmin()) {
            int checkedFlag = checked ? 1 : 0;
            try {
                XWikiDocument userdoc = this.getUserDocument(context);
                userdoc = userdoc.clone();
                userdoc.setIntValue((EntityReference)this.getUserClassReference(userdoc.getDocumentReference().getWikiReference()), EMAIL_CHECKED_PROPERTY, checkedFlag);
                context.getWiki().saveDocument(userdoc, this.localizePlainOrKey("core.users." + (checked ? EMAIL_CHECKED_PROPERTY : "email_unchecked") + ".saveComment", new Object[0]), context);
            }
            catch (XWikiException e) {
                this.logger.error("Error while setting email_checked status of user [{}]", (Object)this.getUser(), (Object)e);
            }
        }
    }

    public boolean isDisabled(XWikiContext context) {
        boolean disabled;
        if (this.isGuest() || this.isSuperAdmin()) {
            disabled = false;
        } else {
            try {
                XWikiDocument userdoc = this.getUserDocument(context);
                DocumentReference userClassReference = this.getUserClassReference(userdoc.getDocumentReference().getWikiReference());
                disabled = userdoc.getIntValue(userClassReference, ACTIVE_PROPERTY, 1) == 0;
            }
            catch (XWikiException e) {
                this.logger.error("Error while checking active status of user [{}]", (Object)this.getUser(), (Object)e);
                disabled = false;
            }
        }
        return disabled;
    }

    public void setDisabled(boolean disable, XWikiContext context) {
        if (!this.isGuest() && !this.isSuperAdmin()) {
            int activeFlag = disable ? 0 : 1;
            try {
                XWikiDocument userdoc = this.getUserDocument(context);
                userdoc = userdoc.clone();
                userdoc.setIntValue((EntityReference)this.getUserClassReference(userdoc.getDocumentReference().getWikiReference()), ACTIVE_PROPERTY, activeFlag);
                UserReference userReference = this.getDocumentReferenceUserReferenceResolver().resolve((Object)context.getUserReference(), new Object[0]);
                if (GuestUserReference.INSTANCE.equals(userReference)) {
                    userReference = this.getDocumentReferenceUserReferenceResolver().resolve((Object)userdoc.getDocumentReference(), new Object[0]);
                }
                userdoc.getAuthors().setOriginalMetadataAuthor(userReference);
                context.getWiki().saveDocument(userdoc, this.localizePlainOrKey("core.users." + (disable ? "disable" : "enable") + ".saveComment", new Object[0]), context);
            }
            catch (XWikiException e) {
                this.logger.error("Error while setting active status of user [{}]", (Object)this.getUser(), (Object)e);
            }
        }
    }

    public boolean exists(XWikiContext context) {
        boolean exists = false;
        try {
            XWikiDocument userdoc = this.getUserDocument(context);
            exists = !userdoc.isNew();
        }
        catch (XWikiException e) {
            this.logger.error("Error while checking existing status of user [{}]", (Object)this.getUser(), (Object)e);
        }
        return exists;
    }

    public void setUser(String user) {
        this.fullName = user;
        this.fullNameNull = this.fullName == null;
        this.userReference = null;
        this.userReferenceSet = false;
    }

    public boolean isUserInGroup(String groupName, XWikiContext context) throws XWikiException {
        if (!StringUtils.isEmpty((CharSequence)this.getUser())) {
            XWikiGroupService groupService = context.getWiki().getGroupService(context);
            DocumentReference groupReference = this.getCurrentMixedDocumentReferenceResolver().resolve((Object)groupName, new Object[0]);
            Collection<DocumentReference> groups = groupService.getAllGroupsReferencesForMember(this.getUserReference(), 0, 0, context);
            if (groups.contains(groupReference)) {
                return true;
            }
        }
        return false;
    }

    public boolean isMain() {
        return this.main;
    }

    public void setMain(boolean main) {
        this.main = main;
    }

    public String toString() {
        return this.getUser();
    }

    public boolean equals(Object obj) {
        boolean equals;
        if (super.equals(obj)) {
            return true;
        }
        if (obj instanceof XWikiUser) {
            XWikiUser otherUser = (XWikiUser)obj;
            equals = otherUser.main == this.main && Objects.equals(this.getUserReference(), otherUser.getUserReference());
        } else {
            equals = false;
        }
        return equals;
    }
}

