/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.store.migration.hibernate;

import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.store.XWikiHibernateBaseStore;
import com.xpn.xwiki.store.migration.DataMigrationException;
import com.xpn.xwiki.store.migration.XWikiDBVersion;
import com.xpn.xwiki.store.migration.hibernate.AbstractHibernateDataMigration;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.jdbc.Work;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;

@Component
@Named(value="R72000XWIKI12153")
@Singleton
public class R72000XWIKI12153DataMigration
extends AbstractHibernateDataMigration {
    @Inject
    private EntityReferenceSerializer<String> serializer;

    @Override
    public String getDescription() {
        return "Convert document space name into space reference";
    }

    @Override
    public XWikiDBVersion getVersion() {
        return new XWikiDBVersion(72000);
    }

    @Override
    public void hibernateMigrate() throws DataMigrationException, XWikiException {
        this.getStore().executeWrite(this.getXWikiContext(), new XWikiHibernateBaseStore.HibernateCallback<Object>(){

            @Override
            public Object doInHibernate(Session session) throws HibernateException, XWikiException {
                session.doWork((Work)new R72000Work());
                return Boolean.TRUE;
            }
        });
    }

    private void convert(Connection connection, ResultSet result) throws SQLException {
        if (result.next()) {
            try (PreparedStatement statement = connection.prepareStatement("UPDATE xwikidoc set XWD_WEB = ? WHERE XWD_WEB = ?");){
                do {
                    this.addBatch(statement, result.getString(1));
                } while (result.next());
                statement.executeBatch();
            }
        }
    }

    private void addBatch(PreparedStatement statement, String spaceName) throws SQLException {
        String spaceReference = (String)this.serializer.serialize(new EntityReference(spaceName, EntityType.SPACE), new Object[0]);
        statement.setString(1, spaceReference);
        statement.setString(2, spaceName);
        statement.addBatch();
    }

    private final class R72000Work
    implements Work {
        private R72000Work() {
        }

        public void execute(Connection connection) throws SQLException {
            try (Statement selectStatement = connection.createStatement();
                 ResultSet result = selectStatement.executeQuery("select DISTINCT XWD_WEB from xwikidoc where XWD_WEB like '%.%' OR XWD_WEB like '%\\\\%' OR XWD_WEB like '%:%'");){
                R72000XWIKI12153DataMigration.this.convert(connection, result);
            }
        }
    }
}

