/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.store.migration.hibernate;

import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.store.XWikiHibernateBaseStore;
import com.xpn.xwiki.store.migration.DataMigrationException;
import com.xpn.xwiki.store.migration.XWikiDBVersion;
import com.xpn.xwiki.store.migration.hibernate.AbstractHibernateDataMigration;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import javax.inject.Named;
import javax.inject.Singleton;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.jdbc.Work;
import org.xwiki.component.annotation.Component;

@Component
@Named(value="R54600Translation")
@Singleton
public class R54600TranslationDataMigration
extends AbstractHibernateDataMigration {
    @Override
    public String getDescription() {
        return "Fix any existing mistake with document translation field";
    }

    @Override
    public XWikiDBVersion getVersion() {
        return new XWikiDBVersion(54600);
    }

    @Override
    public void hibernateMigrate() throws DataMigrationException, XWikiException {
        this.getStore().executeWrite(this.getXWikiContext(), new XWikiHibernateBaseStore.HibernateCallback<Object>(){

            @Override
            public Object doInHibernate(Session session) throws HibernateException, XWikiException {
                session.doWork((Work)new R54600Work());
                return Boolean.TRUE;
            }
        });
    }

    private static final class R54600Work
    implements Work {
        private R54600Work() {
        }

        public void execute(Connection connection) throws SQLException {
            try (Statement statement = connection.createStatement();){
                statement.execute("UPDATE xwikidoc set XWD_TRANSLATION = 1 where XWD_TRANSLATION = 0 and (XWD_LANGUAGE is not null and XWD_LANGUAGE <> '')");
                statement.execute("UPDATE xwikidoc set XWD_TRANSLATION = 0 where XWD_TRANSLATION = 1 and (XWD_LANGUAGE is null or XWD_LANGUAGE = '')");
            }
        }
    }
}

