/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.store.migration.hibernate;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocumentArchive;
import com.xpn.xwiki.store.XWikiHibernateBaseStore;
import com.xpn.xwiki.store.XWikiHibernateVersioningStore;
import com.xpn.xwiki.store.XWikiVersioningStoreInterface;
import com.xpn.xwiki.store.migration.DataMigrationException;
import com.xpn.xwiki.store.migration.XWikiDBVersion;
import com.xpn.xwiki.store.migration.hibernate.AbstractHibernateDataMigration;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.query.NativeQuery;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;

@Component
@Named(value="R4359XWIKI1459")
@Singleton
public class R4359XWIKI1459DataMigration
extends AbstractHibernateDataMigration {
    @Inject
    private Logger logger;

    @Override
    public String getDescription() {
        return "See https://jira.xwiki.org/browse/XWIKI-1459";
    }

    @Override
    public XWikiDBVersion getVersion() {
        return new XWikiDBVersion(4359);
    }

    private XWikiHibernateVersioningStore getVersioningStore() throws XWikiException {
        try {
            return (XWikiHibernateVersioningStore)this.componentManager.getInstance(XWikiVersioningStoreInterface.class, "hibernate");
        }
        catch (ComponentLookupException e) {
            throw new XWikiException(3, 3005, String.format("Unable to reach the versioning store for database %s", this.getXWikiContext().getWikiId()), e);
        }
    }

    @Override
    public void hibernateMigrate() throws DataMigrationException, XWikiException {
        this.getStore().executeWrite(this.getXWikiContext(), new XWikiHibernateBaseStore.HibernateCallback<Object>(){

            @Override
            public Object doInHibernate(Session session) throws HibernateException, XWikiException {
                try {
                    List rs;
                    try {
                        rs = session.createSQLQuery("select XWD_ID, XWD_ARCHIVE, XWD_FULLNAME from xwikidoc where (XWD_ARCHIVE is not null and XWD_ARCHIVE <> ' ') order by XWD_VERSION").list();
                    }
                    catch (HibernateException e) {
                        return null;
                    }
                    XWikiContext context = R4359XWIKI1459DataMigration.this.getXWikiContext();
                    XWikiHibernateVersioningStore versioningStore = R4359XWIKI1459DataMigration.this.getVersioningStore();
                    Transaction originalTransaction = versioningStore.getTransaction(context);
                    versioningStore.setSession(null, context);
                    versioningStore.setTransaction(null, context);
                    NativeQuery deleteStatement = session.createSQLQuery("update xwikidoc set XWD_ARCHIVE=' ' where XWD_ID=?");
                    for (Object[] result : rs) {
                        if (R4359XWIKI1459DataMigration.this.logger.isInfoEnabled()) {
                            R4359XWIKI1459DataMigration.this.logger.info("Updating document [{}]...", (Object)result[2].toString());
                        }
                        long docId = Long.parseLong(result[0].toString());
                        String sArchive = result[1].toString();
                        if (sArchive.trim().length() != 0) {
                            XWikiDocumentArchive docArchive = new XWikiDocumentArchive(context.getWikiReference(), docId);
                            try {
                                docArchive.setArchive(sArchive);
                            }
                            catch (XWikiException e) {
                                R4359XWIKI1459DataMigration.this.logger.warn("The RCS archive for [{}] is broken. Internal error [{}]. The history for this document has been reset.", (Object)result[2].toString(), (Object)e.getMessage());
                            }
                            R4359XWIKI1459DataMigration.this.getVersioningStore().saveXWikiDocArchive(docArchive, true, context);
                        } else {
                            R4359XWIKI1459DataMigration.this.logger.warn("Empty revision found for document [{}]. Ignoring non-fatal error.", (Object)result[2].toString());
                        }
                        deleteStatement.setLong(1, docId);
                        deleteStatement.executeUpdate();
                    }
                    versioningStore.setSession(session, context);
                    versioningStore.setTransaction(originalTransaction, context);
                }
                catch (HibernateException e) {
                    throw new XWikiException(3, 3005, R4359XWIKI1459DataMigration.this.getName() + " migration failed", e);
                }
                return Boolean.TRUE;
            }
        });
    }
}

