/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.store.migration.hibernate;

import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.objects.LargeStringProperty;
import com.xpn.xwiki.objects.StringProperty;
import com.xpn.xwiki.store.XWikiHibernateBaseStore;
import com.xpn.xwiki.store.migration.DataMigrationException;
import com.xpn.xwiki.store.migration.XWikiDBVersion;
import com.xpn.xwiki.store.migration.hibernate.AbstractHibernateDataMigration;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Named;
import javax.inject.Singleton;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.xwiki.component.annotation.Component;

@Component
@Named(value="R4340XWIKI883")
@Singleton
public class R4340XWIKI883DataMigration
extends AbstractHibernateDataMigration {
    @Override
    public String getDescription() {
        return "See https://jira.xwiki.org/browse/XWIKI-883";
    }

    @Override
    public XWikiDBVersion getVersion() {
        return new XWikiDBVersion(4340);
    }

    @Override
    public void hibernateMigrate() throws DataMigrationException, XWikiException {
        this.getStore().executeWrite(this.getXWikiContext(), new XWikiHibernateBaseStore.HibernateCallback<Object>(){

            @Override
            public Object doInHibernate(Session session) throws HibernateException {
                Query q = session.createQuery("select s from BaseObject o, StringProperty s where o.className like 'XWiki.XWiki%Rights' and o.id=s.id and (s.name='users' or s.name='groups')", StringProperty.class);
                List lst = q.list();
                if (!lst.isEmpty()) {
                    ArrayList<LargeStringProperty> lst2 = new ArrayList<LargeStringProperty>(lst.size());
                    for (StringProperty stringProperty : lst) {
                        LargeStringProperty lsp = new LargeStringProperty();
                        lsp.setId(stringProperty.getId());
                        lsp.setName(stringProperty.getName());
                        lsp.setValue(stringProperty.getValue());
                        lst2.add(lsp);
                    }
                    for (StringProperty stringProperty : lst) {
                        session.delete((Object)stringProperty);
                    }
                    for (LargeStringProperty largeStringProperty : lst2) {
                        session.save((Object)largeStringProperty);
                    }
                }
                return null;
            }
        });
    }
}

