/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.store.migration.hibernate;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.DeletedAttachment;
import com.xpn.xwiki.doc.XWikiAttachment;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.doc.XWikiLink;
import com.xpn.xwiki.doc.rcs.XWikiRCSNodeInfo;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.BaseObjectReference;
import com.xpn.xwiki.objects.BaseProperty;
import com.xpn.xwiki.objects.DBStringListProperty;
import com.xpn.xwiki.objects.DateProperty;
import com.xpn.xwiki.objects.DoubleProperty;
import com.xpn.xwiki.objects.FloatProperty;
import com.xpn.xwiki.objects.IntegerProperty;
import com.xpn.xwiki.objects.LargeStringProperty;
import com.xpn.xwiki.objects.LongProperty;
import com.xpn.xwiki.objects.StringListProperty;
import com.xpn.xwiki.objects.StringProperty;
import com.xpn.xwiki.stats.impl.DocumentStats;
import com.xpn.xwiki.stats.impl.RefererStats;
import com.xpn.xwiki.stats.impl.VisitStats;
import com.xpn.xwiki.stats.impl.XWikiStats;
import com.xpn.xwiki.store.DatabaseProduct;
import com.xpn.xwiki.store.XWikiHibernateBaseStore;
import com.xpn.xwiki.store.XWikiHibernateStore;
import com.xpn.xwiki.store.migration.DataMigrationException;
import com.xpn.xwiki.store.migration.XWikiDBVersion;
import com.xpn.xwiki.store.migration.hibernate.AbstractHibernateDataMigration;
import com.xpn.xwiki.util.Util;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.hibernate.Session;
import org.hibernate.boot.Metadata;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.mapping.Index;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.PrimaryKey;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Table;
import org.hibernate.query.NativeQuery;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;

@Component
@Named(value="R40000XWIKI6990")
@Singleton
public class R40000XWIKI6990DataMigration
extends AbstractHibernateDataMigration {
    private static final Class<?>[] DOC_CLASSES = new Class[]{XWikiDocument.class, XWikiRCSNodeInfo.class, XWikiLink.class};
    private static final Class<?>[] DOCLINK_CLASSES = new Class[]{XWikiAttachment.class, DeletedAttachment.class};
    private static final Class<?>[] PROPERTY_CLASS = new Class[]{DateProperty.class, DBStringListProperty.class, DoubleProperty.class, FloatProperty.class, IntegerProperty.class, LargeStringProperty.class, LongProperty.class, StringListProperty.class, StringProperty.class, BaseProperty.class};
    private static final Class<?>[] STATS_CLASSES = new Class[]{DocumentStats.class, RefererStats.class, VisitStats.class};
    private static final String INTERNAL = "internal";
    private StatsIdComputer statsIdComputer = new StatsIdComputer();
    @Inject
    private Logger logger;
    @Inject
    @Named(value="current")
    private DocumentReferenceResolver<String> resolver;
    @Inject
    @Named(value="local/uid")
    private EntityReferenceSerializer<String> serializer;
    private int logCount;
    private boolean isMySQL;
    private boolean isMySQLMyISAM;
    private boolean isOracle;
    private boolean isMSSQL;
    private Set<Table> fkTables = new HashSet<Table>();
    private Metadata metadata;

    @Override
    public String getDescription() {
        return "Convert document IDs to use the new improved hash algorithm.";
    }

    @Override
    public XWikiDBVersion getVersion() {
        return new XWikiDBVersion(40000);
    }

    private void logProgress(String message, Object ... params) {
        if (params.length > 0) {
            this.logger.info("[{}] - {}", (Object)this.getName(), (Object)String.format(message, params));
        } else {
            this.logger.info("[{}] - {}", (Object)this.getName(), (Object)message);
        }
    }

    private void processCustomMappings(XWikiHibernateStore store, CustomMappingCallback callback, XWikiContext context) throws XWikiException {
        if (store.executeRead(context, session -> {
            boolean hasProcessedMapping = false;
            try {
                boolean hasDynamicMapping = context.getWiki().hasDynamicCustomMappings();
                SAXReader saxReader = new SAXReader();
                List results = session.createQuery("select doc.fullName, doc.xWikiClassXML from " + XWikiDocument.class.getName() + " as doc where (doc.xWikiClassXML like '<%')").list();
                for (Object[] result : results) {
                    String mapping;
                    String docName = (String)result[0];
                    String classXML = (String)result[1];
                    Element el = saxReader.read((Reader)new StringReader(classXML)).getRootElement().element("customMapping");
                    String string = mapping = el != null ? el.getText() : "";
                    if (StringUtils.isEmpty((CharSequence)mapping) && "XWiki.XWikiPreferences".equals(docName)) {
                        mapping = INTERNAL;
                    }
                    if (!StringUtils.isNotEmpty((CharSequence)mapping)) continue;
                    hasProcessedMapping |= !INTERNAL.equals(mapping) && hasDynamicMapping && store.injectCustomMapping(docName, mapping, context);
                    callback.processCustomMapping(store, docName, mapping, hasDynamicMapping);
                }
            }
            catch (Exception e) {
                throw new XWikiException(3, 3005, this.getName() + " migration failed", e);
            }
            return hasProcessedMapping;
        }).booleanValue()) {
            store.injectUpdatedCustomMappings(context);
        }
    }

    private void convertDbId(Map<Long, Long> map, IdConversionHibernateCallback callback) throws XWikiException {
        int count = map.size() + 1;
        while (!map.isEmpty() && count > map.size()) {
            count = map.size();
            Iterator<Map.Entry<Long, Long>> it = map.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Long, Long> entry = it.next();
                if (map.containsKey(entry.getValue())) continue;
                callback.setOldId(entry.getKey());
                callback.setNewId(entry.getValue());
                try {
                    this.getStore().executeWrite(this.getXWikiContext(), callback);
                }
                catch (Exception e) {
                    throw new XWikiException(3, 3005, this.getName() + " migration failed while converting ID from [" + String.valueOf(entry.getKey()) + "] to [" + String.valueOf(entry.getValue()) + "]", e);
                }
                it.remove();
            }
        }
        if (!map.isEmpty()) {
            throw new XWikiException(3, 3005, this.getName() + " migration failed. Unresolved circular reference during id migration.");
        }
    }

    private List<String[]> getCollectionProperties(PersistentClass pClass) {
        ArrayList<String[]> list = new ArrayList<String[]>();
        if (pClass != null) {
            for (Collection coll : this.getCollection(pClass)) {
                Table collTable = coll.getCollectionTable();
                if (this.fkTables.contains(collTable)) continue;
                list.add(new String[]{collTable.getName(), this.getKeyColumnName(coll)});
            }
        }
        return list;
    }

    private List<Collection> getCollection(PersistentClass pClass) {
        ArrayList<Collection> list = new ArrayList<Collection>();
        if (pClass != null) {
            Iterator it = pClass.getPropertyIterator();
            while (it.hasNext()) {
                Property property = (Property)it.next();
                if (!property.getType().isCollectionType()) continue;
                list.add((Collection)property.getValue());
            }
        }
        return list;
    }

    private PersistentClass getClassMapping(String className) throws DataMigrationException {
        PersistentClass pClass = this.metadata.getEntityBinding(className);
        if (pClass == null) {
            throw new DataMigrationException(String.format("Could not migrate IDs for class [%s] : no hibernate mapping found. For example, this error commonly happens if you have copied a document defining an internally mapped class (like XWiki.XWikiPreferences) and never used the newly created class OR if you have forgotten to customize the hibernate mapping while using your own internally custom mapped class. In the first and most common case, to fix this issue and migrate your wiki, you should delete the offending and useless class definition or the whole document defining that class from your original wiki before the migration.", className));
        }
        return pClass;
    }

    private String getKeyColumnName(Collection coll) {
        return ((Column)coll.getKey().getColumnIterator().next()).getName();
    }

    private String getKeyColumnName(PersistentClass pClass) {
        return this.getColumnName(pClass, null);
    }

    private String getColumnName(PersistentClass pClass, String propertyName) {
        if (propertyName != null) {
            return ((Column)pClass.getProperty(propertyName).getColumnIterator().next()).getName();
        }
        return ((Column)pClass.getKey().getColumnIterator().next()).getName();
    }

    @Override
    public void hibernateMigrate() throws DataMigrationException, XWikiException {
        final HashMap<Long, Long> docs = new HashMap<Long, Long>();
        final ArrayList customMappedClasses = new ArrayList();
        final HashMap<Long, Long> objs = new HashMap<Long, Long>();
        final LinkedList stats = new LinkedList();
        this.getStore().executeRead(this.getXWikiContext(), new XWikiHibernateBaseStore.HibernateCallback<Object>(){

            private void fillDocumentIdConversion(Session session, Map<Long, Long> map) {
                String database = R40000XWIKI6990DataMigration.this.getXWikiContext().getWikiId();
                List results = session.createQuery("select doc.id, doc.space, doc.name, doc.defaultLanguage, doc.language from " + XWikiDocument.class.getName() + " as doc").list();
                for (Object[] result : results) {
                    long oldId = (Long)result[0];
                    String space = (String)result[1];
                    String name = (String)result[2];
                    String defaultLanguage = (String)result[3];
                    String language = (String)result[4];
                    XWikiDocument doc = new XWikiDocument(new DocumentReference(database, space, name));
                    doc.setDefaultLanguage(defaultLanguage);
                    doc.setLanguage(language);
                    long newId = doc.getId();
                    if (oldId == newId) continue;
                    map.put(oldId, newId);
                }
                R40000XWIKI6990DataMigration.this.logProgress("Retrieved %d document IDs to be converted.", map.size());
            }

            private void fillObjectIdConversion(Session session, Map<Long, Long> map) {
                List results = session.createQuery("select obj.id, obj.name, obj.className, obj.number from " + BaseObject.class.getName() + " as obj").list();
                for (Object[] result : results) {
                    long oldId = (Long)result[0];
                    String docName = (String)result[1];
                    String className = (String)result[2];
                    Integer number = (Integer)result[3];
                    BaseObjectReference objRef = new BaseObjectReference(R40000XWIKI6990DataMigration.this.resolver.resolve((Object)className, new Object[0]), number, R40000XWIKI6990DataMigration.this.resolver.resolve((Object)docName, new Object[0]));
                    long newId = Util.getHash((String)R40000XWIKI6990DataMigration.this.serializer.serialize((EntityReference)objRef, new Object[0]));
                    if (oldId == newId) continue;
                    map.put(oldId, newId);
                }
                R40000XWIKI6990DataMigration.this.logProgress("Retrieved %d object IDs to be converted.", map.size());
            }

            private void fillCustomMappingMap(XWikiHibernateStore store, XWikiContext context) throws XWikiException {
                R40000XWIKI6990DataMigration.this.processCustomMappings(store, new CustomMappingCallback(){

                    @Override
                    public void processCustomMapping(XWikiHibernateStore store, String name, String mapping, boolean hasDynamicMapping) throws XWikiException {
                        if (R40000XWIKI6990DataMigration.INTERNAL.equals(mapping) || hasDynamicMapping) {
                            customMappedClasses.add(name);
                        }
                    }
                }, context);
                R40000XWIKI6990DataMigration.this.logProgress("Retrieved %d custom mapped classes to be processed.", customMappedClasses.size());
            }

            private void fillStatsConversionMap(Session session, Class<?> klass, Map<Long, Long> map) {
                List results = session.createQuery("select stats.id, stats.name, stats.number from " + klass.getName() + " as stats").list();
                for (Object[] result : results) {
                    long oldId = (Long)result[0];
                    String statsName = (String)result[1];
                    Integer number = (Integer)result[2];
                    if (statsName != null && !statsName.startsWith(".") && !statsName.endsWith(".")) {
                        long newId = R40000XWIKI6990DataMigration.this.statsIdComputer.getId(statsName, number);
                        if (oldId == newId) continue;
                        map.put(oldId, newId);
                        continue;
                    }
                    R40000XWIKI6990DataMigration.this.logger.debug("Skipping invalid statistical entry [{}] with name [{}]", (Object)oldId, (Object)statsName);
                }
                String klassName = klass.getName().substring(klass.getName().lastIndexOf(46) + 1);
                R40000XWIKI6990DataMigration.this.logProgress("Retrieved %d %s statistics IDs to be converted.", map.size(), klassName.substring(0, klassName.length() - 5).toLowerCase());
            }

            @Override
            public Object doInHibernate(Session session) throws XWikiException {
                try {
                    this.fillDocumentIdConversion(session, docs);
                    this.fillObjectIdConversion(session, objs);
                    if (R40000XWIKI6990DataMigration.this.getStore() instanceof XWikiHibernateStore) {
                        this.fillCustomMappingMap((XWikiHibernateStore)R40000XWIKI6990DataMigration.this.getStore(), R40000XWIKI6990DataMigration.this.getXWikiContext());
                    }
                    for (Class<?> statsClass : STATS_CLASSES) {
                        HashMap<Long, Long> map = new HashMap<Long, Long>();
                        this.fillStatsConversionMap(session, statsClass, map);
                        stats.add(map);
                    }
                    session.clear();
                }
                catch (Exception e) {
                    throw new XWikiException(3, 3005, R40000XWIKI6990DataMigration.this.getName() + " migration failed", e);
                }
                return null;
            }
        });
        this.metadata = this.getStore().getMetadata();
        if (!docs.isEmpty()) {
            final ArrayList<String[]> docsColl = new ArrayList<String[]>();
            for (Class<?> docClass : DOC_CLASSES) {
                docsColl.addAll(this.getCollectionProperties(this.getClassMapping(docClass.getName())));
            }
            for (Class<?> docClass : DOCLINK_CLASSES) {
                docsColl.addAll(this.getCollectionProperties(this.getClassMapping(docClass.getName())));
            }
            this.logProgress("Converting %d document IDs in %d tables and %d collection tables...", docs.size(), DOC_CLASSES.length + DOCLINK_CLASSES.length, docsColl.size());
            final long[] times = new long[DOC_CLASSES.length + DOCLINK_CLASSES.length + docsColl.size()];
            this.convertDbId(docs, new AbstractIdConversionHibernateCallback(){

                @Override
                public void doSingleUpdate() {
                    for (String[] coll : docsColl) {
                        int n = this.timer++;
                        times[n] = times[n] + this.executeSqlIdUpdate(coll[0], coll[1]);
                    }
                    for (Class<?> doclinkClass : DOCLINK_CLASSES) {
                        int n = this.timer++;
                        times[n] = times[n] + this.executeIdUpdate(doclinkClass, "docId");
                    }
                    int n = this.timer++;
                    times[n] = times[n] + this.executeIdUpdate(XWikiLink.class, "docId");
                    int n2 = this.timer++;
                    times[n2] = times[n2] + this.executeIdUpdate(XWikiRCSNodeInfo.class, "id.docId");
                    int n3 = this.timer++;
                    times[n3] = times[n3] + this.executeIdUpdate(XWikiDocument.class, "id");
                }
            });
            if (this.logger.isDebugEnabled()) {
                int timer = 0;
                for (String[] coll : docsColl) {
                    this.logger.debug("Time elapsed for {} collection: {} ms", (Object)coll[0], (Object)(times[timer++] / 1000000L));
                }
                Class<?>[] classArray = DOCLINK_CLASSES;
                int coll = classArray.length;
                for (int i = 0; i < coll; ++i) {
                    Class<?> clazz = classArray[i];
                    this.logger.debug("Time elapsed for {} class: {} ms", (Object)clazz.getName(), (Object)(times[timer++] / 1000000L));
                }
                this.logger.debug("Time elapsed for {} class: {} ms", (Object)XWikiRCSNodeInfo.class.getName(), (Object)(times[timer++] / 1000000L));
                this.logger.debug("Time elapsed for {} class: {} ms", (Object)XWikiDocument.class.getName(), (Object)(times[timer++] / 1000000L));
            }
            this.logProgress("All document IDs has been converted successfully.", new Object[0]);
        } else {
            this.logProgress("No document IDs to convert, skipping.", new Object[0]);
        }
        if (!objs.isEmpty()) {
            final ArrayList<String> classToProcess = new ArrayList<String>();
            final ArrayList<String> customClassToProcess = new ArrayList<String>();
            final ArrayList<String[]> objsColl = new ArrayList<String[]>();
            objsColl.addAll(this.getCollectionProperties(this.getClassMapping(BaseObject.class.getName())));
            for (Class<?> clazz : PROPERTY_CLASS) {
                String className = clazz.getName();
                PersistentClass klass = this.getClassMapping(className);
                objsColl.addAll(this.getCollectionProperties(klass));
                if (this.fkTables.contains(klass.getTable())) continue;
                classToProcess.add(className);
            }
            for (String customClass : customMappedClasses) {
                PersistentClass klass = this.getClassMapping(customClass);
                objsColl.addAll(this.getCollectionProperties(klass));
                if (this.fkTables.contains(klass.getTable())) continue;
                customClassToProcess.add(customClass);
            }
            this.logProgress("Converting %d object IDs in %d tables, %d custom mapped tables and %d collection tables...", objs.size(), classToProcess.size() + 1, customClassToProcess.size(), objsColl.size());
            final long[] times = new long[classToProcess.size() + 1 + customClassToProcess.size() + objsColl.size()];
            this.convertDbId(objs, new AbstractIdConversionHibernateCallback(){

                @Override
                public void doSingleUpdate() {
                    for (String[] coll : objsColl) {
                        int n = this.timer++;
                        times[n] = times[n] + this.executeSqlIdUpdate(coll[0], coll[1]);
                    }
                    for (String customMappedClass : customClassToProcess) {
                        int n = this.timer++;
                        times[n] = times[n] + this.executeIdUpdate(customMappedClass, "id");
                    }
                    for (String propertyClass : classToProcess) {
                        int n = this.timer++;
                        times[n] = times[n] + this.executeIdUpdate(propertyClass, "id.id");
                    }
                    int n = this.timer++;
                    times[n] = times[n] + this.executeIdUpdate(BaseObject.class, "id");
                }
            });
            if (this.logger.isDebugEnabled()) {
                int timer = 0;
                for (String[] stringArray : objsColl) {
                    this.logger.debug("Time elapsed for {} collection: {} ms", (Object)stringArray[0], (Object)(times[timer++] / 1000000L));
                }
                for (String string : customClassToProcess) {
                    this.logger.debug("Time elapsed for {} custom table: {} ms", (Object)string, (Object)(times[timer++] / 1000000L));
                }
                for (String string : classToProcess) {
                    this.logger.debug("Time elapsed for {} property table: {} ms", (Object)string, (Object)(times[timer++] / 1000000L));
                }
                this.logger.debug("Time elapsed for {} class: {} ms", (Object)BaseObject.class.getName(), (Object)(times[timer++] / 1000000L));
            }
            this.logProgress("All object IDs has been converted successfully.", new Object[0]);
        } else {
            this.logProgress("No object IDs to convert, skipping.", new Object[0]);
        }
        for (final Class<?> statsClass : STATS_CLASSES) {
            Map map = (Map)stats.poll();
            String klassName = statsClass.getName().substring(statsClass.getName().lastIndexOf(46) + 1);
            klassName = klassName.substring(0, klassName.length() - 5).toLowerCase();
            if (!map.isEmpty()) {
                final ArrayList<String[]> arrayList = new ArrayList<String[]>();
                arrayList.addAll(this.getCollectionProperties(this.getClassMapping(statsClass.getName())));
                this.logProgress("Converting %d %s statistics IDs in 1 tables and %d collection tables...", map.size(), klassName, arrayList.size());
                final long[] times = new long[arrayList.size() + 1];
                this.convertDbId(map, new AbstractIdConversionHibernateCallback(){

                    @Override
                    public void doSingleUpdate() {
                        for (String[] coll : arrayList) {
                            int n = this.timer++;
                            times[n] = times[n] + this.executeSqlIdUpdate(coll[0], coll[1]);
                        }
                        int n = this.timer++;
                        times[n] = times[n] + this.executeIdUpdate(statsClass, "id");
                    }
                });
                if (this.logger.isDebugEnabled()) {
                    int timer = 0;
                    for (String[] coll : arrayList) {
                        this.logger.debug("Time elapsed for {} collection: {} ms", (Object)coll[0], (Object)(times[timer++] / 1000000L));
                    }
                    this.logger.debug("Time elapsed for {} class: {} ms", (Object)statsClass.getName(), (Object)(times[timer++] / 1000000L));
                }
                this.logProgress("All %s statistics IDs has been converted successfully.", klassName);
                continue;
            }
            this.logProgress("No %s statistics IDs to convert, skipping.", klassName);
        }
    }

    private void appendDropPrimaryKey(StringBuilder sb, Table table) {
        String tableName = table.getName();
        String pkName = table.getPrimaryKey().getName();
        if (this.isMSSQL) {
            try {
                pkName = this.getStore().failSafeExecuteRead(this.getXWikiContext(), session -> (String)session.createSQLQuery("SELECT CONSTRAINT_NAME FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE TABLE_NAME = :tableName AND CONSTRAINT_TYPE = 'PRIMARY KEY'").setParameter("tableName", (Object)tableName).uniqueResult());
            }
            catch (Exception e) {
                this.logger.debug("Fail retrieving the primary key constraints name", (Throwable)e);
            }
        }
        sb.append("    <dropPrimaryKey tableName=\"").append(tableName);
        if (pkName != null) {
            sb.append("\"  constraintName=\"").append(pkName);
        }
        sb.append("\"/>\n");
    }

    private void appendAddPrimaryKey(StringBuilder sb, Table table) {
        PrimaryKey pk = table.getPrimaryKey();
        String pkName = pk.getName();
        sb.append("    <addPrimaryKey tableName=\"").append(table.getName()).append("\"  columnNames=\"");
        Iterator columns = pk.getColumnIterator();
        while (columns.hasNext()) {
            Column column = (Column)columns.next();
            sb.append(column.getName());
            if (!columns.hasNext()) continue;
            sb.append(",");
        }
        if (pkName != null) {
            sb.append("\"  constraintName=\"").append(pkName);
        }
        sb.append("\"/>\n");
    }

    private void appendDropIndex(StringBuilder sb, Index index) {
        sb.append("    <dropIndex indexName=\"").append(index.getName()).append("\"  tableName=\"").append(index.getTable().getName()).append("\"/>\n");
    }

    private void appendAddIndex(StringBuilder sb, Index index) {
        sb.append("    <createIndex tableName=\"").append(index.getTable().getName()).append("\"  indexName=\"").append(index.getName()).append("\">\n");
        Iterator columns = index.getColumnIterator();
        while (columns.hasNext()) {
            Column column = (Column)columns.next();
            sb.append("      <column name=\"").append(column.getName()).append("\"/>\n");
        }
        sb.append("</createIndex>\n");
    }

    private void appendModifyColumn(StringBuilder sb, String table, String column) {
        sb.append("    <modifyDataType tableName=\"").append(table).append("\"  columnName=\"").append(column).append("\" newDataType=\"BIGINT\"/>\n");
        if (this.isMSSQL) {
            sb.append("    <addNotNullConstraint tableName=\"").append(table).append("\"  columnName=\"").append(column).append("\" columnDataType=\"BIGINT\"/>\n");
        }
    }

    private void appendDataTypeChangeLog(StringBuilder sb, Table table, String column) {
        Index index;
        Iterator it;
        String tableName = table.getName();
        sb.append("  <changeSet id=\"R").append(this.getVersion().getVersion()).append('-').append(Util.getHash(String.format("modifyDataType-%s-%s", table, column))).append("\" author=\"xwiki\">\n").append("    <comment>Upgrade identifier [").append(column).append("] from table [").append(tableName).append("] to BIGINT type</comment >\n");
        if (this.isMSSQL) {
            if (table.hasPrimaryKey()) {
                this.appendDropPrimaryKey(sb, table);
            }
            it = table.getIndexIterator();
            while (it.hasNext()) {
                index = (Index)it.next();
                this.appendDropIndex(sb, index);
            }
        }
        this.appendModifyColumn(sb, tableName, column);
        if (this.isMSSQL) {
            if (table.hasPrimaryKey()) {
                this.appendAddPrimaryKey(sb, table);
            }
            it = table.getIndexIterator();
            while (it.hasNext()) {
                index = (Index)it.next();
                this.appendAddIndex(sb, index);
            }
        }
        sb.append("  </changeSet>\n");
        ++this.logCount;
    }

    private void appendDataTypeChangeLogs(StringBuilder sb, PersistentClass pClass) {
        if (pClass != null) {
            this.appendDataTypeChangeLog(sb, pClass.getTable(), this.getKeyColumnName(pClass));
            for (Collection coll : this.getCollection(pClass)) {
                this.appendDataTypeChangeLog(sb, coll.getCollectionTable(), this.getKeyColumnName(coll));
            }
        }
    }

    private boolean checkFKtoPKinTable(Table table) {
        Iterator fki = table.getForeignKeyIterator();
        while (fki.hasNext()) {
            ForeignKey fk = (ForeignKey)fki.next();
            if (!fk.isReferenceToPrimaryKey()) continue;
            return true;
        }
        return false;
    }

    private List<Table> getForeignKeyTables(PersistentClass pClass) {
        ArrayList<Table> list = new ArrayList<Table>();
        if (pClass != null) {
            Table table = pClass.getTable();
            if (this.checkFKtoPKinTable(table)) {
                list.add(table);
            }
            Iterator it = pClass.getPropertyIterator();
            while (it.hasNext()) {
                Collection coll;
                Table collTable;
                Property property = (Property)it.next();
                if (!property.getType().isCollectionType() || !this.checkFKtoPKinTable(collTable = (coll = (Collection)property.getValue()).getCollectionTable())) continue;
                list.add(collTable);
            }
        }
        return list;
    }

    private void appendDropForeignKeyChangeLog(StringBuilder sb, Table table) {
        Iterator fki = table.getForeignKeyIterator();
        String tableName = table.getName();
        sb.append("  <changeSet id=\"R").append(this.getVersion().getVersion()).append('-').append(Util.getHash(String.format("dropForeignKeyConstraint-%s", tableName))).append("\" author=\"xwiki\" runOnChange=\"true\" runAlways=\"true\" failOnError=\"false\">\n").append("    <comment>Drop foreign keys on table [").append(tableName).append("]</comment>\n");
        while (fki.hasNext()) {
            ForeignKey fk = (ForeignKey)fki.next();
            if (!fk.isReferenceToPrimaryKey()) continue;
            sb.append("    <dropForeignKeyConstraint baseTableName=\"").append(tableName).append("\" constraintName=\"").append(fk.getName()).append("\" />\n");
        }
        sb.append("  </changeSet>\n");
        ++this.logCount;
    }

    private void appendAddForeignKeyChangeLog(StringBuilder sb, Table table) {
        Iterator fki = table.getForeignKeyIterator();
        String tableName = table.getName();
        sb.append("  <changeSet id=\"R").append(this.getVersion().getVersion()).append('-').append(Util.getHash(String.format("addForeignKeyConstraint-%s", tableName))).append("\" author=\"xwiki\" runOnChange=\"true\" runAlways=\"true\">\n").append("    <comment>Add foreign keys on table [").append(tableName).append("] to use ON UPDATE CASCADE</comment>\n");
        while (fki.hasNext()) {
            Column column;
            ForeignKey fk = (ForeignKey)fki.next();
            if (!fk.isReferenceToPrimaryKey()) continue;
            sb.append("    <addForeignKeyConstraint constraintName=\"").append(fk.getName()).append("\" baseTableName=\"").append(tableName).append("\"  baseColumnNames=\"");
            Iterator columns = fk.getColumnIterator();
            while (columns.hasNext()) {
                column = (Column)columns.next();
                sb.append(column.getName());
                if (!columns.hasNext()) continue;
                sb.append(",");
            }
            sb.append("\" referencedTableName=\"").append(fk.getReferencedTable().getName()).append("\" referencedColumnNames=\"");
            columns = fk.getReferencedTable().getPrimaryKey().getColumnIterator();
            while (columns.hasNext()) {
                column = (Column)columns.next();
                sb.append(column.getName());
                if (!columns.hasNext()) continue;
                sb.append(",");
            }
            if (this.isOracle) {
                sb.append("\" initiallyDeferred=\"true\"/>\n");
                continue;
            }
            sb.append("\" onUpdate=\"CASCADE\"/>\n");
        }
        sb.append("  </changeSet>\n");
        ++this.logCount;
    }

    private void detectDatabaseProducts(XWikiHibernateBaseStore store) {
        DatabaseProduct product = store.getDatabaseProductName();
        if (product != DatabaseProduct.MYSQL) {
            this.isOracle = product == DatabaseProduct.ORACLE;
            this.isMSSQL = product == DatabaseProduct.MSSQL;
            return;
        }
        this.isMySQL = true;
        String createTable = store.failSafeExecuteRead(this.getXWikiContext(), session -> {
            NativeQuery query = session.createSQLQuery("SHOW TABLE STATUS like 'xwikidoc'");
            return (String)((Object[])query.uniqueResult())[1];
        });
        this.isMySQLMyISAM = createTable != null && createTable.equals("MyISAM");
    }

    @Override
    public String getLiquibaseChangeLog() throws DataMigrationException {
        XWikiHibernateBaseStore store = this.getStore();
        this.metadata = store.getMetadata();
        final StringBuilder sb = new StringBuilder(12000);
        ArrayList<PersistentClass> classes = new ArrayList<PersistentClass>();
        this.detectDatabaseProducts(store);
        if (this.logger.isDebugEnabled()) {
            if (this.isOracle) {
                this.logger.debug("Oracle database detected, proceeding to all updates manually with deferred constraints.");
            }
            if (this.isMySQL && !this.isMySQLMyISAM) {
                this.logger.debug("MySQL innoDB database detected, proceeding to simplified updates with cascaded updates.");
            }
            if (this.isMySQLMyISAM) {
                this.logger.debug("MySQL MyISAM database detected, proceeding to all updates manually without constraints.");
            }
            if (this.isMSSQL) {
                this.logger.debug("Microsoft SQL Server database detected, proceeding to simplified updates with cascaded updates. During data type changes, Primary Key constraints and indexes are temporarily dropped.");
            }
        }
        classes.add(this.getClassMapping(BaseObject.class.getName()));
        for (Class<?> klass : PROPERTY_CLASS) {
            classes.add(this.getClassMapping(klass.getName()));
        }
        for (Class<?> klass : STATS_CLASSES) {
            classes.add(this.getClassMapping(klass.getName()));
        }
        this.logCount = 0;
        if (!this.isMySQLMyISAM) {
            for (PersistentClass klass : classes) {
                this.fkTables.addAll(this.getForeignKeyTables(klass));
            }
        }
        for (Table table : this.fkTables) {
            this.appendDropForeignKeyChangeLog(sb, table);
        }
        for (PersistentClass klass : classes) {
            if (klass.getMappedClass() == StringListProperty.class) continue;
            this.appendDataTypeChangeLogs(sb, klass);
        }
        XWikiContext context = this.getXWikiContext();
        try {
            this.processCustomMappings((XWikiHibernateStore)store, new CustomMappingCallback(){

                @Override
                public void processCustomMapping(XWikiHibernateStore store, String name, String mapping, boolean hasDynamicMapping) throws XWikiException {
                    if (R40000XWIKI6990DataMigration.INTERNAL.equals(mapping) || hasDynamicMapping) {
                        PersistentClass klass = R40000XWIKI6990DataMigration.this.metadata.getEntityBinding(name);
                        if (!R40000XWIKI6990DataMigration.this.isMySQLMyISAM) {
                            List<Table> tables = R40000XWIKI6990DataMigration.this.getForeignKeyTables(klass);
                            for (Table table : tables) {
                                if (R40000XWIKI6990DataMigration.this.fkTables.contains(table)) continue;
                                R40000XWIKI6990DataMigration.this.appendDropForeignKeyChangeLog(sb, table);
                                R40000XWIKI6990DataMigration.this.fkTables.add(table);
                            }
                        }
                        R40000XWIKI6990DataMigration.this.appendDataTypeChangeLogs(sb, klass);
                    }
                }
            }, context);
        }
        catch (XWikiException e) {
            throw new DataMigrationException("Unable to process custom mapped classes during schema updated", e);
        }
        for (Table table : this.fkTables) {
            this.appendAddForeignKeyChangeLog(sb, table);
        }
        if (this.isOracle) {
            this.fkTables.clear();
        }
        this.logProgress("%d schema updates required.", this.logCount);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("About to execute this Liquibase XML: {}", (Object)sb.toString());
        }
        return sb.toString();
    }

    private static final class StatsIdComputer
    extends XWikiStats {
        private static final long serialVersionUID = 1L;
        private String name;
        private int number;

        private StatsIdComputer() {
        }

        public long getId(String name, int number) {
            this.name = name;
            this.number = number;
            return super.getId();
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public int getNumber() {
            return this.number;
        }
    }

    private static interface CustomMappingCallback {
        public void processCustomMapping(XWikiHibernateStore var1, String var2, String var3, boolean var4) throws XWikiException;
    }

    private static interface IdConversionHibernateCallback
    extends XWikiHibernateBaseStore.HibernateCallback<Object> {
        public void setNewId(long var1);

        public void setOldId(long var1);
    }

    private static abstract class AbstractIdConversionHibernateCallback
    extends AbstractUpdateHibernateCallback
    implements IdConversionHibernateCallback {
        public static final String ID = "id";
        public static final String IDID = "id.id";
        public static final String DOCID = "docId";
        private long oldId;
        private long newId;

        private AbstractIdConversionHibernateCallback() {
        }

        @Override
        public void setNewId(long newId) {
            this.newId = newId;
        }

        @Override
        public void setOldId(long oldId) {
            this.oldId = oldId;
        }

        @Override
        public void doUpdate() {
            this.doSingleUpdate();
        }

        public abstract void doSingleUpdate();

        public long executeIdUpdate(Class<?> klass, String field) {
            return this.executeIdUpdate(klass.getName(), field);
        }

        public long executeIdUpdate(String name, String field) {
            StringBuilder sb = new StringBuilder(128);
            sb.append("update ").append(name).append(" klass set klass.").append(field).append('=').append(':').append("newid").append(" where klass.").append(field).append('=').append(':').append("oldid");
            long now = System.nanoTime();
            this.session.createQuery(sb.toString()).setParameter("newid", (Object)this.newId).setParameter("oldid", (Object)this.oldId).executeUpdate();
            return System.nanoTime() - now;
        }

        public long executeSqlIdUpdate(String name, String field) {
            StringBuilder sb = new StringBuilder(128);
            sb.append("UPDATE ").append(name).append(" SET ").append(field).append('=').append(':').append("newid").append(" WHERE ").append(field).append('=').append(':').append("oldid");
            long now = System.nanoTime();
            this.session.createSQLQuery(sb.toString()).setParameter("newid", (Object)this.newId).setParameter("oldid", (Object)this.oldId).executeUpdate();
            return System.nanoTime() - now;
        }
    }

    private static abstract class AbstractUpdateHibernateCallback
    implements XWikiHibernateBaseStore.HibernateCallback<Object> {
        protected static final String NEWID = "newid";
        protected static final String OLDID = "oldid";
        protected Session session;
        public int timer;

        private AbstractUpdateHibernateCallback() {
        }

        @Override
        public Object doInHibernate(Session session) {
            this.timer = 0;
            this.session = session;
            this.doUpdate();
            this.session = null;
            return null;
        }

        public abstract void doUpdate();
    }
}

