/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.store.migration.hibernate;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.store.DatabaseProduct;
import com.xpn.xwiki.store.XWikiHibernateBaseStore;
import com.xpn.xwiki.store.migration.DataMigrationException;
import com.xpn.xwiki.store.migration.XWikiDBVersion;
import com.xpn.xwiki.store.migration.hibernate.AbstractHibernateDataMigration;
import com.xpn.xwiki.web.Utils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.inject.Named;
import javax.inject.Singleton;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.jdbc.Work;
import org.xwiki.component.annotation.Component;

@Component
@Named(value="R35101XWIKI7645")
@Singleton
public class R35101XWIKI7645DataMigration
extends AbstractHibernateDataMigration {
    @Override
    public String getDescription() {
        return "See https://jira.xwiki.org/browse/XWIKI-7645";
    }

    @Override
    public XWikiDBVersion getVersion() {
        return new XWikiDBVersion(35101);
    }

    @Override
    public boolean shouldExecute(XWikiDBVersion startupVersion) {
        boolean shouldExecute = false;
        try {
            this.getStore().beginTransaction(this.getXWikiContext());
            shouldExecute = this.getStore().getDatabaseProductName() == DatabaseProduct.ORACLE;
            this.getStore().endTransaction(this.getXWikiContext(), false);
        }
        catch (XWikiException xWikiException) {
        }
        catch (DataMigrationException dataMigrationException) {
            // empty catch block
        }
        return shouldExecute;
    }

    @Override
    public void hibernateMigrate() throws DataMigrationException, XWikiException {
        this.getStore().executeWrite(this.getXWikiContext(), new XWikiHibernateBaseStore.HibernateCallback<Object>(){

            @Override
            public Object doInHibernate(Session session) throws HibernateException, XWikiException {
                session.doWork((Work)new R35101Work());
                return Boolean.TRUE;
            }
        });
    }

    private static final class R35101Work
    implements Work {
        private R35101Work() {
        }

        public void execute(Connection connection) throws SQLException {
            String[][] tablesToFix = new String[][]{{"XWIKIATTACHMENT_CONTENT", "XWA_CONTENT"}, {"XWIKIATTACHMENT_ARCHIVE", "XWA_ARCHIVE"}};
            Statement stmt = connection.createStatement();
            PreparedStatement getIndexesQuery = connection.prepareStatement("SELECT index_name FROM all_indexes WHERE table_owner=? AND table_name=? AND index_type='NORMAL'");
            for (String[] table : tablesToFix) {
                try {
                    stmt.execute("ALTER TABLE " + table[0] + " MODIFY (" + table[1] + " blob)");
                }
                catch (SQLException ex) {
                    if (ex.getMessage().contains("ORA-22859") || ex.getMessage().contains("ORA-22858")) {
                        return;
                    }
                    throw ex;
                }
                getIndexesQuery.setString(1, this.getSchemaFromWikiName(Utils.getContext().getWikiId()));
                getIndexesQuery.setString(2, table[0]);
                ResultSet indexes = getIndexesQuery.executeQuery();
                while (indexes.next()) {
                    String index = indexes.getString(1);
                    stmt.execute("ALTER INDEX " + index + " REBUILD");
                }
            }
        }

        private String getSchemaFromWikiName(String wikiName) {
            Object schema;
            if (wikiName == null) {
                return null;
            }
            XWikiContext context = Utils.getContext();
            XWiki wiki = context.getWiki();
            if (context.isMainWiki(wikiName)) {
                schema = wiki.Param("xwiki.db");
                if (schema == null) {
                    schema = wikiName;
                }
            } else {
                schema = wikiName.replace('-', '_');
            }
            String prefix = wiki.Param("xwiki.db.prefix", "");
            schema = prefix + (String)schema;
            return ((String)schema).toUpperCase();
        }
    }
}

