/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.store.migration.hibernate;

import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.store.DatabaseProduct;
import com.xpn.xwiki.store.XWikiHibernateBaseStore;
import com.xpn.xwiki.store.migration.DataMigrationException;
import com.xpn.xwiki.store.migration.XWikiDBVersion;
import com.xpn.xwiki.store.migration.hibernate.AbstractHibernateDataMigration;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import javax.inject.Named;
import javax.inject.Singleton;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.jdbc.Work;
import org.xwiki.component.annotation.Component;

@Component
@Named(value="R35100XWIKI7564")
@Singleton
public class R35100XWIKI7564DataMigration
extends AbstractHibernateDataMigration {
    @Override
    public String getDescription() {
        return "See https://jira.xwiki.org/browse/XWIKI-7564";
    }

    @Override
    public XWikiDBVersion getVersion() {
        return new XWikiDBVersion(35100);
    }

    @Override
    public boolean shouldExecute(XWikiDBVersion startupVersion) {
        boolean shouldExecute = false;
        try {
            this.getStore().beginTransaction(this.getXWikiContext());
            shouldExecute = startupVersion.getVersion() > 0 && this.getStore().getDatabaseProductName() == DatabaseProduct.POSTGRESQL;
            this.getStore().endTransaction(this.getXWikiContext(), false);
        }
        catch (XWikiException xWikiException) {
        }
        catch (DataMigrationException dataMigrationException) {
            // empty catch block
        }
        return shouldExecute;
    }

    @Override
    public void hibernateMigrate() throws DataMigrationException, XWikiException {
        this.getStore().executeWrite(this.getXWikiContext(), new XWikiHibernateBaseStore.HibernateCallback<Object>(){

            @Override
            public Object doInHibernate(Session session) throws HibernateException, XWikiException {
                session.doWork((Work)new R35100Work());
                return Boolean.TRUE;
            }
        });
    }

    private static final class R35100Work
    implements Work {
        private R35100Work() {
        }

        public void execute(Connection connection) throws SQLException {
            try (Statement stmt = connection.createStatement();){
                try (BufferedReader in = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("R35100XWIKI7564.sql"), StandardCharsets.UTF_8));){
                    String line;
                    while ((line = in.readLine()) != null) {
                        stmt.addBatch(line);
                    }
                }
                stmt.executeBatch();
            }
            catch (BatchUpdateException ex) {
                if (ex.getNextException() != null && ex.getNextException().getMessage().contains("function lowrite(integer, oid)")) {
                    return;
                }
                throw ex;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

